/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.splitEditor.editorActions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.xaml.fus.XamlEditorFusLogger;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditorOrientation;
import com.jetbrains.rider.xaml.splitEditor.editorActions.XamlSplitEditorActionsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/xaml/splitEditor/editorActions/ChangeEditorOrientationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "ChangeEditorOrientationAction", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.rider"})
public final class ChangeEditorOrientationAction
extends DumbAwareAction
implements Toggleable {
    public ChangeEditorOrientationAction() {
        super(RiderBundle.message("action.xaml.preview.change.orientation.text", new Object[0]), "", AllIcons.Actions.SplitVertically);
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        XamlSplitEditor xamlSplitEditor = XamlSplitEditorActionsUtils.INSTANCE.getSplitEditorFromEvent(e2);
        if (xamlSplitEditor == null) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        e2.getPresentation().setEnabled(true);
        if (xamlSplitEditor.getOrientation() == XamlSplitEditorOrientation.HORIZONTAL) {
            e2.getPresentation().setIcon(AllIcons.Actions.SplitVertically);
        } else {
            e2.getPresentation().setIcon(AllIcons.Actions.SplitHorizontally);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        XamlSplitEditor xamlSplitEditor = XamlSplitEditorActionsUtils.INSTANCE.getSplitEditorFromEvent(e2);
        if (xamlSplitEditor != null) {
            xamlSplitEditor.triggerSplitOrientationChange();
            xamlSplitEditor.setWasEditorStateExplicitlySet(true);
            Project project = e2.getProject();
            String string = xamlSplitEditor.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            XamlEditorFusLogger.INSTANCE.logChangeOrientationEvent(project, string);
        }
    }
}

