/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.workspaceModel;

import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelCache;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RdCustomLocation;
import com.jetbrains.rider.model.RdNullLocation;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemLocation;
import com.jetbrains.rider.model.RdProjectState;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionFolderDescriptor;
import com.jetbrains.rider.model.RdSolutionState;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectState;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.fus.SolutionLifecycleCollector;
import com.jetbrains.rider.projectView.solutionStructure.ProjectMark;
import com.jetbrains.rider.projectView.solutionStructure.SolutionMark;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityVisitor;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.ProjectModelEntityBuilderKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceGlobalListener;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelInitializer;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import com.jetbrains.rider.workspaceModel.ProjectModelEntityPrototypeMerger;
import com.jetbrains.rider.workspaceModel.RiderModuleTypeKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 D2\u00020\u0001:\u0002DEB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J0\u0010\u0019\u001a\u00020\u000e*\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J*\u0010\u001f\u001a\u00020\u000e*\u00020\u00102\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010\"\u001a\u00020\u0017*\u00020\u00102\u0006\u0010#\u001a\u00020$2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0010\u00106\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u001c\u00107\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u00172\b\u00109\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010:\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u00172\b\u00109\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010;\u001a\u00020\u000e2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\u0010\u0010?\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0002J(\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0018\u00101\u001a\n 3*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00104R\u0018\u00105\u001a\n 3*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00104\u00a8\u0006F"}, d2={"Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer;", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelInitializer;", "project", "Lcom/intellij/openapi/project/Project;", "RiderWorkspaceModelInitializer", "(Lcom/intellij/openapi/project/Project;)V", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "value", "", "isColdStart", "()Z", "isApplicable", "initialize", "", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "vfuManager", "updateWorkspaceModel", "solutionMark", "Lcom/jetbrains/rider/projectView/solutionStructure/SolutionMark;", "G", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "solutionEntity", "G", "projectMarks", "", "Lcom/jetbrains/rider/projectView/solutionStructure/ProjectMark;", "parentEntity", "entitiesToRemove", "G", "solutionFolderEntity", "projectMark", "G", "descriptor", "Lcom/jetbrains/rider/model/RdProjectModelItemDescriptor;", "G", "Lcom/jetbrains/rider/model/RdProjectFileDescriptor;", "solutionItem", "Ljava/nio/file/Path;", "G", "Lcom/jetbrains/rider/model/RdSolutionDescriptor;", "G", "Lcom/jetbrains/rider/model/RdSolutionFolderDescriptor;", "G", "Lcom/jetbrains/rider/model/RdProjectDescriptor;", "G", "Lcom/jetbrains/rider/model/RdUnloadProjectDescriptor;", "webSiteProjectUUID", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "Ljava/util/UUID;", "executableProjectUUID", "G", "validateFrontendWorkspaceModel", "frontendEntity", "backendEntity", "G", "G", "errorMessage", "Ljava/util/function/Supplier;", "", "G", "merge", "builder", "existingBuilder", "existingSolutionEntity", "Companion", "MergeKey", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderWorkspaceModelInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderWorkspaceModelInitializer.kt\ncom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer\n+ 2 StructuredLogging.kt\ncom/jetbrains/rd/platform/diagnostics/StructuredLoggingKt\n+ 3 SolutionLifecycleCollector.kt\ncom/jetbrains/rider/projectView/fus/SolutionLifecycleCollector\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,380:1\n139#2,10:381\n161#2,2:401\n150#2,9:403\n172#3,10:391\n1202#4,2:412\n1230#4,4:414\n1202#4,2:418\n1230#4,4:420\n1202#4,2:425\n1230#4,4:427\n1202#4,2:431\n1230#4,4:433\n1#5:424\n15#6:437\n*S KotlinDebug\n*F\n+ 1 RiderWorkspaceModelInitializer.kt\ncom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer\n*L\n59#1:381,10\n59#1:401,2\n59#1:403,9\n60#1:391,10\n140#1:412,2\n140#1:414,4\n167#1:418,2\n167#1:420,4\n325#1:425,2\n325#1:427,4\n328#1:431,2\n328#1:433,4\n32#1:437\n*E\n"})
public final class RiderWorkspaceModelInitializer
extends WorkspaceModelInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private VirtualFileUrlManager virtualFileUrlManager;
    private boolean isColdStart;
    private boolean isApplicable;
    private final UUID webSiteProjectUUID;
    private final UUID executableProjectUUID;
    @NotNull
    private static final Logger logger;
    private static boolean noChangeAssertsMode;

    public RiderWorkspaceModelInitializer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isColdStart = true;
        this.isApplicable = true;
        this.webSiteProjectUUID = UUID.fromString("E24C65DC-7377-472B-9ABA-BC803B73C61A");
        this.executableProjectUUID = UUID.fromString("911E67C6-3D85-4FCE-B560-20A9C3E3FF48");
    }

    public boolean isColdStart() {
        return this.isColdStart;
    }

    public boolean isApplicable() {
        return this.isApplicable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(@NotNull MutableEntityStorage storage, @NotNull VirtualFileUrlManager vfuManager) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)vfuManager, (String)"vfuManager");
        ApplicationKt.getApplication().assertIsNonDispatchThread();
        this.virtualFileUrlManager = vfuManager;
        this.isColdStart = WorkspaceModelExtensionsKt.getSolutionEntity((EntityStorage)((EntityStorage)storage)) == null;
        this.isApplicable = SolutionMark.Companion.canCreateFrom(SolutionHostExtensionsKt.getSolution((Project)this.project));
        logger.info("Workspace model initialization started [IsColdStart=" + this.isColdStart() + "]...");
        Logger logger2 = logger;
        String string = "WorkspaceModel.Init";
        Object var5_5 = null;
        boolean bl = false;
        Logger logger3 = logger2;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = System.nanoTime();
        try {
            boolean bl4 = false;
            SolutionLifecycleCollector solutionLifecycleCollector = SolutionLifecycleCollector.INSTANCE;
            Project project = this.project;
            IdeActivityDefinition ideActivityDefinition = SolutionLifecycleCollector.INSTANCE.getWorkspaceModelInitActivity();
            boolean bl5 = false;
            StructuredIdeActivity structuredIdeActivity = IdeActivityDefinition.started$default((IdeActivityDefinition)ideActivityDefinition, (Project)project, null, (int)2, null);
            try {
                boolean bl6 = false;
                try {
                    RiderModuleTypeKt.getOrCreateRiderModuleEntity(storage);
                    if (this.isApplicable()) {
                        logger.info("SolutionMark parsing started...");
                        SolutionMark solutionMark = SolutionMark.Companion.createFromSolution(SolutionHostExtensionsKt.getSolution((Project)this.project));
                        logger.info("SolutionMark parsing finished");
                        logger.info("Initialize Workspace Model started...");
                        this.updateWorkspaceModel(storage, solutionMark);
                        logger.info("Initialize Workspace Model finished");
                    }
                }
                catch (Throwable throwable) {
                    logger.error(throwable);
                }
            }
            finally {
                if (!project.isDisposed()) {
                    StructuredIdeActivity.finished$default((StructuredIdeActivity)structuredIdeActivity, null, (int)1, null);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                String string2 = throwable instanceof ProcessCanceledException || throwable instanceof CancellationException ? "Cancelled" : "Exception";
                bl3 = true;
                StructuredLoggingKt.sendStructuredLog((Logger)logger3, (String)("<" + string2 + "> \"" + StructuredLoggingKt.getFullKey((String)string) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - l) / 1000000.0) + "ms\u200b\u200c\u200b"));
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (!bl3) {
                    StructuredLoggingKt.sendStructuredLog((Logger)logger3, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)string) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - l) / 1000000.0) + "ms\u200b\u200c\u200b"));
                }
                throw throwable2;
            }
        }
        StructuredLoggingKt.sendStructuredLog((Logger)logger3, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)string) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - l) / 1000000.0) + "ms\u200b\u200c\u200b"));
        ApplicationKt.getApplication().invokeLater(() -> RiderWorkspaceModelInitializer.G(this));
        logger.info("Workspace model initialization finished");
    }

    @TestOnly
    public final void updateWorkspaceModel(@NotNull MutableEntityStorage storage, @NotNull SolutionMark solutionMark) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)solutionMark, (String)"solutionMark");
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((EntityStorage)((EntityStorage)storage));
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        if (projectModelEntity2 == null) {
            object = this.G(solutionMark);
            ProjectModelEntity projectModelEntity3 = this.G(storage, (RdProjectModelItemDescriptor)object, null);
            ProjectModelEntityBuilderKt.addOrUpdateSolutionPointerEntity((MutableEntityStorage)storage, (ProjectModelEntity)projectModelEntity3);
            projectModelEntity2 = projectModelEntity3;
        }
        ProjectModelEntity projectModelEntity4 = projectModelEntity2;
        object = this.G(projectModelEntity4);
        this.G(storage, solutionMark.getProjectMarks(), projectModelEntity4, (Set<ProjectModelEntity>)object);
        for (ProjectModelEntity projectModelEntity5 : ProjectModelEntityExtensionsKt.getRootEntities((Collection)((Collection)object))) {
            this.G(() -> RiderWorkspaceModelInitializer.G(projectModelEntity5));
            storage.removeEntity((WorkspaceEntity)projectModelEntity5);
        }
    }

    private final Set<ProjectModelEntity> G(ProjectModelEntity projectModelEntity) {
        var var2_2 = new ProjectModelEntityVisitor(){
            private final Set<ProjectModelEntity> entities;
            {
                this.entities = new LinkedHashSet<E>();
            }

            public final Set<ProjectModelEntity> getEntities() {
                return this.entities;
            }

            protected ProjectModelEntityVisitor.Result visitProject(ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                this.entities.add(entity);
                return ProjectModelEntityVisitor.Result.Stop;
            }

            protected ProjectModelEntityVisitor.Result visitUnloadedProject(ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                this.entities.add(entity);
                return ProjectModelEntityVisitor.Result.Stop;
            }

            protected ProjectModelEntityVisitor.Result visitSolutionFolder(ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                this.entities.add(entity);
                return ProjectModelEntityVisitor.Result.Continue;
            }

            protected ProjectModelEntityVisitor.Result visitProjectFile(ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                ProjectModelEntity projectModelEntity = entity.getParentEntity();
                if ((projectModelEntity != null ? projectModelEntity.getDescriptor() : null) instanceof RdSolutionFolderDescriptor) {
                    this.entities.add(entity);
                }
                return ProjectModelEntityVisitor.Result.Stop;
            }
        };
        var2_2.visit(projectModelEntity);
        return var2_2.getEntities();
    }

    private final void G(MutableEntityStorage mutableEntityStorage, List<ProjectMark> list2, ProjectModelEntity projectModelEntity, Set<ProjectModelEntity> set) {
        Iterable iterable = projectModelEntity.getChildrenEntities();
        boolean bl = false;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Object object = new LinkedHashMap(n);
        boolean bl2 = false;
        for (Object t : iterable2) {
            ProjectModelEntity projectModelEntity2 = (ProjectModelEntity)t;
            Map map2 = object;
            boolean bl3 = false;
            map2.put(MergeKey.Companion.create(projectModelEntity2), t);
        }
        Map map3 = object;
        for (ProjectMark projectMark : list2) {
            MergeKey mergeKey = new MergeKey(projectMark.getName(), projectMark.getProjectGuid());
            iterable2 = (ProjectModelEntity)map3.get(mergeKey);
            if (iterable2 != null) {
                set.remove(iterable2);
                v0 = iterable2;
            } else {
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectMark.isSolutionFolder() ? (RdProjectModelItemDescriptor)this.G(projectMark) : (projectMark.isHiddenInFilter() ? (RdProjectModelItemDescriptor)this.G(projectMark) : (RdProjectModelItemDescriptor)this.G(projectMark));
                v0 = object = this.G(mutableEntityStorage, rdProjectModelItemDescriptor, projectModelEntity);
            }
            if (projectMark.isSolutionFolder()) {
                this.G(mutableEntityStorage, (ProjectModelEntity)object, projectMark, set);
            }
            this.G(mutableEntityStorage, CollectionsKt.toList((Iterable)projectMark.getChildren()), (ProjectModelEntity)object, set);
        }
    }

    private final void G(MutableEntityStorage mutableEntityStorage, ProjectModelEntity projectModelEntity, ProjectMark projectMark, Set<ProjectModelEntity> set) {
        boolean bl = ProjectModelEntityExtensionsKt.isSolutionFolder((ProjectModelEntity)projectModelEntity);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object object = projectModelEntity.getChildrenEntities();
        boolean bl2 = false;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10)), (int)16);
        Iterable iterable = object;
        Map map2 = new LinkedHashMap(n);
        boolean bl3 = false;
        for (Object t : iterable) {
            ProjectModelEntity projectModelEntity2 = (ProjectModelEntity)t;
            Map map3 = map2;
            boolean bl4 = false;
            map3.put(MergeKey.Companion.create(projectModelEntity2), t);
        }
        Map map4 = map2;
        Iterator iterator2 = projectMark.getSolutionItems().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        object = iterator2;
        while (object.hasNext()) {
            Boolean bl5;
            Object e2 = object.next();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
            Path path = (Path)e2;
            MergeKey mergeKey = new MergeKey(PathsKt.getName((Path)path), null);
            iterable = (ProjectModelEntity)map4.get(mergeKey);
            if (iterable != null) {
                bl5 = set.remove(iterable);
                continue;
            }
            map2 = this.G(path);
            bl5 = this.G(mutableEntityStorage, (RdProjectModelItemDescriptor)map2, projectModelEntity);
        }
    }

    private final ProjectModelEntity G(MutableEntityStorage mutableEntityStorage, RdProjectModelItemDescriptor rdProjectModelItemDescriptor, ProjectModelEntity projectModelEntity) {
        this.G(() -> RiderWorkspaceModelInitializer.G(rdProjectModelItemDescriptor, projectModelEntity));
        VirtualFileUrlManager virtualFileUrlManager = this.virtualFileUrlManager;
        if (virtualFileUrlManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualFileUrlManager");
            virtualFileUrlManager = null;
        }
        VirtualFileUrl virtualFileUrl = ProjectModelEntityBuilderKt.calculateVirtualFileUrl((VirtualFileUrlManager)virtualFileUrlManager, (RdProjectModelItemDescriptor)rdProjectModelItemDescriptor, (ProjectModelEntity)projectModelEntity);
        VirtualFileUrlManager virtualFileUrlManager2 = this.virtualFileUrlManager;
        if (virtualFileUrlManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualFileUrlManager");
            virtualFileUrlManager2 = null;
        }
        List list2 = ProjectModelEntityBuilderKt.calculateAlternativeVirtualFileUrls((VirtualFileUrlManager)virtualFileUrlManager2, (RdProjectModelItemDescriptor)rdProjectModelItemDescriptor, (VirtualFileUrl)virtualFileUrl);
        return ProjectModelEntityBuilderKt.addOrUpdateProjectModelEntity((MutableEntityStorage)mutableEntityStorage, null, (RdProjectModelItemDescriptor)rdProjectModelItemDescriptor, (VirtualFileUrl)virtualFileUrl, (List)list2, (ProjectModelEntity)projectModelEntity);
    }

    private final RdProjectFileDescriptor G(Path path) {
        RdCustomLocation rdCustomLocation = new RdCustomLocation(((Object)path).toString());
        String string = PathsKt.getName((Path)path);
        return new RdProjectFileDescriptor(false, false, "", null, null, string, (RdProjectModelItemLocation)rdCustomLocation);
    }

    private final RdSolutionDescriptor G(SolutionMark solutionMark) {
        RdProjectModelItemLocation rdProjectModelItemLocation;
        Path path = solutionMark.getSolutionPath();
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdCustomLocation(((Object)path2).toString());
        } else {
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdNullLocation();
        }
        RdProjectModelItemLocation rdProjectModelItemLocation2 = rdProjectModelItemLocation;
        Path path3 = solutionMark.getSolutionFilterPath();
        return new RdSolutionDescriptor(RdSolutionState.Default, !SolutionHostExtensionsKt.isExistingSolution((Project)this.project), path3 != null ? ((Object)path3).toString() : null, solutionMark.getSolutionName(), rdProjectModelItemLocation2);
    }

    private final RdSolutionFolderDescriptor G(ProjectMark projectMark) {
        RdProjectModelItemLocation rdProjectModelItemLocation;
        Path path = projectMark.getPath();
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdCustomLocation(((Object)path2).toString());
        } else {
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdNullLocation();
        }
        RdProjectModelItemLocation rdProjectModelItemLocation2 = rdProjectModelItemLocation;
        UUID uUID = projectMark.getProjectGuid();
        String string = projectMark.getName();
        return new RdSolutionFolderDescriptor(null, uUID, string, rdProjectModelItemLocation2);
    }

    private final RdProjectDescriptor G(ProjectMark projectMark) {
        RdProjectModelItemLocation rdProjectModelItemLocation;
        Path path = projectMark.getPath();
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdCustomLocation(((Object)path2).toString());
        } else {
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdNullLocation();
        }
        RdProjectModelItemLocation rdProjectModelItemLocation2 = rdProjectModelItemLocation;
        UUID uUID = projectMark.getProjectGuid();
        String string = projectMark.getName();
        RdProjectState rdProjectState = RdProjectState.Default;
        boolean bl = this.G(projectMark);
        RdProjectType rdProjectType = RdProjectType.Default;
        List list2 = CollectionsKt.emptyList();
        String string2 = projectMark.getName();
        return new RdProjectDescriptor(rdProjectState, null, bl, false, true, rdProjectType, false, null, list2, null, uUID, string, string2, rdProjectModelItemLocation2);
    }

    private final RdUnloadProjectDescriptor G(ProjectMark projectMark) {
        boolean bl;
        RdProjectModelItemLocation rdProjectModelItemLocation;
        Object object;
        Path path = projectMark.getPath();
        if (path != null) {
            object = path;
            boolean bl2 = false;
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdCustomLocation(object.toString());
        } else {
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdNullLocation();
        }
        RdProjectModelItemLocation rdProjectModelItemLocation2 = rdProjectModelItemLocation;
        UUID uUID = projectMark.getProjectGuid();
        RdUnloadProjectState rdUnloadProjectState = RdUnloadProjectState.Filtered;
        Path path2 = projectMark.getPath();
        if (path2 != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = false;
        }
        boolean bl3 = bl;
        object = projectMark.getName();
        String string = RdClientDotnetBundle.INSTANCE.message("WorkspaceModelInitializer.project.descriptor.filtered", new Object[0]);
        return new RdUnloadProjectDescriptor(rdUnloadProjectState, string, bl3, uUID, (String)object, rdProjectModelItemLocation2);
    }

    private final boolean G(ProjectMark projectMark) {
        boolean bl;
        Path path = projectMark.getPath();
        if (path != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = false;
        }
        return bl || Intrinsics.areEqual((Object)projectMark.getProjectTypeGuid(), (Object)this.webSiteProjectUUID) || Intrinsics.areEqual((Object)projectMark.getProjectTypeGuid(), (Object)this.executableProjectUUID);
    }

    public void validateFrontendWorkspaceModel(@Nullable ProjectModelEntity frontendEntity, @Nullable ProjectModelEntity backendEntity) {
        if (!this.isApplicable() || !this.isColdStart()) {
            return;
        }
        logger.info("Workspace model validation started...");
        this.G(frontendEntity, backendEntity);
        logger.info("Workspace model validation finished");
    }

    private final void G(ProjectModelEntity projectModelEntity, ProjectModelEntity projectModelEntity2) {
        Map map2;
        Object object;
        Object object22;
        ProjectModelEntity projectModelEntity3 = projectModelEntity;
        if (projectModelEntity3 == null || (projectModelEntity3 = projectModelEntity3.getDescriptor()) == null) {
            return;
        }
        ProjectModelEntity projectModelEntity4 = projectModelEntity3;
        ProjectModelEntity projectModelEntity5 = projectModelEntity2;
        if (projectModelEntity5 == null || (projectModelEntity5 = projectModelEntity5.getDescriptor()) == null) {
            return;
        }
        ProjectModelEntity projectModelEntity6 = projectModelEntity5;
        if (!Intrinsics.areEqual((Object)projectModelEntity4.getName(), (Object)projectModelEntity6.getName()) && this.G((RdProjectModelItemDescriptor)projectModelEntity6)) {
            logger.error("Mismatching entity name: " + projectModelEntity4.getName() + " != " + projectModelEntity6.getName());
            return;
        }
        if (!Intrinsics.areEqual((Object)projectModelEntity4.getLocation(), (Object)projectModelEntity6.getLocation())) {
            logger.error("Mismatching entity location: " + projectModelEntity4.getLocation() + " != " + projectModelEntity6.getLocation() + " in " + projectModelEntity.getName());
            return;
        }
        if (projectModelEntity4 instanceof RdSolutionDescriptor && projectModelEntity6 instanceof RdSolutionDescriptor) {
            if (((RdSolutionDescriptor)projectModelEntity4).isVirtual() != ((RdSolutionDescriptor)projectModelEntity6).isVirtual()) {
                logger.error("Frontend.isVirtual " + ((RdSolutionDescriptor)projectModelEntity4).isVirtual() + " != Backend.isVirtual " + ((RdSolutionDescriptor)projectModelEntity6).isVirtual() + " in " + projectModelEntity.getName());
            }
            if (!Intrinsics.areEqual((Object)((RdSolutionDescriptor)projectModelEntity4).getFilterFilePath(), (Object)((RdSolutionDescriptor)projectModelEntity6).getFilterFilePath())) {
                logger.error("Frontend.filterFilePath " + ((RdSolutionDescriptor)projectModelEntity4).getFilterFilePath() + " != Backend.filterFilePath " + ((RdSolutionDescriptor)projectModelEntity6).getFilterFilePath() + " in " + projectModelEntity.getName());
            }
        }
        if (projectModelEntity4 instanceof RdUnloadProjectDescriptor && projectModelEntity6 instanceof RdUnloadProjectDescriptor) {
            if (((RdUnloadProjectDescriptor)projectModelEntity4).getState() != ((RdUnloadProjectDescriptor)projectModelEntity6).getState()) {
                logger.error("Frontend.state " + ((RdUnloadProjectDescriptor)projectModelEntity4).getState() + " != Backend.state " + ((RdUnloadProjectDescriptor)projectModelEntity6).getState() + " in " + projectModelEntity.getName());
            }
            if (!Intrinsics.areEqual((Object)((RdUnloadProjectDescriptor)projectModelEntity4).getTooltip(), (Object)((RdUnloadProjectDescriptor)projectModelEntity6).getTooltip())) {
                logger.error("Frontend.tooltip " + ((RdUnloadProjectDescriptor)projectModelEntity4).getTooltip() + " != Backend.tooltip " + ((RdUnloadProjectDescriptor)projectModelEntity6).getTooltip() + " in " + projectModelEntity.getName());
            }
        }
        if (projectModelEntity4 instanceof RdProjectFileDescriptor && projectModelEntity6 instanceof RdProjectFileDescriptor) {
            if (((RdProjectFileDescriptor)projectModelEntity4).isInternal() != ((RdProjectFileDescriptor)projectModelEntity6).isInternal()) {
                logger.error("Frontend.isInternal " + ((RdProjectFileDescriptor)projectModelEntity4).isInternal() + " != Backend.isInternal " + ((RdProjectFileDescriptor)projectModelEntity6).isInternal() + " in " + projectModelEntity.getName());
            }
            if (((RdProjectFileDescriptor)projectModelEntity4).isLinked() != ((RdProjectFileDescriptor)projectModelEntity6).isLinked()) {
                logger.error("Frontend.isLinked " + ((RdProjectFileDescriptor)projectModelEntity4).isLinked() + " != Backend.isLinked " + ((RdProjectFileDescriptor)projectModelEntity6).isLinked() + " in " + projectModelEntity.getName());
            }
            if (!Intrinsics.areEqual((Object)((RdProjectFileDescriptor)projectModelEntity4).getBuildAction(), (Object)((RdProjectFileDescriptor)projectModelEntity6).getBuildAction())) {
                logger.error("Frontend.buildAction " + ((RdProjectFileDescriptor)projectModelEntity4).getBuildAction() + " != Backend.buildAction " + ((RdProjectFileDescriptor)projectModelEntity6).getBuildAction() + " in " + projectModelEntity.getName());
            }
        }
        if (projectModelEntity4 instanceof RdProjectDescriptor && projectModelEntity6 instanceof RdProjectDescriptor && ((RdProjectDescriptor)projectModelEntity4).getDirectoryBased() != ((RdProjectDescriptor)projectModelEntity6).getDirectoryBased()) {
            logger.error("Frontend.directoryBased " + ((RdProjectDescriptor)projectModelEntity4).getDirectoryBased() + " != Backend.directoryBased " + ((RdProjectDescriptor)projectModelEntity6).getDirectoryBased() + " in " + projectModelEntity.getName());
        }
        if (!ProjectModelEntityExtensionsKt.isSolution((ProjectModelEntity)projectModelEntity) && !ProjectModelEntityExtensionsKt.isSolutionFolder((ProjectModelEntity)projectModelEntity)) {
            return;
        }
        Object object3 = projectModelEntity.getChildrenEntities();
        boolean bl = false;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10)), (int)16);
        Iterable iterable = object3;
        Object object4 = new LinkedHashMap(n);
        boolean bl2 = false;
        for (Object object22 : iterable) {
            object = (ProjectModelEntity)object22;
            map2 = object4;
            boolean bl3 = false;
            map2.put(MergeKey.Companion.create((ProjectModelEntity)object), object22);
        }
        Map map3 = object4;
        Iterator iterator2 = projectModelEntity2.getChildrenEntities();
        n = 0;
        int n2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), (int)10)), (int)16);
        object4 = iterator2;
        Map map4 = new LinkedHashMap(n2);
        boolean bl4 = false;
        object22 = object4.iterator();
        while (object22.hasNext()) {
            Object object5 = object = object22.next();
            map2 = map4;
            boolean bl5 = false;
            map2.put(MergeKey.Companion.create((ProjectModelEntity)object5), object);
        }
        object3 = map4;
        if (map3.size() != object3.size()) {
            logger.error("Frontend children " + map3.size() + " != Backend children " + object3.size() + " in " + projectModelEntity.getName());
            return;
        }
        for (MergeKey mergeKey : CollectionsKt.subtract((Iterable)map3.keySet(), (Iterable)object3.keySet())) {
            logger.error("Missing backend entity " + mergeKey);
        }
        for (MergeKey mergeKey : CollectionsKt.subtract((Iterable)object3.keySet(), (Iterable)map3.keySet())) {
            logger.error("Missing frontend entity " + mergeKey);
        }
        for (MergeKey mergeKey : CollectionsKt.intersect((Iterable)map3.keySet(), (Iterable)object3.keySet())) {
            this.G((ProjectModelEntity)map3.get(mergeKey), (ProjectModelEntity)object3.get(mergeKey));
        }
    }

    private final void G(Supplier<String> supplier) {
        if (!noChangeAssertsMode) {
            return;
        }
        if (WorkspaceModelCache.Companion.getInstance(this.project) == null) {
            return;
        }
        logger.error(supplier.get());
    }

    private final boolean G(RdProjectModelItemDescriptor rdProjectModelItemDescriptor) {
        if (rdProjectModelItemDescriptor instanceof RdProjectDescriptor) {
            return Intrinsics.areEqual((Object)rdProjectModelItemDescriptor.getName(), (Object)((RdProjectDescriptor)rdProjectModelItemDescriptor).getOriginalName());
        }
        return true;
    }

    public void merge(@NotNull MutableEntityStorage builder, @NotNull ProjectModelEntity solutionEntity, @NotNull MutableEntityStorage existingBuilder, @NotNull ProjectModelEntity existingSolutionEntity) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)solutionEntity, (String)"solutionEntity");
        Intrinsics.checkNotNullParameter((Object)existingBuilder, (String)"existingBuilder");
        Intrinsics.checkNotNullParameter((Object)existingSolutionEntity, (String)"existingSolutionEntity");
        new ProjectModelEntityPrototypeMerger(builder, existingBuilder).merge(solutionEntity, existingSolutionEntity);
    }

    private static final Unit G(RiderWorkspaceModelInitializer riderWorkspaceModelInitializer, WorkspaceGlobalListener.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"it");
        listener2.cachedModelReady(riderWorkspaceModelInitializer.project);
        return Unit.INSTANCE;
    }

    private static final void G(RiderWorkspaceModelInitializer riderWorkspaceModelInitializer) {
        WorkspaceGlobalListener.INSTANCE.fireEvents(arg_0 -> RiderWorkspaceModelInitializer.G(riderWorkspaceModelInitializer, arg_0));
    }

    private static final String G(ProjectModelEntity projectModelEntity) {
        return "Entity " + projectModelEntity.getName() + " should not be deleted during startup";
    }

    private static final String G(RdProjectModelItemDescriptor rdProjectModelItemDescriptor, ProjectModelEntity projectModelEntity) {
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        return "Entity " + rdProjectModelItemDescriptor.getName() + " -> " + (projectModelEntity2 != null ? projectModelEntity2.getName() : null) + " should not be created during startup";
    }

    static {
        boolean bl = false;
        Logger logger2 = Logger.getInstance(WorkspaceModelUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$Companion;", "", "RiderWorkspaceModelInitializer$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "noChangeAssertsMode", "", "getInstance", "Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer;", "project", "Lcom/intellij/openapi/project/Project;", "enableNoChangeAsserts", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderWorkspaceModelInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderWorkspaceModelInitializer.kt\ncom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,380:1\n17#2,2:381\n*S KotlinDebug\n*F\n+ 1 RiderWorkspaceModelInitializer.kt\ncom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$Companion\n*L\n35#1:381,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderWorkspaceModelInitializer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Object object = componentManager.getService(WorkspaceModelInitializer.class);
            if (object == null) {
                throw new IllegalStateException("Service " + WorkspaceModelInitializer.class + " not found in container " + componentManager);
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.workspaceModel.RiderWorkspaceModelInitializer");
            return (RiderWorkspaceModelInitializer)((Object)object);
        }

        public final void enableNoChangeAsserts(@NotNull Lifetime lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            noChangeAssertsMode = true;
            lifetime.onTermination(Companion::G);
        }

        private static final Unit G() {
            noChangeAssertsMode = false;
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$MergeKey;", "", "name", "", "guid", "Ljava/util/UUID;", "RiderWorkspaceModelInitializer$MergeKey", "(Ljava/lang/String;Ljava/util/UUID;)V", "getName", "()Ljava/lang/String;", "getGuid", "()Ljava/util/UUID;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.rider"})
    public static final class MergeKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @Nullable
        private final UUID guid;

        public MergeKey(@NotNull String name, @Nullable UUID guid) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.guid = guid;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final UUID getGuid() {
            return this.guid;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final UUID component2() {
            return this.guid;
        }

        @NotNull
        public final MergeKey copy(@NotNull String name, @Nullable UUID guid) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new MergeKey(name, guid);
        }

        public static /* synthetic */ MergeKey copy$default(MergeKey mergeKey, String string, UUID uUID, int n, Object object) {
            if ((n & 1) != 0) {
                string = mergeKey.name;
            }
            if ((n & 2) != 0) {
                uUID = mergeKey.guid;
            }
            return mergeKey.copy(string, uUID);
        }

        @NotNull
        public String toString() {
            return "MergeKey(name=" + this.name + ", guid=" + this.guid + ")";
        }

        public int hashCode() {
            int n = this.name.hashCode();
            n = n * 31 + (this.guid == null ? 0 : this.guid.hashCode());
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MergeKey)) {
                return false;
            }
            MergeKey mergeKey = (MergeKey)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)mergeKey.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.guid, (Object)mergeKey.guid);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$MergeKey$Companion;", "", "RiderWorkspaceModelInitializer$MergeKey$Companion", "()V", "create", "Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$MergeKey;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "intellij.rider"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final MergeKey create(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
                return rdProjectModelItemDescriptor instanceof RdProjectDescriptor ? new MergeKey(((RdProjectDescriptor)rdProjectModelItemDescriptor).getOriginalName(), ((RdProjectDescriptor)rdProjectModelItemDescriptor).getOriginalGuid()) : (rdProjectModelItemDescriptor instanceof RdUnloadProjectDescriptor ? new MergeKey(rdProjectModelItemDescriptor.getName(), ((RdUnloadProjectDescriptor)rdProjectModelItemDescriptor).getGuid()) : (rdProjectModelItemDescriptor instanceof RdSolutionFolderDescriptor ? new MergeKey(rdProjectModelItemDescriptor.getName(), ((RdSolutionFolderDescriptor)rdProjectModelItemDescriptor).getGuid()) : (rdProjectModelItemDescriptor instanceof RdProjectFileDescriptor ? new MergeKey(rdProjectModelItemDescriptor.getName(), null) : null)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

