/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.wizard.core.view;

import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.wizard.core.controller.RiderWizardController;
import com.jetbrains.rider.wizard.steps.base.RiderWizardStepModel;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/wizard/core/view/NavBarItemSimple;", "Lcom/intellij/ui/SimpleColoredComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "controller", "Lcom/jetbrains/rider/wizard/core/controller/RiderWizardController;", "model", "Lcom/jetbrains/rider/wizard/steps/base/RiderWizardStepModel;", "NavBarItemSimple", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/wizard/core/controller/RiderWizardController;Lcom/jetbrains/rider/wizard/steps/base/RiderWizardStepModel;)V", "getController", "()Lcom/jetbrains/rider/wizard/core/controller/RiderWizardController;", "G", "", "isSelected", "", "isFirst", "updateUI", "G", "Ljavax/swing/Icon;", "intellij.rider"})
final class NavBarItemSimple
extends SimpleColoredComponent {
    @NotNull
    private final RiderWizardController controller;
    @NotNull
    private final RiderWizardStepModel model;

    public NavBarItemSimple(@NotNull Lifetime lifetime, @NotNull RiderWizardController controller2, @NotNull RiderWizardStepModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.controller = controller2;
        this.model = model;
        this.setIpad((Insets)JBInsets.emptyInsets());
        this.model.isFirst().advise(lifetime, arg_0 -> NavBarItemSimple.G(this, arg_0));
        this.model.isSelected().advise(lifetime, arg_0 -> NavBarItemSimple.b(this, arg_0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (!((Boolean)model.isSelected().getValue()).booleanValue()) {
                    this.getController().move(model);
                }
            }
        });
    }

    @NotNull
    public final RiderWizardController getController() {
        return this.controller;
    }

    private final void G(boolean bl, boolean bl2) {
        this.clear();
        Color color = bl ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        if (!bl2) {
            this.setIcon(this.G());
        }
        this.append(this.model.getNavigationName(), new SimpleTextAttributes(null, color2, null, 1));
    }

    public void updateUI() {
        super.updateUI();
        if (this.getIcon() == null) {
            return;
        }
        this.setIcon(this.G());
    }

    private final Icon G() {
        Icon icon;
        if (!StartupUiUtil.isUnderDarcula()) {
            Icon icon2 = AllIcons.General.ChevronRight;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ChevronRight");
            Color color = UIUtil.getLabelDisabledForeground().brighter().brighter();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(...)");
            icon = IconUtil.colorize$default((Icon)icon2, (Color)color, (boolean)false, (int)4, null);
        } else {
            Icon icon3 = AllIcons.General.ChevronRight;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ChevronRight");
            Color color = UIUtil.getLabelDisabledForeground().brighter();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(...)");
            icon = IconUtil.colorize$default((Icon)icon3, (Color)color, (boolean)false, (int)4, null);
        }
        return icon;
    }

    private static final Unit G(NavBarItemSimple navBarItemSimple, boolean bl) {
        navBarItemSimple.G((Boolean)navBarItemSimple.model.isSelected().getValue(), bl);
        return Unit.INSTANCE;
    }

    private static final Unit b(NavBarItemSimple navBarItemSimple, boolean bl) {
        navBarItemSimple.G(bl, (Boolean)navBarItemSimple.model.isFirst().getValue());
        return Unit.INSTANCE;
    }
}

