/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.trees;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.jetbrains.rider.model.RdUnitTestNodeDescriptorBase;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeDescriptor;
import com.jetbrains.rider.unitTesting.trees.nodes.RiderUnitTestNode;
import com.jetbrains.rider.unitTesting.trees.nodes.RiderUnitTestRootNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0016J\r\u0010\u000e\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001c\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0016J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019J\u0006\u0010\u001a\u001a\u00020\u0017J\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeModel;", "Lcom/intellij/ui/tree/BaseTreeModel;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lcom/intellij/util/concurrency/InvokerSupplier;", "treeDescriptor", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;", "RiderUnitTestTreeModel", "(Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;)V", "root", "Lcom/jetbrains/rider/unitTesting/trees/nodes/RiderUnitTestRootNode;", "invoker", "Lcom/intellij/util/concurrency/Invoker;", "Lorg/jetbrains/annotations/NotNull;", "getRoot", "getInvoker", "isLeaf", "", "node", "", "getChildren", "", "parent", "invoke", "", "action", "Lkotlin/Function0;", "invalidate", "refresh", "path", "Ljavax/swing/tree/TreePath;", "structure", "intellij.rider"})
public final class RiderUnitTestTreeModel
extends BaseTreeModel<AbstractTreeNode<?>>
implements InvokerSupplier {
    @NotNull
    private final RiderUnitTestTreeDescriptor treeDescriptor;
    @NotNull
    private final RiderUnitTestRootNode root;
    @NotNull
    private final Invoker invoker;

    public RiderUnitTestTreeModel(@NotNull RiderUnitTestTreeDescriptor treeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)treeDescriptor, (String)"treeDescriptor");
        this.treeDescriptor = treeDescriptor;
        this.root = new RiderUnitTestRootNode(this.treeDescriptor);
        Invoker invoker = Invoker.forBackgroundThreadWithoutReadAction((Disposable)((Disposable)this));
        Intrinsics.checkNotNullExpressionValue((Object)invoker, (String)"forBackgroundThreadWithoutReadAction(...)");
        this.invoker = invoker;
    }

    @NotNull
    public RiderUnitTestRootNode getRoot() {
        return this.root;
    }

    @NotNull
    public Invoker getInvoker() {
        return this.invoker;
    }

    public boolean isLeaf(@Nullable Object node) {
        if (Intrinsics.areEqual((Object)node, (Object)((Object)this.root))) {
            return false;
        }
        if (node instanceof RiderUnitTestNode) {
            if (Intrinsics.areEqual((Object)((RiderUnitTestNode)((Object)node)).getParent(), (Object)((Object)this.root))) {
                return false;
            }
            List<Integer> list2 = this.treeDescriptor.getChildren(((RiderUnitTestNode)((Object)node)).getId());
            if (list2 != null && CollectionsKt.any((Iterable)list2)) {
                return false;
            }
            RdUnitTestNodeDescriptorBase rdUnitTestNodeDescriptorBase = ((RiderUnitTestNode)((Object)node)).getDescriptor();
            if (rdUnitTestNodeDescriptorBase == null) {
                return true;
            }
            RdUnitTestNodeDescriptorBase rdUnitTestNodeDescriptorBase2 = rdUnitTestNodeDescriptorBase;
            return !rdUnitTestNodeDescriptorBase2.getHasChildren();
        }
        return super.isLeaf(node);
    }

    @NotNull
    public List<AbstractTreeNode<?>> getChildren(@Nullable Object parent) {
        boolean bl = this.invoker.isValidThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        AbstractTreeNode abstractTreeNode = parent instanceof AbstractTreeNode ? (AbstractTreeNode)parent : null;
        if (abstractTreeNode == null) {
            return new ArrayList();
        }
        AbstractTreeNode abstractTreeNode2 = abstractTreeNode;
        Collection collection = abstractTreeNode2.getChildren();
        Intrinsics.checkNotNull((Object)collection, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.ide.util.treeView.AbstractTreeNode<*>>");
        List list2 = TypeIntrinsics.asMutableList((Object)collection);
        for (AbstractTreeNode abstractTreeNode3 : list2) {
            abstractTreeNode3.setParent(abstractTreeNode2);
            abstractTreeNode3.update();
        }
        return list2;
    }

    public final void invoke(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.invoker.invoke(() -> RiderUnitTestTreeModel.G(action2));
    }

    public final void invalidate() {
        this.invoker.invoke(() -> RiderUnitTestTreeModel.G(this));
    }

    public final void refresh(@NotNull TreePath path, boolean structure) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.invoker.invoke(() -> RiderUnitTestTreeModel.G(path, structure, this));
    }

    private static final void G(Function0 function0) {
        function0.invoke();
    }

    private static final void G(RiderUnitTestTreeModel riderUnitTestTreeModel) {
        riderUnitTestTreeModel.treeStructureChanged(null, null, null);
    }

    private static final void G(TreePath treePath, boolean bl, RiderUnitTestTreeModel riderUnitTestTreeModel) {
        boolean bl2;
        Object object = treePath.getLastPathComponent();
        AbstractTreeNode abstractTreeNode = object instanceof AbstractTreeNode ? (AbstractTreeNode)object : null;
        if (abstractTreeNode == null) {
            return;
        }
        AbstractTreeNode abstractTreeNode2 = abstractTreeNode;
        boolean bl3 = abstractTreeNode2.update();
        boolean bl4 = bl2 = bl || !(abstractTreeNode2 instanceof RiderUnitTestNode);
        if (!bl3 && !bl2) {
            return;
        }
        if (bl2) {
            riderUnitTestTreeModel.treeStructureChanged(treePath, null, null);
        } else {
            riderUnitTestTreeModel.treeNodesChanged(treePath, null, null);
        }
    }
}

