/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.panels;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RdUnitTestResultData;
import com.jetbrains.rider.model.RdUnitTestSession;
import com.jetbrains.rider.model.RdUnitTestTreeNode;
import com.jetbrains.rider.stacktrace.RiderStacktraceUtil;
import com.jetbrains.rider.ui.RiderColorKt;
import com.jetbrains.rider.ui.RiderUI;
import com.jetbrains.rider.unitTesting.RiderUnitTestConsoleHyperlinkFilter;
import com.jetbrains.rider.unitTesting.RiderUnitTestExtensionsKt;
import com.jetbrains.rider.unitTesting.RiderUnitTestingBundle;
import com.jetbrains.rider.unitTesting.diagnostics.RiderUnitTestDiagnostics;
import com.jetbrains.rider.unitTesting.panels.RiderDiffLink;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeSessionDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010(\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0012\u0010)\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\f\u0010*\u001a\u00020\u0018*\u00020'H\u0003J\b\u0010,\u001a\u00020\u0014H\u0016J\u0006\u0010-\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010+\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/jetbrains/rider/unitTesting/panels/RiderUnitTestResultPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "treeDescriptor", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeSessionDescriptor;", "session", "Lcom/jetbrains/rider/model/RdUnitTestSession;", "RiderUnitTestResultPanel", "(Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeSessionDescriptor;Lcom/jetbrains/rider/model/RdUnitTestSession;)V", "getSession", "()Lcom/jetbrains/rider/model/RdUnitTestSession;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "ansiEscapeDecoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "diffLineRegex", "Lkotlin/text/Regex;", "G", "", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "unscrambledTrace", "", "asciiEscapePrefix", "force", "", "resultDataConsoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "resultDataIcon", "Ljavax/swing/JLabel;", "resultDataSummary", "resultDataPanel", "navigator", "getNavigator", "()Lcom/intellij/execution/impl/ConsoleViewImpl;", "G", "data", "Lcom/jetbrains/rider/model/RdUnitTestResultData;", "G", "G", "b", "isDisposed", "dispose", "invalidateData", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderUnitTestResultPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderUnitTestResultPanel.kt\ncom/jetbrains/rider/unitTesting/panels/RiderUnitTestResultPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n774#2:275\n865#2,2:276\n*S KotlinDebug\n*F\n+ 1 RiderUnitTestResultPanel.kt\ncom/jetbrains/rider/unitTesting/panels/RiderUnitTestResultPanel\n*L\n169#1:275\n169#1:276,2\n*E\n"})
public final class RiderUnitTestResultPanel
extends BorderLayoutPanel
implements Disposable {
    @NotNull
    private final RiderUnitTestTreeSessionDescriptor treeDescriptor;
    @NotNull
    private final RdUnitTestSession session;
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final AnsiEscapeDecoder ansiEscapeDecoder;
    @NotNull
    private final Regex diffLineRegex;
    @NotNull
    private final ConsoleViewImpl resultDataConsoleView;
    @NotNull
    private final JLabel resultDataIcon;
    @NotNull
    private final JLabel resultDataSummary;
    @NotNull
    private final BorderLayoutPanel resultDataPanel;
    @NotNull
    private final ConsoleViewImpl navigator;
    private boolean isDisposed;

    public RiderUnitTestResultPanel(@NotNull RiderUnitTestTreeSessionDescriptor treeDescriptor, @NotNull RdUnitTestSession session) {
        ConsoleViewImpl consoleViewImpl;
        Intrinsics.checkNotNullParameter((Object)treeDescriptor, (String)"treeDescriptor");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.treeDescriptor = treeDescriptor;
        this.session = session;
        this.project = this.treeDescriptor.getProject();
        this.lifetime = this.treeDescriptor.getLifetime();
        this.ansiEscapeDecoder = new AnsiEscapeDecoder();
        this.diffLineRegex = new Regex(".*Compare\\(Rider\\):?\\s?=?\\s?\u201c?\"(.+)\",\"(.+)\"\u201d?");
        ConsoleViewImpl consoleViewImpl2 = consoleViewImpl = RiderStacktraceUtil.INSTANCE.createRiderConsoleView(this.project, false);
        RiderUnitTestResultPanel riderUnitTestResultPanel = this;
        boolean bl = false;
        consoleViewImpl2.addMessageFilter((Filter)new RiderUnitTestConsoleHyperlinkFilter(consoleViewImpl2.getProject()));
        riderUnitTestResultPanel.resultDataConsoleView = consoleViewImpl;
        this.resultDataIcon = new JLabel();
        this.resultDataSummary = RiderUI.Companion.createLabel();
        this.resultDataPanel = RiderUI.Companion.headerPanel(arg_0 -> RiderUnitTestResultPanel.r(this, arg_0));
        this.navigator = this.resultDataConsoleView;
        this.setMinimumSize(new Dimension(0, 0));
        this.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)RiderUI.Companion.borderPanel(arg_0 -> RiderUnitTestResultPanel.G(this, arg_0)));
        this.session.getResultData().advise(this.lifetime, arg_0 -> RiderUnitTestResultPanel.G(this, arg_0));
        Disposer.register((Disposable)LifetimeDisposableExKt.createNestedDisposable((Lifetime)this.lifetime, (String)"RiderUnitTestResultPanel::Disposable"), (Disposable)((Disposable)this.resultDataConsoleView));
    }

    @NotNull
    public final RdUnitTestSession getSession() {
        return this.session;
    }

    private final void G(ConsoleView consoleView, String string, String string2, boolean bl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string3 = string + "\n";
        Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
        String string4 = ((ConsoleViewImpl)consoleView).getText();
        if (!Intrinsics.areEqual((Object)string3, (Object)string4) || bl) {
            ((ConsoleViewImpl)consoleView).clear();
            String string5 = StringsKt.replace$default((String)string3, (String)string2, (String)"\u001b[", (boolean)false, (int)4, null);
            this.ansiEscapeDecoder.escapeText(string5, ProcessOutputTypes.STDOUT, (arg_0, arg_1) -> RiderUnitTestResultPanel.G(consoleView, this, arg_0, arg_1));
            ((ConsoleViewImpl)consoleView).scrollTo(0);
        }
    }

    static /* synthetic */ void printToConsole$default(RiderUnitTestResultPanel riderUnitTestResultPanel, ConsoleView consoleView, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        riderUnitTestResultPanel.G(consoleView, string, string2, bl);
    }

    @NotNull
    public final ConsoleViewImpl getNavigator() {
        return this.navigator;
    }

    /*
     * Unable to fully structure code
     */
    private final void G(RdUnitTestResultData var1_1, boolean var2_2) {
        block5: {
            block4: {
                var3_3 = this.G(var1_1);
                if (!Intrinsics.areEqual((Object)var3_3, (Object)"")) break block4;
                this.resultDataConsoleView.clear();
                break block5;
            }
            try {
                if (var1_1 == null) ** GOTO lbl-1000
                v0 = var1_1.getNodeKind().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
                if (StringsKt.contains$default((CharSequence)v0, (CharSequence)"xunit", (boolean)false, (int)2, null)) {
                    v1 = "\\x1b[";
                } else lbl-1000:
                // 2 sources

                {
                    v1 = "\\u001b[";
                }
                var4_4 = v1;
                this.G((ConsoleView)this.resultDataConsoleView, var3_3, var4_4, var2_2);
            }
            catch (Exception var4_5) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ void updateResultData$default(RiderUnitTestResultPanel riderUnitTestResultPanel, RdUnitTestResultData rdUnitTestResultData, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riderUnitTestResultPanel.G(rdUnitTestResultData, bl);
    }

    private final String G(RdUnitTestResultData rdUnitTestResultData) {
        String string;
        Object[] objectArray;
        String string2;
        if (rdUnitTestResultData == null) {
            return "";
        }
        boolean bl = rdUnitTestResultData.isTrimmed();
        if (bl) {
            string2 = "The output has reached the limit and was truncated.\nTo view the full output use the 'Open Full Test Output in Editor' action.\nYou can also change the limit in 'File | Settings | Build, Execution, Deployment | Unit Testing'.";
        } else if (!bl) {
            string2 = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string3 = string2;
        if (RiderUnitTestDiagnostics.Companion.isDiagnosticsMode()) {
            objectArray = new String[]{"-------------------------------------------", "Text              = " + rdUnitTestResultData.getText(), "TestCount         = " + rdUnitTestResultData.getTestCount(), "Status            = " + rdUnitTestResultData.getStatus(), "StatusMessage     = " + rdUnitTestResultData.getStatusMessage(), "SessionId         = " + rdUnitTestResultData.getSessionId(), "ElementId         = " + rdUnitTestResultData.getElementId(), "Duration          = " + rdUnitTestResultData.getDuration(), "FailedTestCount   = " + rdUnitTestResultData.getFailedTestCount(), "IsOutdated        = " + rdUnitTestResultData.isOutdated()};
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = "";
        }
        String string4 = string;
        objectArray = ((CharSequence)rdUnitTestResultData.getStatusMessage()).length() == 0 ? "" : (StringsKt.contains$default((CharSequence)rdUnitTestResultData.getExceptionLines(), (CharSequence)rdUnitTestResultData.getStatusMessage(), (boolean)false, (int)2, null) ? "" : (StringsKt.contains$default((CharSequence)rdUnitTestResultData.getOutputLines(), (CharSequence)rdUnitTestResultData.getStatusMessage(), (boolean)false, (int)2, null) ? "" : ((Object)StringsKt.trim((CharSequence)rdUnitTestResultData.getStatusMessage())).toString()));
        Object object = new String[]{objectArray, rdUnitTestResultData.getExceptionLines(), rdUnitTestResultData.getOutputLines(), rdUnitTestResultData.getServiceMessage(), string3, string4};
        List list2 = CollectionsKt.listOf((Object[])object);
        object = list2;
        boolean bl2 = false;
        Object object2 = object;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            String string5 = (String)t;
            boolean bl4 = false;
            boolean bl5 = ((CharSequence)string5).length() > 0;
            if (!bl5) continue;
            collection.add(t);
        }
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null))).toString();
    }

    private final void G(RdUnitTestResultData rdUnitTestResultData) {
        int n = JBUI.scale((int)20);
        RiderUI.Companion.setHeight$default((RiderUI.Companion)RiderUI.Companion, (JComponent)((JComponent)this.resultDataPanel), (int)n, (boolean)false, (boolean)false, (int)4, null);
        if (rdUnitTestResultData != null) {
            this.resultDataSummary.setText(this.b(rdUnitTestResultData));
            this.resultDataIcon.setIcon(RiderUnitTestExtensionsKt.generateUnitTestIcon(rdUnitTestResultData.getIcon(), rdUnitTestResultData.getStatusIcon()));
        } else {
            this.resultDataSummary.setText("");
            this.resultDataIcon.setIcon(null);
        }
        this.resultDataSummary.setToolTipText(this.resultDataSummary.getText());
        this.resultDataPanel.updateUI();
    }

    @NlsSafe
    private final String b(RdUnitTestResultData rdUnitTestResultData) {
        JBColor jBColor;
        int n;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("<html>");
        stringBuilder2.append(XmlStringUtil.escapeString((String)rdUnitTestResultData.getText()));
        String string = rdUnitTestResultData.getTargetFramework();
        CharSequence charSequence = string;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            stringBuilder2.append("<i>");
            stringBuilder2.append("<font color=" + RiderColorKt.toHtml((Color)((Color)RiderUI.CommonPalette.Companion.getGray())) + ">");
            stringBuilder2.append(" (" + string + ")");
            stringBuilder2.append("</font>");
            stringBuilder2.append("</i>");
        }
        if ((n = rdUnitTestResultData.getTestCount()) > 0) {
            stringBuilder2.append("<i>");
            stringBuilder2.append("<font color=" + RiderColorKt.toHtml((Color)((Color)RiderUI.CommonPalette.Companion.getGray())) + ">");
            jBColor = new JBColor[]{Integer.valueOf(n)};
            stringBuilder2.append(" (" + RiderUnitTestingBundle.Companion.message("RiderUnitTestNode.tests", (Object[])jBColor) + ")");
            stringBuilder2.append("</font>");
            stringBuilder2.append("</i>");
        }
        stringBuilder2.append("<font color=" + RiderColorKt.toHtml((Color)((Color)RiderUI.CommonPalette.Companion.getGray())) + ">");
        stringBuilder2.append(" [" + NlsMessages.formatDurationApproximateNarrow((long)rdUnitTestResultData.getDuration()) + "]");
        stringBuilder2.append("</font>");
        jBColor = RiderUnitTestExtensionsKt.toColor(rdUnitTestResultData.getStatus());
        stringBuilder2.append("<font color=" + RiderColorKt.toHtml((Color)((Color)jBColor)) + ">");
        stringBuilder2.append(' ');
        stringBuilder2.append(XmlStringUtil.escapeString((String)rdUnitTestResultData.getStatusMessage()));
        stringBuilder2.append("</font>");
        stringBuilder2.append("</html>");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.resultDataConsoleView.dispose();
        }
    }

    public final void invalidateData() {
        block0: {
            RdUnitTestResultData rdUnitTestResultData = (RdUnitTestResultData)this.session.getResultData().getValue();
            if (rdUnitTestResultData == null) break block0;
            RdUnitTestResultData rdUnitTestResultData2 = rdUnitTestResultData;
            boolean bl = false;
            this.G(rdUnitTestResultData2);
            this.G(rdUnitTestResultData2, true);
        }
    }

    private static final void G(ConsoleView consoleView, RiderUnitTestResultPanel riderUnitTestResultPanel, String string, Key key) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"textChunk");
        Intrinsics.checkNotNullParameter((Object)key, (String)"attributes");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)key);
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
        ConsoleViewContentType consoleViewContentType2 = consoleViewContentType;
        int n = StringsKt.indexOf$default((CharSequence)string, (String)"Compare(Rider)", (int)0, (boolean)false, (int)6, null);
        if (n == -1) {
            ((ConsoleViewImpl)consoleView).print(string, consoleViewContentType2);
            return;
        }
        int n2 = 0;
        while (n != -1) {
            String string2;
            ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)consoleView;
            String string3 = string.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            consoleViewImpl.print(string3, consoleViewContentType2);
            n2 = StringsKt.indexOf$default((CharSequence)string, (char)'\n', (int)n, (boolean)false, (int)4, null);
            if (n2 > 0 && string.charAt(n2 - 1) == '\r') {
                --n2;
            }
            if (n2 == -1) {
                n2 = string.length() - 1;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n, n2), (String)"substring(...)");
            if (riderUnitTestResultPanel.diffLineRegex.matchEntire((CharSequence)string2) != null) {
                MatchResult matchResult;
                boolean bl = false;
                ((ConsoleViewImpl)consoleView).print(RiderUnitTestingBundle.Companion.message("RiderDiffLinkPrefix", new Object[0]) + " ", consoleViewContentType2);
                ConsoleViewImpl consoleViewImpl2 = (ConsoleViewImpl)consoleView;
                String string4 = ExecutionBundle.message((String)"junit.click.to.see.diff.link", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                consoleViewImpl2.printHyperlink(string4, (HyperlinkInfo)new RiderDiffLink(riderUnitTestResultPanel.project, (String)matchResult.getGroupValues().get(2), (String)matchResult.getGroupValues().get(1)));
            } else {
                ((ConsoleViewImpl)consoleView).print(string2, consoleViewContentType2);
            }
            n = StringsKt.indexOf$default((CharSequence)string, (String)"Compare(Rider)", (int)n2, (boolean)false, (int)4, null);
        }
        if (n2 != string.length() - 1) {
            ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)consoleView;
            String string5 = string.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            consoleViewImpl.print(string5, consoleViewContentType2);
        }
    }

    private static final Unit a(RiderUnitTestResultPanel riderUnitTestResultPanel, BorderLayoutPanel borderLayoutPanel) {
        Intrinsics.checkNotNullParameter((Object)borderLayoutPanel, (String)"$this$headerPanel");
        borderLayoutPanel.setBorder((Border)JBUI.Borders.empty());
        borderLayoutPanel.addToLeft((Component)riderUnitTestResultPanel.resultDataIcon);
        borderLayoutPanel.addToCenter((Component)riderUnitTestResultPanel.resultDataSummary);
        return Unit.INSTANCE;
    }

    private static final Unit b(RiderUnitTestResultPanel riderUnitTestResultPanel, BorderLayoutPanel borderLayoutPanel) {
        Intrinsics.checkNotNullParameter((Object)borderLayoutPanel, (String)"$this$headerPanel");
        borderLayoutPanel.setBorder((Border)JBUI.Borders.empty());
        borderLayoutPanel.addToLeft((Component)RiderUI.Companion.headerPanel(arg_0 -> RiderUnitTestResultPanel.a(riderUnitTestResultPanel, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit r(RiderUnitTestResultPanel riderUnitTestResultPanel, BorderLayoutPanel borderLayoutPanel) {
        Intrinsics.checkNotNullParameter((Object)borderLayoutPanel, (String)"$this$headerPanel");
        borderLayoutPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        borderLayoutPanel.add((Component)RiderUI.Companion.headerPanel(arg_0 -> RiderUnitTestResultPanel.b(riderUnitTestResultPanel, arg_0)), (Object)"West");
        return Unit.INSTANCE;
    }

    private static final Unit G(ConsoleViewImpl consoleViewImpl, boolean bl) {
        Editor editor2 = consoleViewImpl.getEditor();
        Intrinsics.checkNotNull((Object)editor2);
        editor2.getSettings().setUseSoftWraps(bl);
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderUnitTestResultPanel riderUnitTestResultPanel, BorderLayoutPanel borderLayoutPanel) {
        Intrinsics.checkNotNullParameter((Object)borderLayoutPanel, (String)"$this$borderPanel");
        borderLayoutPanel.add((Component)riderUnitTestResultPanel.resultDataPanel, (Object)"North");
        ConsoleViewImpl consoleViewImpl = riderUnitTestResultPanel.resultDataConsoleView;
        borderLayoutPanel.add((Component)consoleViewImpl.getComponent(), (Object)"Center");
        consoleViewImpl.setBorder((Border)JBUI.Borders.empty());
        Editor editor2 = consoleViewImpl.getEditor();
        Intrinsics.checkNotNull((Object)editor2);
        editor2.setBorder((Border)JBUI.Borders.empty());
        borderLayoutPanel.setBorder((Border)JBUI.Borders.empty());
        consoleViewImpl.clear();
        consoleViewImpl.allowHeavyFilters();
        riderUnitTestResultPanel.treeDescriptor.getRdHost().getGlobalOptions().getWrapLongLinesInUnitTestSessionOutput().advise(riderUnitTestResultPanel.lifetime, arg_0 -> RiderUnitTestResultPanel.G(consoleViewImpl, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderUnitTestResultPanel riderUnitTestResultPanel, RdUnitTestResultData rdUnitTestResultData) {
        int n = ((Number)InterfacesKt.valueOrDefault((IOptProperty)riderUnitTestResultPanel.session.getTreeDescriptor().getSelectedNode(), (Object)-1)).intValue();
        RdUnitTestTreeNode rdUnitTestTreeNode = riderUnitTestResultPanel.treeDescriptor.getNodeById(n);
        if (rdUnitTestTreeNode != null && rdUnitTestResultData != null && !Intrinsics.areEqual((Object)StringsKt.take((String)rdUnitTestTreeNode.getDescriptor().getText(), (int)150), (Object)StringsKt.take((String)rdUnitTestResultData.getText(), (int)150))) {
            return Unit.INSTANCE;
        }
        riderUnitTestResultPanel.G(rdUnitTestResultData);
        RiderUnitTestResultPanel.updateResultData$default(riderUnitTestResultPanel, rdUnitTestResultData, false, 2, null);
        return Unit.INSTANCE;
    }
}

