/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui.toolWindow;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.toolWindow.ToolWindowStripeManager;
import com.jetbrains.rider.settings.RiderSettingsUpdater;
import com.jetbrains.rider.settings.perApp.RiderPerAppSettingsManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/ui/toolWindow/RiderToolWindowStripeManagerImpl;", "Lcom/intellij/toolWindow/ToolWindowStripeManager;", "RiderToolWindowStripeManagerImpl", "()V", "allowToShowOnStripe", "", "id", "", "isDefaultLayout", "isNewUi", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderToolWindowStripeManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderToolWindowStripeManagerImpl.kt\ncom/jetbrains/rider/ui/toolWindow/RiderToolWindowStripeManagerImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,40:1\n40#2,3:41\n15#3:44\n*S KotlinDebug\n*F\n+ 1 RiderToolWindowStripeManagerImpl.kt\ncom/jetbrains/rider/ui/toolWindow/RiderToolWindowStripeManagerImpl\n*L\n19#1:41,3\n12#1:44\n*E\n"})
public final class RiderToolWindowStripeManagerImpl
implements ToolWindowStripeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<String> idBlackList;
    @NotNull
    public static final String enablePropertyName = "rider.tool.window.stripe.manager.enable";

    public boolean allowToShowOnStripe(@NotNull String id2, boolean isDefaultLayout, boolean isNewUi) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        boolean bl = false;
        Class<RiderPerAppSettingsManager> clazz = RiderPerAppSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(clazz);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        RiderPerAppSettingsManager riderPerAppSettingsManager = (RiderPerAppSettingsManager)object;
        if (RiderSettingsUpdater.Companion.getInstance().isFirstSessionForNewUser()) {
            logger.debug("This is a new user, activate default tool windows blacklist");
            PropertiesComponent.getInstance().setValue(enablePropertyName, "true");
        }
        if (!(bl = PropertiesComponent.getInstance().getBoolean(enablePropertyName))) {
            return true;
        }
        if (riderPerAppSettingsManager.getState().getToolWindowsPerApp()) {
            if (idBlackList.contains(id2)) {
                return riderPerAppSettingsManager.getState().getEnabledBlacklistToolWindowsId().contains(id2);
            }
            return true;
        }
        return isDefaultLayout ? !idBlackList.contains(id2) : true;
    }

    static {
        boolean bl = false;
        Logger logger2 = Logger.getInstance(RiderToolWindowStripeManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
        Object[] objectArray = new String[]{"TODO", "Bookmarks", "IL Viewer", "Unit Tests", "Unit Tests Coverage", "dotTrace Profiler", "dotMemory Profiler", "Dynamic Program Analysis"};
        idBlackList = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/ui/toolWindow/RiderToolWindowStripeManagerImpl$Companion;", "", "RiderToolWindowStripeManagerImpl$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "idBlackList", "", "", "getIdBlackList", "()Ljava/util/List;", "enablePropertyName", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getIdBlackList() {
            return idBlackList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

