/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui.components;

import com.intellij.ide.ui.UISettings;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/ui/components/RdPercentBar;", "Ljavax/swing/JPanel;", "RdPercentBar", "()V", "value", "", "percent", "getPercent", "()I", "setPercent", "(I)V", "Ljava/awt/Color;", "percentPaneColor", "getPercentPaneColor", "()Ljava/awt/Color;", "setPercentPaneColor", "(Ljava/awt/Color;)V", "G", "", "paint", "g1", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "G", "Ljava/awt/Font;", "intellij.rider"})
public final class RdPercentBar
extends JPanel {
    private int percent;
    @NotNull
    private Color percentPaneColor;

    public RdPercentBar() {
        Color color = Color.green;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"green");
        this.percentPaneColor = color;
        this.setOpaque(true);
    }

    public final int getPercent() {
        return this.percent;
    }

    public final void setPercent(int value2) {
        if (this.percent == value2) {
            return;
        }
        this.percent = value2;
        this.G();
    }

    @NotNull
    public final Color getPercentPaneColor() {
        return this.percentPaneColor;
    }

    public final void setPercentPaneColor(@NotNull Color value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (Intrinsics.areEqual((Object)value2, (Object)this.percentPaneColor)) {
            return;
        }
        this.percentPaneColor = value2;
        this.G();
    }

    private final void G() {
        this.invalidate();
        this.repaint();
    }

    @Override
    public void paint(@NotNull Graphics g1) {
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        super.paint(g1);
        Graphics2D graphics2D = (Graphics2D)g1;
        UISettings.Companion.setupAntialiasing((Graphics)graphics2D);
        if (this.percent != 0) {
            int n = this.getWidth() * this.percent / 100;
            graphics2D.setColor(this.percentPaneColor);
            graphics2D.fillRect(0, 0, n, this.getHeight());
        }
        graphics2D.setColor(this.getForeground());
        UIUtil.drawCenteredString((Graphics2D)graphics2D, (Rectangle)new Rectangle(0, 0, this.getWidth(), this.getHeight()), (String)(this.percent + "%"));
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Font font = this.G();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = Math.max(JBUI.scale((int)16), fontMetrics.getHeight());
        return new Dimension(super.getPreferredSize().width, n);
    }

    private final Font G() {
        Font font;
        if (this.getFont() != null) {
            Font font2 = this.getFont();
            font = font2;
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"getFont(...)");
        } else {
            Font font3 = UIUtil.getLabelFont();
            font = font3;
            Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"getLabelFont(...)");
        }
        return font;
    }
}

