/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.stacktrace.filters;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rider.stacktrace.filters.RiderStacktraceNavigationContext;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u000eH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/stacktrace/filters/RiderStacktraceFrame;", "", "fragment", "Lcom/intellij/openapi/editor/Document;", "startLine", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "highlightRange", "RiderStacktraceFrame", "(Lcom/intellij/openapi/editor/Document;ILcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/util/TextRange;)V", "getHighlightRange", "()Lcom/intellij/openapi/util/TextRange;", "getText", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getNavigationContext", "Lcom/jetbrains/rider/stacktrace/filters/RiderStacktraceNavigationContext;", "rangeStart", "rangeEnd", "G", "G", "G", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rider"})
public final class RiderStacktraceFrame {
    @NotNull
    private final Document fragment;
    private final int startLine;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final TextRange highlightRange;

    public RiderStacktraceFrame(@NotNull Document fragment, int startLine, @NotNull TextRange textRange, @NotNull TextRange highlightRange) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)highlightRange, (String)"highlightRange");
        this.fragment = fragment;
        this.startLine = startLine;
        this.textRange = textRange;
        this.highlightRange = highlightRange;
    }

    @NotNull
    public final TextRange getHighlightRange() {
        return this.highlightRange;
    }

    @NotNull
    public final String getText() {
        String string = this.fragment.getText(this.textRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final RiderStacktraceNavigationContext getNavigationContext(int rangeStart, int rangeEnd) {
        int n = this.highlightRange.getStartOffset();
        TextRange textRange = new TextRange(n + rangeStart, n + rangeEnd);
        int n2 = this.highlightRange.contains(textRange.getStartOffset());
        if (_Assertions.ENABLED && n2 == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        n2 = Math.max(this.fragment.getLineNumber(textRange.getStartOffset()) - 5, 0);
        int n3 = this.fragment.getLineStartOffset(n2);
        int n4 = Math.min(this.fragment.getLineNumber(textRange.getEndOffset()) + 5, this.fragment.getLineCount() - 1);
        int n5 = this.fragment.getLineEndOffset(n4);
        int n6 = this.highlightRange.getStartOffset() - n3;
        CharSequence charSequence = this.fragment.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        String string = ((Object)charSequence.subSequence(n3, n5)).toString();
        return new RiderStacktraceNavigationContext(string, n6);
    }

    private final Document G() {
        return this.fragment;
    }

    private final int G() {
        return this.startLine;
    }

    private final TextRange G() {
        return this.textRange;
    }

    @NotNull
    public final TextRange component4() {
        return this.highlightRange;
    }

    @NotNull
    public final RiderStacktraceFrame copy(@NotNull Document fragment, int startLine, @NotNull TextRange textRange, @NotNull TextRange highlightRange) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)highlightRange, (String)"highlightRange");
        return new RiderStacktraceFrame(fragment, startLine, textRange, highlightRange);
    }

    public static /* synthetic */ RiderStacktraceFrame copy$default(RiderStacktraceFrame riderStacktraceFrame, Document document, int n, TextRange textRange, TextRange textRange2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            document = riderStacktraceFrame.fragment;
        }
        if ((n2 & 2) != 0) {
            n = riderStacktraceFrame.startLine;
        }
        if ((n2 & 4) != 0) {
            textRange = riderStacktraceFrame.textRange;
        }
        if ((n2 & 8) != 0) {
            textRange2 = riderStacktraceFrame.highlightRange;
        }
        return riderStacktraceFrame.copy(document, n, textRange, textRange2);
    }

    @NotNull
    public String toString() {
        return "RiderStacktraceFrame(fragment=" + this.fragment + ", startLine=" + this.startLine + ", textRange=" + this.textRange + ", highlightRange=" + this.highlightRange + ")";
    }

    public int hashCode() {
        int n = this.fragment.hashCode();
        n = n * 31 + Integer.hashCode(this.startLine);
        n = n * 31 + this.textRange.hashCode();
        n = n * 31 + this.highlightRange.hashCode();
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RiderStacktraceFrame)) {
            return false;
        }
        RiderStacktraceFrame riderStacktraceFrame = (RiderStacktraceFrame)other;
        if (!Intrinsics.areEqual((Object)this.fragment, (Object)riderStacktraceFrame.fragment)) {
            return false;
        }
        if (this.startLine != riderStacktraceFrame.startLine) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textRange, (Object)riderStacktraceFrame.textRange)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.highlightRange, (Object)riderStacktraceFrame.highlightRange);
    }
}

