/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.stacktrace.filters;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rider.model.ApplyFilterRequestSettings;
import com.jetbrains.rider.stacktrace.filters.DotNetConsoleExceptionFilter;
import com.jetbrains.rider.stacktrace.filters.RiderExceptionFilterBase;
import com.jetbrains.rider.stacktrace.filters.RiderStacktraceFrame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/stacktrace/filters/DotNetConsoleExceptionFilter;", "Lcom/jetbrains/rider/stacktrace/filters/RiderExceptionFilterBase;", "project", "Lcom/intellij/openapi/project/Project;", "DotNetConsoleExceptionFilter", "(Lcom/intellij/openapi/project/Project;)V", "getFramesIterator", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/rider/stacktrace/filters/RiderStacktraceFrame;", "copiedFragment", "Lcom/intellij/openapi/editor/Document;", "getApplyFilterSettings", "Lcom/jetbrains/rider/model/ApplyFilterRequestSettings;", "Companion", "intellij.rider"})
public final class DotNetConsoleExceptionFilter
extends RiderExceptionFilterBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex stackTraceRegex = new Regex("^\\s*(at|\u0432|bei)\\s(?:(?<namespace>[\\p{L}\\d_.]*)\\.)?(?<class>[\\p{L}\\d_.+`]*(\\.[\\p{L}\\d_.+<>`]+)?(?<classGenerics>\\[(([\\p{L}\\d_])+(?:,\\s*)?)*])?)\\.(?<method>[\\p{L}\\d_<>`|]*(?<methodGenerics>\\[(([\\p{L}\\d_])+(?:,\\s*)?)*])?)\\s*\\((?:(?<parameter>[\\p{L}\\d`_+.]+(?<parameterGenerics>\\[(([\\p{L}\\d_])+(?:,\\s*)?)*])?(?:|&|\\*)* [\\p{L}\\d_]+)(?:, )?)*\\)");
    @NotNull
    private static final Regex stackTraceStartRegex = new Regex("^\\s*(at|\u0432|bei)\\s");
    @NotNull
    private static final Regex exceptionClassRegex = new Regex("([\\d\\p{L}]*)Exception");

    public DotNetConsoleExceptionFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public Sequence<RiderStacktraceFrame> getFramesIterator(@NotNull Document copiedFragment) {
        Intrinsics.checkNotNullParameter((Object)copiedFragment, (String)"copiedFragment");
        List list2 = new ArrayList();
        int n = copiedFragment.getLineCount();
        for (int j = 0; j < n; ++j) {
            String string;
            int n2 = copiedFragment.getLineStartOffset(j);
            int n3 = copiedFragment.getLineEndOffset(j);
            TextRange textRange = new TextRange(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)copiedFragment.getText(textRange), (String)"getText(...)");
            if (!stackTraceStartRegex.containsMatchIn((CharSequence)string) && !exceptionClassRegex.containsMatchIn((CharSequence)string)) continue;
            list2.add(new RiderStacktraceFrame(copiedFragment, j, textRange, textRange));
        }
        return (Sequence)new Sequence<RiderStacktraceFrame>((List<RiderStacktraceFrame>)list2){
            private int index;
            final /* synthetic */ List<RiderStacktraceFrame> $frames;
            {
                this.$frames = $frames;
            }

            public getFramesIterator.iterator.1 iterator() {
                return new Iterator<RiderStacktraceFrame>(this, this.$frames){
                    final /* synthetic */ getFramesIterator.1 this$0;
                    final /* synthetic */ List<RiderStacktraceFrame> $frames;
                    {
                        this.this$0 = $receiver;
                        this.$frames = $frames;
                    }

                    public boolean hasNext() {
                        return getFramesIterator.1.access$getIndex$p(this.this$0) < this.$frames.size();
                    }

                    public RiderStacktraceFrame next() {
                        int n = getFramesIterator.1.access$getIndex$p(this.this$0);
                        getFramesIterator.1.access$setIndex$p(this.this$0, n + 1);
                        return this.$frames.get(n);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }

            public static final /* synthetic */ int access$getIndex$p(getFramesIterator.1 $this) {
                return $this.index;
            }

            public static final /* synthetic */ void access$setIndex$p(getFramesIterator.1 $this, int n) {
                $this.index = n;
            }
        };
    }

    @Override
    @NotNull
    public ApplyFilterRequestSettings getApplyFilterSettings() {
        return new ApplyFilterRequestSettings(true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/stacktrace/filters/DotNetConsoleExceptionFilter$Companion;", "", "DotNetConsoleExceptionFilter$Companion", "()V", "stackTraceRegex", "Lkotlin/text/Regex;", "getStackTraceRegex", "()Lkotlin/text/Regex;", "stackTraceStartRegex", "getStackTraceStartRegex", "exceptionClassRegex", "getExceptionClassRegex", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getStackTraceRegex() {
            return stackTraceRegex;
        }

        @NotNull
        public final Regex getStackTraceStartRegex() {
            return stackTraceStartRegex;
        }

        @NotNull
        public final Regex getExceptionClassRegex() {
            return exceptionClassRegex;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

