/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.stacktrace;

import com.intellij.openapi.application.ClipboardAnalyzeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.stacktrace.RiderStacktraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/stacktrace/RiderStacktraceClipboardListener;", "Lcom/intellij/openapi/application/ClipboardAnalyzeListener;", "RiderStacktraceClipboardListener", "()V", "ON_THE_FLY_KEY", "", "getON_THE_FLY_KEY", "()Ljava/lang/String;", "stacktraceMark", "ident", "stub", "full_qualified_name", "parameter", "parameter_list", "prepositions", "STACKTRACE_LINE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "linesToAnalyze", "", "canHandle", "", "value", "handle", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderStacktraceClipboardListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderStacktraceClipboardListener.kt\ncom/jetbrains/rider/stacktrace/RiderStacktraceClipboardListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n774#2:56\n865#2,2:57\n*S KotlinDebug\n*F\n+ 1 RiderStacktraceClipboardListener.kt\ncom/jetbrains/rider/stacktrace/RiderStacktraceClipboardListener\n*L\n36#1:56\n36#1:57,2\n*E\n"})
public final class RiderStacktraceClipboardListener
extends ClipboardAnalyzeListener {
    @NotNull
    private final String ON_THE_FLY_KEY;
    @NotNull
    private final String stacktraceMark;
    @NotNull
    private final String ident;
    @NotNull
    private final String stub;
    @NotNull
    private final String full_qualified_name;
    @NotNull
    private final String parameter;
    @NotNull
    private final String parameter_list;
    @NotNull
    private final String prepositions;
    private final Pattern STACKTRACE_LINE;
    private final int linesToAnalyze;

    public RiderStacktraceClipboardListener() {
        this.ON_THE_FLY_KEY = "rider.analyze.exceptions.on.the.fly";
        this.stacktraceMark = "#stacktrace";
        this.ident = "[_`a-zA-Z0-9]+";
        this.stub = "<\\.?[_`a-zA-Z0-9]*>" + this.ident;
        this.full_qualified_name = this.ident + "(\\.(" + this.ident + "|" + this.stub + "))*";
        this.parameter = this.full_qualified_name + "(\\[\\])? " + this.ident;
        this.parameter_list = "(" + this.parameter + "(, " + this.parameter + ")*)";
        this.prepositions = "(at|\u0432|bei|en|kohteessa|\u5834\u6240)";
        this.STACKTRACE_LINE = Pattern.compile("^[\\t ]*" + this.prepositions + " " + this.full_qualified_name + "\\s?(\\(" + this.parameter_list + "*\\))");
        this.linesToAnalyze = 50;
    }

    @NotNull
    public final String getON_THE_FLY_KEY() {
        return this.ON_THE_FLY_KEY;
    }

    public boolean canHandle(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!Registry.Companion.is(this.ON_THE_FLY_KEY)) {
            return false;
        }
        String string = StringsKt.substringAfterLast$default((String)value2, (char)'\n', null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)this.stacktraceMark, (boolean)false, (int)2, null)) {
            return true;
        }
        int n = 0;
        Object object = new String[]{"\n"};
        object = CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)value2, (String[])object, (boolean)false, (int)0, (int)6, null), (int)this.linesToAnalyze);
        boolean bl = false;
        Object object2 = object;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            String string2 = (String)t;
            boolean bl3 = false;
            if (!(!StringsKt.isBlank((CharSequence)string2))) continue;
            collection.add(t);
        }
        List list2 = (List)collection;
        for (String string3 : list2) {
            if (this.STACKTRACE_LINE.matcher(string3).lookingAt()) {
                if (++n <= 2) continue;
                return true;
            }
            n = 0;
        }
        return n > 2;
    }

    protected void handle(@NotNull Project project, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!SolutionHostExtensionsKt.getHasSolution((Project)project)) {
            return;
        }
        IOptProperty iOptProperty = SolutionHostExtensionsKt.getSolution((Project)project).isLoaded();
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)iOptProperty))) {
            return;
        }
        RiderStacktraceUtil.addAnalyzeExceptionTab$default(RiderStacktraceUtil.INSTANCE, project, value2, null, 4, null);
    }
}

