/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.exportImportWorkaround;

import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.configurationStore.ImportSettingsAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.settings.exportImportWorkaround.ImportSession;
import com.jetbrains.rider.settings.exportImportWorkaround.Session;
import com.jetbrains.rider.settings.exportImportWorkaround.SettingsHelper;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/settings/exportImportWorkaround/RiderImportSettingsAction;", "Lcom/intellij/configurationStore/ImportSettingsAction;", "RiderImportSettingsAction", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "session", "Lcom/jetbrains/rider/settings/exportImportWorkaround/ImportSession;", "helper", "Lcom/jetbrains/rider/settings/exportImportWorkaround/SettingsHelper;", "getExportableComponents", "", "Lcom/intellij/configurationStore/FileSpec;", "", "Lcom/intellij/configurationStore/ExportableItem;", "relativePaths", "", "", "getMarkedComponents", "components", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doImport", "saveFile", "Ljava/nio/file/Path;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderImportSettingsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderImportSettingsAction.kt\ncom/jetbrains/rider/settings/exportImportWorkaround/RiderImportSettingsAction\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n*L\n1#1,83:1\n13#2:84\n15#3:85\n84#3,3:86\n22#4,6:89\n*S KotlinDebug\n*F\n+ 1 RiderImportSettingsAction.kt\ncom/jetbrains/rider/settings/exportImportWorkaround/RiderImportSettingsAction\n*L\n22#1:84\n22#1:85\n50#1:86,3\n78#1:89,6\n*E\n"})
public final class RiderImportSettingsAction
extends ImportSettingsAction {
    @NotNull
    private final Logger LOG;
    @Nullable
    private ImportSession session;
    @Nullable
    private SettingsHelper helper;

    public RiderImportSettingsAction() {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(RiderImportSettingsAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.LOG = logger2;
    }

    @NotNull
    protected Map<FileSpec, List<ExportableItem>> getExportableComponents(@NotNull Set<String> relativePaths) {
        Intrinsics.checkNotNullParameter(relativePaths, (String)"relativePaths");
        Object object = this.session;
        if (object == null || (object = ((Session)object).getExportableComponents(super.getExportableComponents(relativePaths))) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @NotNull
    protected Set<ExportableItem> getMarkedComponents(@NotNull Set<ExportableItem> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Object object = this.session;
        if (object == null || (object = ((ImportSession)object).processCheckedItems(components)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DataContext dataContext2 = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        ClientAppSession clientAppSession = FrontendSessionsUtilKt.getFrontendAppSession((DataContext)dataContext2);
        if (clientAppSession == null) {
            return;
        }
        this.helper = SettingsHelper.Companion.getInstance(clientAppSession);
        try {
            super.actionPerformed(e2);
        }
        finally {
            ImportSession importSession = this.session;
            this.session = null;
            this.helper = null;
            if (importSession != null) {
                Disposer.dispose((Disposable)importSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImport(@NotNull Path saveFile) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        Object object2 = this.LOG;
        boolean bl2 = false;
        Logger logger2 = object2;
        try {
            File file2;
            object = logger2;
            bl = false;
            boolean bl3 = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(saveFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                file2 = null;
            } else {
                boolean bl4;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(saveFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Object object3 = new ZipInputStream(inputStream);
                Serializable serializable = null;
                try {
                    boolean bl5;
                    block19: {
                        ZipInputStream zipInputStream = (ZipInputStream)object3;
                        boolean bl6 = false;
                        while (zipInputStream.getNextEntry() != null) {
                            ZipEntry zipEntry;
                            String string = zipEntry.getName();
                            if (!Intrinsics.areEqual((Object)string, (Object)"IntelliJ IDEA Global Settings")) continue;
                            bl5 = true;
                            break block19;
                        }
                        bl5 = false;
                    }
                    bl4 = bl5;
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)serializable);
                }
                boolean bl7 = bl4;
                if (!bl7) {
                    file2 = null;
                } else {
                    File file3 = FileUtilRt.createTempDirectory((String)"RiderImportDotSettingsFolder", (String)"", (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"createTempDirectory(...)");
                    object3 = file3;
                    File file4 = FileUtilRt.createTempFile((String)"settings.", (String)".jar", (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"createTempFile(...)");
                    serializable = file4;
                    FileUtil.copy((File)saveFile.toFile(), (File)serializable);
                    ZipUtil.extract((File)serializable, (File)object3, RiderImportSettingsAction::G);
                    Object[] objectArray = ((File)object3).listFiles();
                    if (objectArray.length != 1) {
                        if (objectArray.length > 1) {
                            throw new IllegalArgumentException("files.size > 1");
                        }
                        file2 = null;
                    } else {
                        Intrinsics.checkNotNull((Object)objectArray);
                        file2 = (File)ArraysKt.first((Object[])objectArray);
                    }
                }
            }
            object = Result.constructor-impl(file2);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        File file5 = (File)LoggerKt.getOrLogException((Object)object, (Logger)object2);
        Object object4 = this.helper;
        if (object4 == null || (object4 = object4.createImportSession(file5)) == null) {
            return;
        }
        object2 = object4;
        this.session = object2;
        Disposable disposable = (Disposable)object2;
        boolean bl8 = false;
        try {
            object = (ImportSession)disposable;
            bl = false;
            super.doImport(saveFile);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static final boolean G(File file2, String string) {
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.endsWith$default((String)string, (String)".DotSettings", (boolean)false, (int)2, null);
    }
}

