/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.exportImportWorkaround;

import com.intellij.configurationStore.ExportSettingsAction;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.settings.exportImportWorkaround.ExportSession;
import com.jetbrains.rider.settings.exportImportWorkaround.Session;
import com.jetbrains.rider.settings.exportImportWorkaround.SettingsHelper;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007H\u0014J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/settings/exportImportWorkaround/RiderExportSettingsAction;", "Lcom/intellij/configurationStore/ExportSettingsAction;", "RiderExportSettingsAction", "()V", "session", "Lcom/jetbrains/rider/settings/exportImportWorkaround/ExportSession;", "getExportableComponents", "", "Lcom/intellij/configurationStore/FileSpec;", "", "Lcom/intellij/configurationStore/ExportableItem;", "exportSettings", "", "saveFile", "Ljava/nio/file/Path;", "markedComponents", "", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rider"})
public final class RiderExportSettingsAction
extends ExportSettingsAction {
    @Nullable
    private ExportSession session;

    @NotNull
    protected Map<FileSpec, List<ExportableItem>> getExportableComponents() {
        Map map2 = super.getExportableComponents();
        Object object = this.session;
        if (object == null || (object = ((Session)object).getExportableComponents(map2)) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    protected void exportSettings(@NotNull Path saveFile, @NotNull Set<ExportableItem> markedComponents) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
            Intrinsics.checkNotNullParameter(markedComponents, (String)"markedComponents");
            ExportSession exportSession = this.session;
            if (exportSession == null) break block0;
            exportSession.exportSettings(saveFile, markedComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e2) {
        ExportSession exportSession;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        ApplicationManager.getApplication().saveSettings();
        DataContext dataContext2 = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        ClientAppSession clientAppSession = FrontendSessionsUtilKt.getFrontendAppSession((DataContext)dataContext2);
        if (clientAppSession == null) {
            return;
        }
        ClientAppSession clientAppSession2 = clientAppSession;
        SettingsHelper settingsHelper = SettingsHelper.Companion.getInstance(clientAppSession2);
        ExportSession exportSession2 = settingsHelper.createExportSession();
        if (exportSession2 == null) {
            return;
        }
        this.session = exportSession = exportSession2;
        try {
            super.actionPerformed(e2);
        }
        finally {
            ExportSession exportSession3 = this.session;
            this.session = null;
            if (exportSession3 != null) {
                Disposer.dispose((Disposable)exportSession3);
            }
        }
    }
}

