/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.runtime.mono;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.run.DotNetProcessRunProfileState;
import com.jetbrains.rider.run.IDotNetDebugProfileState;
import com.jetbrains.rider.run.mono.MonoDebugProfileState;
import com.jetbrains.rider.runtime.DotNetExecutable;
import com.jetbrains.rider.runtime.DotNetRuntime;
import com.jetbrains.rider.runtime.DotNetRuntimeType;
import com.jetbrains.rider.runtime.mono.MonoRuntimeType;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLineKt;
import com.jetbrains.rider.util.NetUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012JZ\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/runtime/mono/MonoRuntime;", "Lcom/jetbrains/rider/runtime/DotNetRuntime;", "monoExePath", "", "runtimeType", "Lcom/jetbrains/rider/runtime/DotNetRuntimeType;", "MonoRuntime", "(Ljava/lang/String;Lcom/jetbrains/rider/runtime/DotNetRuntimeType;)V", "debuggerPortOffest", "", "G", "patchRunCommandLine", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "runtimeArguments", "", "getMonoExe", "Ljava/io/File;", "fillWaitingForDebuggerProcessCmd", "additionalRuntimeArguments", "suspend", "", "port", "exePath", "workingDirectory", "args", "environmentVariables", "", "isPassParentEnvs", "createRunState", "Lcom/intellij/execution/configurations/RunProfileState;", "dotNetExecutable", "Lcom/jetbrains/rider/runtime/DotNetExecutable;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "createDebugState", "Lcom/jetbrains/rider/run/IDotNetDebugProfileState;", "Companion", "intellij.rider"})
public class MonoRuntime
extends DotNetRuntime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String monoExePath;
    private int debuggerPortOffest;
    @NotNull
    private static final HashSet<String> possibleMonoExecutables;
    private static final int debuggerBasePort = 55555;
    private static final int debuggerPortRangeLimit = 100;
    @NotNull
    public static final String monoDebuggerArgsEnvVar = "RIDER_MONO_DEBUGGER_ARGS";

    public MonoRuntime(@NotNull String monoExePath, @NotNull DotNetRuntimeType runtimeType) {
        Intrinsics.checkNotNullParameter((Object)monoExePath, (String)"monoExePath");
        Intrinsics.checkNotNullParameter((Object)runtimeType, (String)"runtimeType");
        super(runtimeType);
        this.monoExePath = monoExePath;
    }

    public /* synthetic */ MonoRuntime(String string, DotNetRuntimeType dotNetRuntimeType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dotNetRuntimeType = MonoRuntimeType.INSTANCE;
        }
        this(string, dotNetRuntimeType);
    }

    private final int G() {
        int n = 55555 + this.debuggerPortOffest;
        this.debuggerPortOffest = (this.debuggerPortOffest + 1) % 100;
        return NetUtils.INSTANCE.findFreePort(n);
    }

    @Override
    public void patchRunCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull List<String> runtimeArguments) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter(runtimeArguments, (String)"runtimeArguments");
        String string = commandLine.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        String string2 = string;
        commandLine.getParametersList().addAt(0, string2);
        for (String string3 : CollectionsKt.reversed((Iterable)runtimeArguments)) {
            commandLine.getParametersList().addAt(0, string3);
        }
        commandLine.withExePath(this.monoExePath);
    }

    @NotNull
    public final File getMonoExe() {
        return new File(this.monoExePath);
    }

    @NotNull
    public final GeneralCommandLine fillWaitingForDebuggerProcessCmd(@NotNull GeneralCommandLine commandLine, @NotNull String additionalRuntimeArguments, boolean suspend, int port, @NotNull String exePath, @NotNull String workingDirectory, @NotNull String args, @NotNull Map<String, String> environmentVariables, boolean isPassParentEnvs) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)additionalRuntimeArguments, (String)"additionalRuntimeArguments");
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(environmentVariables, (String)"environmentVariables");
        Object object = new String[]{"--debug", "--debugger-agent=transport=dt_socket,server=y,suspend=" + (suspend ? "y" : "n") + ",address=127.0.0.1:" + port + ",setpgid=y" + (String)(environmentVariables.containsKey(monoDebuggerArgsEnvVar) ? "," + environmentVariables.get(monoDebuggerArgsEnvVar) : "")};
        List list2 = CollectionsKt.mutableListOf((Object[])object);
        if (((CharSequence)additionalRuntimeArguments).length() > 0) {
            List list3 = ParametersListUtil.parse((String)additionalRuntimeArguments);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"parse(...)");
            object = list3;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                Intrinsics.checkNotNull((Object)string);
                list2.add(0, string);
            }
        }
        object = this.monoExePath;
        commandLine.getParametersList().clearAll();
        GeneralCommandLine generalCommandLine = commandLine.withExePath((String)object).withEnvironment(environmentVariables).withParentEnvironmentType(isPassParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE).withWorkDirectory(workingDirectory).withParameters(CollectionsKt.plus((Collection)list2, (Object)exePath));
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        FormatPreservingCommandLineKt.withRawParameters((GeneralCommandLine)generalCommandLine, (String)args);
        return commandLine;
    }

    @Override
    @NotNull
    public RunProfileState createRunState(@NotNull DotNetExecutable dotNetExecutable, @NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkNotNullParameter((Object)dotNetExecutable, (String)"dotNetExecutable");
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        return new DotNetProcessRunProfileState(dotNetExecutable, this, executionEnvironment);
    }

    @Override
    @NotNull
    public IDotNetDebugProfileState createDebugState(@NotNull DotNetExecutable dotNetExecutable, @NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkNotNullParameter((Object)dotNetExecutable, (String)"dotNetExecutable");
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        return new MonoDebugProfileState(dotNetExecutable, this, this.G(), executionEnvironment);
    }

    static {
        Object[] objectArray = new String[]{"mono", "mono-sgen", "mono-sgen32", "mono-sgen64", "mono-boehm", "mono.exe", "mono-sgen.exe", "mono-sgen32.exe", "mono-sgen64.exe", "mono-boehm.exe"};
        possibleMonoExecutables = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/runtime/mono/MonoRuntime$Companion;", "", "MonoRuntime$Companion", "()V", "possibleMonoExecutables", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getPossibleMonoExecutables", "()Ljava/util/HashSet;", "debuggerBasePort", "", "debuggerPortRangeLimit", "monoDebuggerArgsEnvVar", "isMonoExecutable", "", "executable", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashSet<String> getPossibleMonoExecutables() {
            return possibleMonoExecutables;
        }

        public final boolean isMonoExecutable(@NotNull String executable) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            HashSet<String> hashSet = this.getPossibleMonoExecutables();
            String string = new File(executable).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return hashSet.contains(string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

