/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.dotNetCore;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.jetbrains.rider.debugger.IRiderDebuggable;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.model.debuggerHelper.PlatformArchitecture;
import com.jetbrains.rider.run.IDotNetRunProfile;
import com.jetbrains.rider.run.dotNetCore.DotNetCoreAttachProfileState;
import com.jetbrains.rider.utils.DotNetCommandLineParsingUtilsKt;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0003\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/run/dotNetCore/DotNetCoreAttachProfile;", "Lcom/jetbrains/rider/run/IDotNetRunProfile;", "Lcom/jetbrains/rider/debugger/IRiderDebuggable;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "targetPlatform", "Lcom/jetbrains/rider/model/debuggerHelper/PlatformArchitecture;", "debuggerDisplayName", "", "DotNetCoreAttachProfile", "(Lcom/intellij/execution/process/ProcessInfo;Lcom/jetbrains/rider/model/debuggerHelper/PlatformArchitecture;Ljava/lang/String;)V", "executableName", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getName", "getIcon", "Ljavax/swing/Icon;", "intellij.rider"})
public final class DotNetCoreAttachProfile
implements IDotNetRunProfile,
IRiderDebuggable {
    @NotNull
    private final ProcessInfo processInfo;
    @NotNull
    private final PlatformArchitecture targetPlatform;
    @NotNull
    private final String debuggerDisplayName;
    @NotNull
    private final String executableName;

    public DotNetCoreAttachProfile(@NotNull ProcessInfo processInfo, @NotNull PlatformArchitecture targetPlatform, @Nls @NotNull String debuggerDisplayName) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)debuggerDisplayName, (String)"debuggerDisplayName");
        this.processInfo = processInfo;
        this.targetPlatform = targetPlatform;
        this.debuggerDisplayName = debuggerDisplayName;
        String string = this.processInfo.getCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLine(...)");
        Object object = DotNetCommandLineParsingUtilsKt.parseExecutablePathFromCommandLine(string);
        if (object == null || (object = PathsKt.getNameWithoutExtension((Path)object)) == null) {
            String string2 = this.processInfo.getExecutableDisplayName();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExecutableDisplayName(...)");
        }
        this.executableName = object;
    }

    public /* synthetic */ DotNetCoreAttachProfile(ProcessInfo processInfo, PlatformArchitecture platformArchitecture, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = RiderDebuggerBundle.Companion.message("MsNetAttachProvider.display.name", new Object[0]);
        }
        this(processInfo, platformArchitecture, string);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor2, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return new DotNetCoreAttachProfileState(this.processInfo, environment, this.targetPlatform, this.debuggerDisplayName);
    }

    @NotNull
    public String getName() {
        return this.processInfo.getPid() + ":" + this.executableName;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.StartDebugger;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StartDebugger");
        return icon;
    }
}

