/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.mac;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.ProjectOutput;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesEditor;
import com.jetbrains.rider.run.configurations.controls.ProgramParametersEditor;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.controls.RunConfigurationViewModelBase;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfigurationEditor;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfigurationParameters;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.RiderMacConfigurationViewModel;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/RiderMultiPlatformConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfiguration;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/RiderMacConfigurationViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "MacRunConfigurationEditor", "(Lcom/intellij/openapi/project/Project;)V", "resetEditorFrom", "", "s", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider"})
public final class MacRunConfigurationEditor
extends RiderMultiPlatformConfigurationEditor<MacRunConfiguration, RiderMacConfigurationViewModel> {
    @NotNull
    private final Project project;

    public MacRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    protected void resetEditorFrom(@NotNull MacRunConfiguration s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        MacRunConfigurationParameters macRunConfigurationParameters = s.getMacParameters();
        ((RiderMacConfigurationViewModel)this.getViewModel()).reset((String)macRunConfigurationParameters.getProjectFilePath().getValue(), macRunConfigurationParameters.getProgramParameters(), macRunConfigurationParameters.getEnvs(), macRunConfigurationParameters.isPassParentEnvs());
    }

    protected void applyEditorTo(@NotNull MacRunConfiguration s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        RunnableProject runnableProject = (RunnableProject)((RiderMacConfigurationViewModel)this.getViewModel()).getProjectSelector().getProject().getValueOrNull();
        if (runnableProject != null) {
            s.getMacParameters().getProjectFilePath().set((Object)runnableProject.getProjectFilePath());
            ProjectOutput projectOutput = (ProjectOutput)CollectionsKt.single((List)runnableProject.getProjectOutputs());
            s.getMacParameters().setWorkingDirectory(projectOutput.getWorkingDirectory());
        }
        s.getMacParameters().setProgramParameters((String)((RiderMacConfigurationViewModel)this.getViewModel()).getProgramParametersEditor().getParametersString().getValue());
        s.getMacParameters().setEnvs(MapsKt.toMutableMap((Map)((Map)((RiderMacConfigurationViewModel)this.getViewModel()).getEnvironmentVariablesEditor().getEnvs().getValue())));
        s.getMacParameters().setPassParentEnvs((Boolean)((RiderMacConfigurationViewModel)this.getViewModel()).getEnvironmentVariablesEditor().isPassParentEnvs().getValue());
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.setViewModel((RunConfigurationViewModelBase)new RiderMacConfigurationViewModel(new ProjectSelector(RiderRunBundle.Companion.message("label.project.with.colon", new Object[0]), "Project"), new ProgramParametersEditor(RiderRunBundle.Companion.message("label.arguments.with.colon", new Object[0]), "Arguments", lifetime), new EnvironmentVariablesEditor(RiderRunBundle.Companion.message("label.environment.variables.with.colon", new Object[0]), "Environment_variables", false, false, 12, null), ProjectExKt.getRunnableProjectsModelIfAvailable(this.project), lifetime));
        return new ControlViewBuilder(lifetime, this.project, "XamarinMacProject").build((RunConfigurationViewModelBase)this.getViewModel());
    }
}

