/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.mac;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.RiderRunConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfigurationEditor;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfigurationParameters;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunExecutorFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfiguration;", "Lcom/jetbrains/rider/run/configurations/RiderRunConfiguration;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/RiderMultiPlatformConfiguration;", "Lcom/jetbrains/rider/run/configurations/IProjectBasedRunConfiguration;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "macParameters", "Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters;", "MacRunConfiguration", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters;)V", "getMacParameters", "()Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters;", "parameters", "getParameters", "checkConfiguration", "", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "getProjectFilePath", "setProjectFilePath", "path", "targetFrameworkId", "Lcom/jetbrains/rider/model/RdTargetFrameworkId;", "getTargetFrameworkId", "()Lcom/jetbrains/rider/model/RdTargetFrameworkId;", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.rider"})
public final class MacRunConfiguration
extends RiderRunConfiguration
implements RiderMultiPlatformConfiguration,
IProjectBasedRunConfiguration {
    @NotNull
    private final MacRunConfigurationParameters macParameters;
    @NotNull
    private final MacRunConfigurationParameters parameters;

    public MacRunConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull MacRunConfigurationParameters macParameters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)macParameters, (String)"macParameters");
        super(name, project, factory, (Function1<? super Project, ? extends SettingsEditor<? extends RunConfiguration>>)((Function1)MacRunConfiguration::G), new MacRunExecutorFactory(macParameters));
        this.parameters = this.macParameters = macParameters;
    }

    @NotNull
    public final MacRunConfigurationParameters getMacParameters() {
        return this.macParameters;
    }

    @Override
    @NotNull
    public MacRunConfigurationParameters getParameters() {
        return this.parameters;
    }

    public void checkConfiguration() {
        this.macParameters.validate();
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.macParameters.readExternal(element);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.macParameters.writeExternal(element);
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return (String)this.macParameters.getProjectFilePath().getValue();
    }

    @Override
    public void setProjectFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.macParameters.getProjectFilePath().set((Object)path);
    }

    @Override
    @Nullable
    public RdTargetFrameworkId getTargetFrameworkId() {
        return this.getParameters().tryGetTfm();
    }

    @NotNull
    public RunConfiguration clone() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigurationFactory configurationFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory);
        MacRunConfiguration macRunConfiguration = new MacRunConfiguration(string, project, configurationFactory, this.getParameters().copy());
        macRunConfiguration.doCopyOptionsFrom((RunConfigurationBase)this);
        this.copyCopyableDataTo((UserDataHolderBase)macRunConfiguration);
        return (RunConfiguration)macRunConfiguration;
    }

    private static final SettingsEditor G(Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"it");
        return (SettingsEditor)new MacRunConfigurationEditor(project);
    }
}

