/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.mac;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLine;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLineKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0017R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacExecutable;", "", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "executablePath", "", "programParameters", "envs", "", "passParentEnvs", "", "isMacCatalyst", "isNetCore", "MacExecutable", "(Lcom/jetbrains/rider/model/RunnableProject;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;ZZZ)V", "getRunnableProject", "()Lcom/jetbrains/rider/model/RunnableProject;", "getExecutablePath", "()Ljava/lang/String;", "getProgramParameters", "getEnvs", "()Ljava/util/Map;", "getPassParentEnvs", "()Z", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getCommandLineForDebugging", "port", "", "Companion", "intellij.rider"})
public final class MacExecutable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RunnableProject runnableProject;
    @NotNull
    private final String executablePath;
    @NotNull
    private final String programParameters;
    @NotNull
    private final Map<String, String> envs;
    private final boolean passParentEnvs;
    private final boolean isMacCatalyst;
    private final boolean isNetCore;
    @NotNull
    private static final String monoEnvOptionsKey = "MONO_ENV_OPTIONS";

    public MacExecutable(@NotNull RunnableProject runnableProject, @NotNull String executablePath, @NotNull String programParameters, @NotNull Map<String, String> envs, boolean passParentEnvs, boolean isMacCatalyst, boolean isNetCore) {
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
        Intrinsics.checkNotNullParameter((Object)programParameters, (String)"programParameters");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        this.runnableProject = runnableProject;
        this.executablePath = executablePath;
        this.programParameters = programParameters;
        this.envs = envs;
        this.passParentEnvs = passParentEnvs;
        this.isMacCatalyst = isMacCatalyst;
        this.isNetCore = isNetCore;
    }

    @NotNull
    public final RunnableProject getRunnableProject() {
        return this.runnableProject;
    }

    @NotNull
    public final String getExecutablePath() {
        return this.executablePath;
    }

    @NotNull
    public final String getProgramParameters() {
        return this.programParameters;
    }

    @NotNull
    public final Map<String, String> getEnvs() {
        return this.envs;
    }

    public final boolean getPassParentEnvs() {
        return this.passParentEnvs;
    }

    public final boolean isMacCatalyst() {
        return this.isMacCatalyst;
    }

    public final boolean isNetCore() {
        return this.isNetCore;
    }

    @NotNull
    public final GeneralCommandLine getCommandLine() {
        GeneralCommandLine generalCommandLine = new FormatPreservingCommandLine().withExePath(this.executablePath);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withExePath(...)");
        GeneralCommandLine generalCommandLine2 = FormatPreservingCommandLineKt.withRawParameters((GeneralCommandLine)generalCommandLine, (String)this.programParameters).withEnvironment(this.envs).withParentEnvironmentType(this.passParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withParentEnvironmentType(...)");
        return generalCommandLine2;
    }

    @NotNull
    public final GeneralCommandLine getCommandLineForDebugging(int port) {
        GeneralCommandLine generalCommandLine;
        if (this.isNetCore) {
            generalCommandLine = this.getCommandLine();
        } else if (this.isMacCatalyst) {
            GeneralCommandLine generalCommandLine2 = this.getCommandLine().withEnvironment("__XAMARIN_DEBUG_HOSTS__", "127.0.0.1").withEnvironment("__XAMARIN_DEBUG_PORT__", String.valueOf(port));
            generalCommandLine = generalCommandLine2;
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withEnvironment(...)");
        } else {
            GeneralCommandLine generalCommandLine3 = this.getCommandLine().withEnvironment(monoEnvOptionsKey, "--debugger-agent=transport=dt_socket,address=127.0.0.1:" + port);
            generalCommandLine = generalCommandLine3;
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine3, (String)"withEnvironment(...)");
        }
        return generalCommandLine;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacExecutable$Companion;", "", "MacExecutable$Companion", "()V", "monoEnvOptionsKey", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

