/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.ios.connectDialogs.servers;

import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConnectionSessionHost;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.connectDialogs.servers.RemoteMacAgent;
import com.jetbrains.rider.run.multiPlatform.ios.sessions.IOSLocalSessionHandler;
import com.jetbrains.rider.run.multiPlatform.ios.sessions.IOSSessionHandler;
import java.net.InetAddress;
import java.net.NetworkInterface;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0013\u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/connectDialogs/servers/RemoteMacRemoteAgent;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/connectDialogs/servers/RemoteMacAgent;", "hostName", "", "connectionHost", "Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConnectionSessionHost;", "RemoteMacRemoteAgent", "(Ljava/lang/String;Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConnectionSessionHost;)V", "agentDescription", "Lcom/intellij/openapi/util/NlsSafe;", "isLocalMachine", "Lkotlin/Lazy;", "", "tryConnect", "isActive", "canBeDisconnected", "getDescription", "G", "Ljava/net/InetAddress;", "intellij.rider"})
public final class RemoteMacRemoteAgent
extends RemoteMacAgent {
    private String agentDescription;
    @NotNull
    private final Lazy<Boolean> isLocalMachine;

    public RemoteMacRemoteAgent(@NotNull String hostName, @NotNull IOSConnectionSessionHost connectionHost) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionHost), (String)"connectionHost");
        super(hostName, connectionHost);
        ApplicationKt.getApplication().executeOnPooledThread(() -> RemoteMacRemoteAgent.G(this, hostName));
        this.isLocalMachine = LazyKt.lazy(() -> RemoteMacRemoteAgent.G(this));
    }

    @Override
    public boolean tryConnect() {
        if (((Boolean)this.isLocalMachine.getValue()).booleanValue()) {
            return this.getConnectionHost().setActiveLocalSession();
        }
        return this.getConnectionHost().trySetActiveRemoteSession(this.getHostName());
    }

    @Override
    public boolean isActive() {
        if (((Boolean)this.isLocalMachine.getValue()).booleanValue()) {
            return this.getConnectionHost().getActiveConnection().getValue() instanceof IOSLocalSessionHandler;
        }
        String string = this.getHostName();
        Object object = this.getConnectionHost().getActiveSessionHandler();
        if (object == null || (object = ((IOSSessionHandler)object).getHostName()) == null) {
            object = "";
        }
        return Intrinsics.areEqual((Object)string, (Object)object);
    }

    @Override
    public boolean canBeDisconnected() {
        return (Boolean)this.isLocalMachine.getValue() == false;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string;
        if (this.agentDescription != null) {
            string = this.agentDescription;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"agentDescription");
                string = null;
            }
        } else {
            string = "";
        }
        return string;
    }

    private final InetAddress G() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(this.getHostName());
        }
        catch (Exception exception) {
            inetAddress = null;
        }
        return inetAddress;
    }

    private static final void G(RemoteMacRemoteAgent remoteMacRemoteAgent, String string) {
        Object object;
        RemoteMacRemoteAgent remoteMacRemoteAgent2;
        RemoteMacRemoteAgent remoteMacRemoteAgent3 = remoteMacRemoteAgent;
        try {
            String string2;
            String string3;
            remoteMacRemoteAgent2 = remoteMacRemoteAgent3;
            object = remoteMacRemoteAgent.G();
            CharSequence charSequence = string;
            if (new Regex("\\d+.\\d+.\\d+.\\d+").matches(charSequence)) {
                Object object2 = object;
                string3 = object2 != null ? ((InetAddress)object2).getHostName() : null;
            } else {
                Object object3 = object;
                string3 = string2 = object3 != null ? ((InetAddress)object3).getHostAddress() : null;
            }
            if (string3 == null) {
                string2 = "";
            }
            object = string2;
        }
        catch (Throwable throwable) {
            remoteMacRemoteAgent2 = remoteMacRemoteAgent3;
            object = "";
        }
        remoteMacRemoteAgent2.agentDescription = object;
    }

    private static final boolean G(RemoteMacRemoteAgent remoteMacRemoteAgent) {
        try {
            InetAddress inetAddress = remoteMacRemoteAgent.G();
            if (inetAddress == null) {
                return false;
            }
            InetAddress inetAddress2 = inetAddress;
            if (inetAddress2.isAnyLocalAddress() || inetAddress2.isLoopbackAddress()) {
                return true;
            }
            return NetworkInterface.getByInetAddress(inetAddress2) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

