/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.ios;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.EnumSelector;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesEditor;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.controls.RunConfigurationViewModelBase;
import com.jetbrains.rider.run.configurations.controls.TextEditor;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfigurationEditor;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.ApplePlatformType;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConfigurationParameters;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConfigurationViewModel;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/RiderMultiPlatformConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfiguration;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfigurationViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "IOSConfigurationEditor", "(Lcom/intellij/openapi/project/Project;)V", "resetEditorFrom", "", "c", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider"})
public final class IOSConfigurationEditor
extends RiderMultiPlatformConfigurationEditor<IOSConfiguration, IOSConfigurationViewModel> {
    @NotNull
    private final Project project;

    public IOSConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    protected void resetEditorFrom(@NotNull IOSConfiguration c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        IOSConfigurationParameters iOSConfigurationParameters = c.getIOSParameters();
        ((IOSConfigurationViewModel)this.getViewModel()).reset((String)iOSConfigurationParameters.getProjectFilePath().getValue(), iOSConfigurationParameters.getEnvs(), iOSConfigurationParameters.isPassParentEnvs(), iOSConfigurationParameters.getExtraMlaunchParameters(), iOSConfigurationParameters.getApplePlatformType());
    }

    protected void applyEditorTo(@NotNull IOSConfiguration c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        RunnableProject runnableProject = (RunnableProject)((IOSConfigurationViewModel)this.getViewModel()).getProjectSelector().getProject().getValueOrNull();
        if (runnableProject != null) {
            IOSConfigurationParameters iOSConfigurationParameters = c.getIOSParameters();
            iOSConfigurationParameters.getProjectFilePath().set((Object)runnableProject.getProjectFilePath());
            iOSConfigurationParameters.setEnvs(MapsKt.toMutableMap((Map)((Map)((IOSConfigurationViewModel)this.getViewModel()).getEnvironmentVariablesEditor().getEnvs().getValue())));
            iOSConfigurationParameters.setPassParentEnvs((Boolean)((IOSConfigurationViewModel)this.getViewModel()).getEnvironmentVariablesEditor().isPassParentEnvs().getValue());
            iOSConfigurationParameters.setExtraMlaunchParameters((String)((IOSConfigurationViewModel)this.getViewModel()).getExtraMlaunchParametersEditor().getText().getValue());
            iOSConfigurationParameters.setApplePlatformType((ApplePlatformType)((Object)InterfacesKt.valueOrDefault(((IOSConfigurationViewModel)this.getViewModel()).getPlatformSelector().getRawValue(), (Object)((Object)ApplePlatformType.IOS))));
        }
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ProjectSelector projectSelector = new ProjectSelector(RiderRunBundle.Companion.message("label.project.with.colon", new Object[0]), "Project");
        EnvironmentVariablesEditor environmentVariablesEditor = new EnvironmentVariablesEditor(RiderRunBundle.Companion.message("label.environment.variables.with.colon", new Object[0]), "Environment_variables", false, false, 8, null);
        TextEditor textEditor = new TextEditor(RiderMultiPlatformBundle.Companion.message("rider.ios.extra.mlaunch.parameters.message", new Object[0]), "Extra_mlaunch_Parameters", lifetime);
        RunnableProjectsModel runnableProjectsModel = ProjectExKt.getRunnableProjectsModelIfAvailable(this.project);
        String string = RiderMultiPlatformBundle.Companion.message("rider.ios.platform.type.message", new Object[0]);
        EnumSet<Enum> enumSet = EnumSet.of((Enum)ApplePlatformType.IOS, (Enum)ApplePlatformType.MACCATALYST);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        this.setViewModel((RunConfigurationViewModelBase)new IOSConfigurationViewModel(projectSelector, environmentVariablesEditor, textEditor, runnableProjectsModel, new EnumSelector<Enum>(string, "Platform_Type", enumSet, IOSConfigurationEditor::G), lifetime));
        return new ControlViewBuilder(lifetime, this.project, "XamarinIOSProject").build((RunConfigurationViewModelBase)this.getViewModel());
    }

    private static final String G(ApplePlatformType applePlatformType) {
        return applePlatformType.getPresentation();
    }
}

