/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.ios;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.RiderRunConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConfigurationEditor;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConfigurationParameters;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSExecutorFactory;
import com.jetbrains.rider.run.devices.DevicesConfiguration;
import com.jetbrains.rider.run.devices.DevicesProvider;
import com.jetbrains.rider.run.multiPlatform.ios.devices.IOSDevicesProvider;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0016\u0010 \u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfiguration;", "Lcom/jetbrains/rider/run/configurations/RiderRunConfiguration;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/RiderMultiPlatformConfiguration;", "Lcom/jetbrains/rider/run/devices/DevicesConfiguration;", "Lcom/jetbrains/rider/run/configurations/IProjectBasedRunConfiguration;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "iOSParameters", "Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfigurationParameters;", "IOSConfiguration", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfigurationParameters;)V", "getIOSParameters", "()Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfigurationParameters;", "provider", "Lcom/jetbrains/rider/run/devices/DevicesProvider;", "getProvider", "()Lcom/jetbrains/rider/run/devices/DevicesProvider;", "parameters", "getParameters", "checkConfiguration", "", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "getProjectFilePath", "setProjectFilePath", "path", "targetFrameworkId", "Lcom/jetbrains/rider/model/RdTargetFrameworkId;", "getTargetFrameworkId", "()Lcom/jetbrains/rider/model/RdTargetFrameworkId;", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.rider"})
public final class IOSConfiguration
extends RiderRunConfiguration
implements RiderMultiPlatformConfiguration,
DevicesConfiguration,
IProjectBasedRunConfiguration {
    @NotNull
    private final IOSConfigurationParameters iOSParameters;
    @NotNull
    private final IOSConfigurationParameters parameters;

    public IOSConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull IOSConfigurationParameters iOSParameters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)iOSParameters, (String)"iOSParameters");
        super(name, project, factory, (Function1<? super Project, ? extends SettingsEditor<? extends RunConfiguration>>)((Function1)IOSConfiguration::G), new IOSExecutorFactory(iOSParameters));
        this.parameters = this.iOSParameters = iOSParameters;
    }

    @NotNull
    public final IOSConfigurationParameters getIOSParameters() {
        return this.iOSParameters;
    }

    @Override
    @NotNull
    public DevicesProvider getProvider() {
        return new IOSDevicesProvider(this.iOSParameters);
    }

    @Override
    @NotNull
    public IOSConfigurationParameters getParameters() {
        return this.parameters;
    }

    public void checkConfiguration() {
        this.iOSParameters.validate();
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.iOSParameters.readExternal(element);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.iOSParameters.writeExternal(element);
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return (String)this.iOSParameters.getProjectFilePath().getValue();
    }

    @Override
    public void setProjectFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.iOSParameters.getProjectFilePath().set((Object)path);
    }

    @Override
    @Nullable
    public RdTargetFrameworkId getTargetFrameworkId() {
        return this.iOSParameters.tryGetTfm();
    }

    @NotNull
    public RunConfiguration clone() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigurationFactory configurationFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory);
        IOSConfiguration iOSConfiguration = new IOSConfiguration(string, project, configurationFactory, this.getParameters().copy());
        iOSConfiguration.doCopyOptionsFrom((RunConfigurationBase)this);
        this.copyCopyableDataTo((UserDataHolderBase)iOSConfiguration);
        return (RunConfiguration)iOSConfiguration;
    }

    private static final SettingsEditor G(Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"it");
        return (SettingsEditor)new IOSConfigurationEditor(project);
    }
}

