/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.launchSettings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.rider.ideaInterop.RiderContributedLanguageElementNameCrawler;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationType;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJson;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJsonCachedValueProvider;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0010H\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService;", "", "project", "Lcom/intellij/openapi/project/Project;", "LaunchSettingsJsonService", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJson$LaunchSettings;", "loadLaunchSettings", "launchSettingsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "loadLaunchSettingsSuspend", "(Lcom/jetbrains/rider/model/RunnableProject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nLaunchSettingsJsonService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n72#2,2:131\n1#3:133\n1#3:134\n*S KotlinDebug\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService\n*L\n78#1:131,2\n78#1:133\n*E\n"})
public final class LaunchSettingsJsonService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<Path, CachedValue<LaunchSettingsJson.LaunchSettings>> myCache;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public LaunchSettingsJsonService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myCache = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @RequiresBackgroundThread
    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull VirtualFile launchSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)launchSettingsFile, (String)"launchSettingsFile");
        Path path = launchSettingsFile.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path path2 = path;
        ConcurrentMap concurrentMap = this.myCache;
        boolean bl = false;
        Object v = concurrentMap.get(path2);
        if (v == null) {
            boolean bl2 = false;
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.project);
            Gson gson = LaunchSettingsJsonService.gson;
            Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gson");
            CachedValue cachedValue = cachedValuesManager.createCachedValue((CachedValueProvider)new LaunchSettingsJsonCachedValueProvider(launchSettingsFile, gson), false);
            Intrinsics.checkNotNullExpressionValue((Object)cachedValue, (String)"createCachedValue(...)");
            CachedValue cachedValue2 = cachedValue;
            ((Map)this.myCache).put(path2, cachedValue2);
            return (LaunchSettingsJson.LaunchSettings)cachedValue2.getValue();
        }
        CachedValue cachedValue = (CachedValue)v;
        return (LaunchSettingsJson.LaunchSettings)cachedValue.getValue();
    }

    @RequiresBackgroundThread
    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull File launchSettingsFile) {
        LaunchSettingsJson.LaunchSettings launchSettings;
        Intrinsics.checkNotNullParameter((Object)launchSettingsFile, (String)"launchSettingsFile");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFileSystem2 = localFileSystem;
        VirtualFile virtualFile = localFileSystem2.findFileByIoFile(launchSettingsFile);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            launchSettings = this.loadLaunchSettings(virtualFile2);
        } else {
            launchSettings = null;
        }
        return launchSettings;
    }

    @RequiresBackgroundThread
    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull RunnableProject runnableProject) {
        LaunchSettingsJson.LaunchSettings launchSettings;
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        File file2 = Companion.getLaunchSettingsFileForProject(runnableProject);
        if (file2 != null) {
            File file3 = file2;
            boolean bl = false;
            launchSettings = this.loadLaunchSettings(file3);
        } else {
            launchSettings = null;
        }
        return launchSettings;
    }

    @Nullable
    public final Object loadLaunchSettingsSuspend(@NotNull RunnableProject runnableProject, @NotNull Continuation<? super LaunchSettingsJson.LaunchSettings> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LaunchSettingsJson.LaunchSettings>, Object>(runnableProject, this, null){
            int label;
            final /* synthetic */ RunnableProject $runnableProject;
            final /* synthetic */ LaunchSettingsJsonService this$0;
            {
                this.$runnableProject = $runnableProject;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        LaunchSettingsJson.LaunchSettings launchSettings;
                        ResultKt.throwOnFailure((Object)object);
                        File file2 = LaunchSettingsJsonService.Companion.getLaunchSettingsFileForProject(this.$runnableProject);
                        if (file2 != null) {
                            File file3 = file2;
                            LaunchSettingsJsonService launchSettingsJsonService = this.this$0;
                            File file4 = file3;
                            boolean bl = false;
                            launchSettings = launchSettingsJsonService.loadLaunchSettings(file4);
                        } else {
                            launchSettings = null;
                        }
                        return launchSettings;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LaunchSettingsJson.LaunchSettings> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object loadLaunchSettingsSuspend(@NotNull File launchSettingsFile, @NotNull Continuation<? super LaunchSettingsJson.LaunchSettings> $completion) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFileSystem2 = localFileSystem;
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LaunchSettingsJson.LaunchSettings>, Object>(localFileSystem2, launchSettingsFile, this, null){
            int label;
            final /* synthetic */ LocalFileSystem $fs;
            final /* synthetic */ File $launchSettingsFile;
            final /* synthetic */ LaunchSettingsJsonService this$0;
            {
                this.$fs = $fs;
                this.$launchSettingsFile = $launchSettingsFile;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        LaunchSettingsJson.LaunchSettings launchSettings;
                        ResultKt.throwOnFailure((Object)object);
                        VirtualFile virtualFile = this.$fs.findFileByIoFile(this.$launchSettingsFile);
                        if (virtualFile != null) {
                            VirtualFile virtualFile2 = virtualFile;
                            LaunchSettingsJsonService launchSettingsJsonService = this.this$0;
                            VirtualFile virtualFile3 = virtualFile2;
                            boolean bl = false;
                            launchSettings = launchSettingsJsonService.loadLaunchSettings(virtualFile3);
                        } else {
                            launchSettings = null;
                        }
                        return launchSettings;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LaunchSettingsJson.LaunchSettings> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ&\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0!2\u0006\u0010\n\u001a\u00020\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0017R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService$Companion;", "", "LaunchSettingsJsonService$Companion", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "G", "", "file", "Ljava/io/File;", "getLaunchSettingsFileForProject", "projectPath", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "testOnlySerializeLaunchSettings", "", "launchSettings", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJson$LaunchSettings;", "writeLaunchSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "launchSettingsJsonFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProfileNameFromElement", "element", "Lcom/intellij/psi/PsiElement;", "getLaunchSettingsProjectForFile", "fs", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "projects", "", "Lcom/intellij/psi/PsiFile;", "getInstance", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nLaunchSettingsJsonService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,130:1\n295#2:131\n296#2:133\n1#3:132\n31#4,2:134\n*S KotlinDebug\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService$Companion\n*L\n64#1:131\n64#1:133\n70#1:134,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean G(File file2) {
            return Intrinsics.areEqual((Object)file2.getName().toString(), (Object)"launchSettings.json");
        }

        @Nullable
        public final File getLaunchSettingsFileForProject(@NotNull File projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            File file2 = projectPath.getParentFile();
            return file2 != null ? FilesKt.resolve((File)file2, (String)"Properties/launchSettings.json") : null;
        }

        @Nullable
        public final File getLaunchSettingsFileForProject(@NotNull RunnableProject runnableProject) {
            Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
            return this.getLaunchSettingsFileForProject(new File(runnableProject.getProjectFilePath()));
        }

        @TestOnly
        @NotNull
        public final String testOnlySerializeLaunchSettings(@NotNull LaunchSettingsJson.LaunchSettings launchSettings) {
            Intrinsics.checkNotNullParameter((Object)launchSettings, (String)"launchSettings");
            String string = gson.toJson((Object)launchSettings);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        @TestOnly
        public final void writeLaunchSettings(@NotNull Project project, @NotNull VirtualFile launchSettingsJsonFile, @NotNull LaunchSettingsJson.LaunchSettings launchSettings) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)launchSettingsJsonFile, (String)"launchSettingsJsonFile");
            Intrinsics.checkNotNullParameter((Object)launchSettings, (String)"launchSettings");
            String string = gson.toJson((Object)launchSettings);
            LoadTextUtil.write((Project)project, (VirtualFile)launchSettingsJsonFile, (Object)this, (String)string, (long)-1L);
        }

        @Nullable
        public final String getProfileNameFromElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)RiderContributedLanguageElementNameCrawler.EP_NAME.getExtensionList()), arg_0 -> Companion.G(element, arg_0)));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public final RunnableProject getLaunchSettingsProjectForFile(@NotNull LocalFileSystem fs, @NotNull List<RunnableProject> projects, @NotNull PsiFile file2) {
            Object t;
            Object v0;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            VirtualFile virtualFile = file2.getVirtualFile();
            if (!this.G(new File(virtualFile.getPath()))) {
                return null;
            }
            LaunchSettingsConfigurationType launchSettingsConfigurationType = (LaunchSettingsConfigurationType)ConfigurationTypeUtil.findConfigurationType(LaunchSettingsConfigurationType.class);
            Iterable iterable = projects;
            boolean bl2 = false;
            Iterator iterator2 = iterable.iterator();
            do {
                if (!iterator2.hasNext()) {
                    v0 = null;
                    return v0;
                }
                t = iterator2.next();
                RunnableProject runnableProject = (RunnableProject)t;
                boolean bl3 = false;
                if (launchSettingsConfigurationType.isApplicable(runnableProject.getKind())) {
                    VirtualFile virtualFile2;
                    if (Companion.getLaunchSettingsFileForProject(runnableProject) != null) {
                        File file3;
                        boolean bl4 = false;
                        virtualFile2 = fs.findFileByIoFile(file3);
                    } else {
                        virtualFile2 = null;
                    }
                    if (Intrinsics.areEqual(virtualFile2, (Object)virtualFile)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            v0 = t;
            return v0;
        }

        @NotNull
        public final LaunchSettingsJsonService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<LaunchSettingsJsonService> clazz = LaunchSettingsJsonService.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (LaunchSettingsJsonService)object;
        }

        private static final String G(PsiElement psiElement, RiderContributedLanguageElementNameCrawler riderContributedLanguageElementNameCrawler) {
            return riderContributedLanguageElementNameCrawler.getElementName(psiElement);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

