/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.launchSettings;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJson;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJsonServiceKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJson$LaunchSettings;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "gson", "Lcom/google/gson/Gson;", "LaunchSettingsJsonCachedValueProvider", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/google/gson/Gson;)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getGson", "()Lcom/google/gson/Gson;", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "intellij.rider"})
public final class LaunchSettingsJsonCachedValueProvider
implements CachedValueProvider<LaunchSettingsJson.LaunchSettings> {
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Gson gson;

    public LaunchSettingsJsonCachedValueProvider(@NotNull VirtualFile virtualFile, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.virtualFile = virtualFile;
        this.gson = gson;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @NotNull
    public CachedValueProvider.Result<LaunchSettingsJson.LaunchSettings> compute() {
        if (!this.virtualFile.exists() || !this.virtualFile.isValid()) {
            Object[] objectArray = new Object[]{ModificationTracker.NEVER_CHANGED};
            return new CachedValueProvider.Result(null, objectArray);
        }
        try {
            String string = VirtualFileUtil.readText((VirtualFile)this.virtualFile);
            LaunchSettingsJson.LaunchSettings launchSettings = (LaunchSettingsJson.LaunchSettings)this.gson.fromJson(string, LaunchSettingsJson.LaunchSettings.class);
            Object[] objectArray = new Object[]{this.virtualFile};
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)launchSettings, (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"create(...)");
            return result2;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            LaunchSettingsJsonServiceKt.access$getLogger$p().warn((Throwable)jsonSyntaxException);
            Object[] objectArray = new Object[]{ModificationTracker.NEVER_CHANGED};
            return new CachedValueProvider.Result(null, objectArray);
        }
    }
}

