/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.iis;

import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.run.configurations.RunnableProjectKinds;
import com.jetbrains.rider.run.configurations.controls.ControlBase;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.controls.ProjectSelectorKt;
import com.jetbrains.rider.run.configurations.controls.RunConfigurationViewModelBase;
import com.jetbrains.rider.run.configurations.controls.TextEditor;
import com.jetbrains.rider.run.configurations.controls.ViewSeparator;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettings;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettingsEditor;
import com.jetbrains.rider.run.configurations.iis.IisApplicationConfigurationType;
import com.jetbrains.rider.run.configurations.project.DotNetStartBrowserParameters;
import com.jetbrains.rider.run.configurations.project.RunnableProjectExKt;
import com.jetbrains.rider.run.configurations.project.RunnableProjectRunOptions;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020%H\u0002J\u001e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006."}, d2={"Lcom/jetbrains/rider/run/configurations/iis/IisApplicationConfigurationViewModel;", "Lcom/jetbrains/rider/run/configurations/controls/RunConfigurationViewModelBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "runnableProjectsModel", "Lcom/jetbrains/rider/model/RunnableProjectsModel;", "projectSelector", "Lcom/jetbrains/rider/run/configurations/controls/ProjectSelector;", "separator", "Lcom/jetbrains/rider/run/configurations/controls/ViewSeparator;", "urlEditor", "Lcom/jetbrains/rider/run/configurations/controls/TextEditor;", "dotNetBrowserSettingsEditor", "Lcom/jetbrains/rider/run/configurations/controls/startBrowser/BrowserSettingsEditor;", "IisApplicationConfigurationViewModel", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/RunnableProjectsModel;Lcom/jetbrains/rider/run/configurations/controls/ProjectSelector;Lcom/jetbrains/rider/run/configurations/controls/ViewSeparator;Lcom/jetbrains/rider/run/configurations/controls/TextEditor;Lcom/jetbrains/rider/run/configurations/controls/startBrowser/BrowserSettingsEditor;)V", "getProjectSelector", "()Lcom/jetbrains/rider/run/configurations/controls/ProjectSelector;", "getSeparator", "()Lcom/jetbrains/rider/run/configurations/controls/ViewSeparator;", "getUrlEditor", "()Lcom/jetbrains/rider/run/configurations/controls/TextEditor;", "getDotNetBrowserSettingsEditor", "()Lcom/jetbrains/rider/run/configurations/controls/startBrowser/BrowserSettingsEditor;", "controls", "", "Lcom/jetbrains/rider/run/configurations/controls/ControlBase;", "getControls", "()Ljava/util/List;", "isLoaded", "", "trackIisUrl", "getTrackIisUrl", "()Z", "setTrackIisUrl", "(Z)V", "G", "", "project", "Lcom/jetbrains/rider/model/RunnableProject;", "G", "reset", "projectFilePath", "", "dotNetStartBrowserParameters", "Lcom/jetbrains/rider/run/configurations/project/DotNetStartBrowserParameters;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nIisApplicationConfigurationViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IisApplicationConfigurationViewModel.kt\ncom/jetbrains/rider/run/configurations/iis/IisApplicationConfigurationViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n2632#2,3:129\n295#2,2:132\n669#2,11:134\n*S KotlinDebug\n*F\n+ 1 IisApplicationConfigurationViewModel.kt\ncom/jetbrains/rider/run/configurations/iis/IisApplicationConfigurationViewModel\n*L\n84#1:129,3\n88#1:132,2\n113#1:134,11\n*E\n"})
public final class IisApplicationConfigurationViewModel
extends RunConfigurationViewModelBase {
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private final RunnableProjectsModel runnableProjectsModel;
    @NotNull
    private final ProjectSelector projectSelector;
    @NotNull
    private final ViewSeparator separator;
    @NotNull
    private final TextEditor urlEditor;
    @NotNull
    private final BrowserSettingsEditor dotNetBrowserSettingsEditor;
    @NotNull
    private final List<ControlBase> controls;
    private boolean isLoaded;
    private boolean trackIisUrl;

    public IisApplicationConfigurationViewModel(@NotNull Lifetime lifetime, @Nullable RunnableProjectsModel runnableProjectsModel, @NotNull ProjectSelector projectSelector, @NotNull ViewSeparator separator, @NotNull TextEditor urlEditor, @NotNull BrowserSettingsEditor dotNetBrowserSettingsEditor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)projectSelector, (String)"projectSelector");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)urlEditor, (String)"urlEditor");
        Intrinsics.checkNotNullParameter((Object)dotNetBrowserSettingsEditor, (String)"dotNetBrowserSettingsEditor");
        this.lifetime = lifetime;
        this.runnableProjectsModel = runnableProjectsModel;
        this.projectSelector = projectSelector;
        this.separator = separator;
        this.urlEditor = urlEditor;
        this.dotNetBrowserSettingsEditor = dotNetBrowserSettingsEditor;
        Object[] objectArray = new ControlBase[]{this.projectSelector, this.separator, this.urlEditor, this.dotNetBrowserSettingsEditor};
        this.controls = CollectionsKt.listOf((Object[])objectArray);
        this.trackIisUrl = true;
        this.disable();
        if (this.runnableProjectsModel != null) {
            ProjectSelectorKt.bindTo(this.projectSelector, this.runnableProjectsModel, this.lifetime, (Function1<? super RunnableProject, Boolean>)((Function1)IisApplicationConfigurationViewModel::G), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((IisApplicationConfigurationViewModel)this.receiver).enable();
                }
            }), (Function1<? super RunnableProject, Unit>)((Function1)new Function1<RunnableProject, Unit>((Object)this){

                public final void invoke(RunnableProject p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((IisApplicationConfigurationViewModel)this.receiver).G(p0);
                }
            }));
        }
        this.urlEditor.getText().advise(this.lifetime, arg_0 -> IisApplicationConfigurationViewModel.G(this, arg_0));
    }

    @NotNull
    public final ProjectSelector getProjectSelector() {
        return this.projectSelector;
    }

    @NotNull
    public final ViewSeparator getSeparator() {
        return this.separator;
    }

    @NotNull
    public final TextEditor getUrlEditor() {
        return this.urlEditor;
    }

    @NotNull
    public final BrowserSettingsEditor getDotNetBrowserSettingsEditor() {
        return this.dotNetBrowserSettingsEditor;
    }

    @Override
    @NotNull
    public List<ControlBase> getControls() {
        return this.controls;
    }

    public final boolean getTrackIisUrl() {
        return this.trackIisUrl;
    }

    public final void setTrackIisUrl(boolean bl) {
        this.trackIisUrl = bl;
    }

    private final void G(RunnableProject runnableProject) {
        if (!this.isLoaded) {
            return;
        }
        RunnableProjectRunOptions runnableProjectRunOptions = RunnableProjectExKt.getRunOptions(runnableProject);
        String string = runnableProjectRunOptions.getStartBrowserUrl();
        if (((CharSequence)string).length() > 0) {
            this.urlEditor.getDefaultValue().setValue((Object)string);
            this.urlEditor.getText().setValue((Object)string);
            this.dotNetBrowserSettingsEditor.getSettings().setValue((Object)new BrowserSettings(runnableProjectRunOptions.getLaunchBrowser(), false, null));
        }
    }

    private final void G() {
        block0: {
            RunnableProject runnableProject = (RunnableProject)this.projectSelector.getProject().getValueOrNull();
            if (runnableProject == null) break block0;
            RunnableProject runnableProject2 = runnableProject;
            boolean bl = false;
            RunnableProjectRunOptions runnableProjectRunOptions = RunnableProjectExKt.getRunOptions(runnableProject2);
            this.trackIisUrl = Intrinsics.areEqual((Object)this.urlEditor.getText().getValue(), (Object)runnableProjectRunOptions.getStartBrowserUrl());
        }
    }

    public final void reset(@NotNull String projectFilePath, boolean trackIisUrl, @NotNull DotNetStartBrowserParameters dotNetStartBrowserParameters) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
            Intrinsics.checkNotNullParameter((Object)dotNetStartBrowserParameters, (String)"dotNetStartBrowserParameters");
            this.isLoaded = false;
            this.trackIisUrl = trackIisUrl;
            RunnableProjectsModel runnableProjectsModel = this.runnableProjectsModel;
            if (runnableProjectsModel == null || (runnableProjectsModel = runnableProjectsModel.getProjects()) == null) break block0;
            SourceExKt.adviseOnce((ISource)((ISource)runnableProjectsModel), (Lifetime)this.lifetime, arg_0 -> IisApplicationConfigurationViewModel.G(this, dotNetStartBrowserParameters, projectFilePath, trackIisUrl, arg_0));
        }
    }

    private static final boolean G(RunnableProject runnableProject) {
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"p");
        return IisApplicationConfigurationType.Companion.isTypeApplicable(runnableProject.getKind());
    }

    private static final Unit G(IisApplicationConfigurationViewModel iisApplicationConfigurationViewModel, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"it");
        iisApplicationConfigurationViewModel.G();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final Unit G(IisApplicationConfigurationViewModel iisApplicationConfigurationViewModel, DotNetStartBrowserParameters dotNetStartBrowserParameters, String string, boolean bl, List list2) {
        block15: {
            Object object;
            Object object2;
            block12: {
                void var8_20;
                boolean bl2;
                block14: {
                    Iterator iterator2;
                    block13: {
                        boolean bl3;
                        block10: {
                            Intrinsics.checkNotNullParameter((Object)list2, (String)"projectList");
                            iisApplicationConfigurationViewModel.dotNetBrowserSettingsEditor.getSettings().set((Object)new BrowserSettings(dotNetStartBrowserParameters.getStartAfterLaunch(), dotNetStartBrowserParameters.getWithJavaScriptDebugger(), dotNetStartBrowserParameters.getBrowser()));
                            if (((CharSequence)string).length() == 0) break block13;
                            object2 = list2;
                            boolean bl4 = false;
                            if (object2 instanceof Collection && ((Collection)object2).isEmpty()) {
                                bl3 = true;
                            } else {
                                iterator2 = object2.iterator();
                                while (iterator2.hasNext()) {
                                    Object t = iterator2.next();
                                    RunnableProject runnableProject = (RunnableProject)t;
                                    boolean bl5 = false;
                                    if (!(Intrinsics.areEqual((Object)runnableProject.getProjectFilePath(), (Object)string) && IisApplicationConfigurationType.Companion.isTypeApplicable(runnableProject.getKind()))) continue;
                                    bl3 = false;
                                    break block10;
                                }
                                bl3 = true;
                            }
                        }
                        if (!bl3) break block14;
                    }
                    if (((CharSequence)string).length() == 0) {
                        Object v1;
                        block11: {
                            Iterable iterable = list2;
                            boolean bl6 = false;
                            for (Object t : iterable) {
                                RunnableProject runnableProject = (RunnableProject)t;
                                boolean bl7 = false;
                                if (!IisApplicationConfigurationType.Companion.isTypeApplicable(runnableProject.getKind())) continue;
                                v1 = t;
                                break block11;
                            }
                            v1 = null;
                        }
                        RunnableProject runnableProject = v1;
                        if (runnableProject != null) {
                            RunnableProject runnableProject2 = runnableProject;
                            boolean bl8 = false;
                            iisApplicationConfigurationViewModel.projectSelector.getProject().set((Object)runnableProject2);
                            iisApplicationConfigurationViewModel.isLoaded = true;
                            iisApplicationConfigurationViewModel.G(runnableProject2);
                        }
                        break block15;
                    } else {
                        object2 = new File(string).getName();
                        Intrinsics.checkNotNull((Object)object2);
                        RunnableProject runnableProject = new RunnableProject((String)object2, (String)object2, string, RunnableProjectKinds.INSTANCE.getUnloaded(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, CollectionsKt.emptyList());
                        Iterator iterator3 = iterator2 = iisApplicationConfigurationViewModel.projectSelector.getProjectList();
                        boolean bl9 = false;
                        iterator3.clear();
                        iterator3.addAll(CollectionsKt.plus((Collection)list2, (Object)runnableProject));
                        iisApplicationConfigurationViewModel.projectSelector.getProject().set((Object)runnableProject);
                    }
                    break block15;
                }
                Iterable iterable = list2;
                boolean bl10 = false;
                Object var8_19 = null;
                boolean bl11 = false;
                for (Object t : iterable) {
                    RunnableProject runnableProject = (RunnableProject)t;
                    boolean bl12 = false;
                    if (!(Intrinsics.areEqual((Object)runnableProject.getProjectFilePath(), (Object)string) && IisApplicationConfigurationType.Companion.isTypeApplicable(runnableProject.getKind()))) continue;
                    if (bl2) {
                        object = null;
                        break block12;
                    }
                    Object t2 = t;
                    bl2 = true;
                }
                object = !bl2 ? null : var8_20;
            }
            object2 = (RunnableProject)object;
            if (object2 != null) {
                Object object3 = object2;
                boolean bl13 = false;
                iisApplicationConfigurationViewModel.projectSelector.getProject().set(object3);
                RunnableProjectRunOptions runnableProjectRunOptions = RunnableProjectExKt.getRunOptions((RunnableProject)object3);
                String string2 = bl ? runnableProjectRunOptions.getStartBrowserUrl() : dotNetStartBrowserParameters.getUrl();
                iisApplicationConfigurationViewModel.urlEditor.getDefaultValue().setValue((Object)string2);
                iisApplicationConfigurationViewModel.urlEditor.getText().setValue((Object)string2);
            }
        }
        iisApplicationConfigurationViewModel.isLoaded = true;
        return Unit.INSTANCE;
    }
}

