/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.exe;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.jetbrains.rider.run.DotNetProcessRunProfileStateKt;
import com.jetbrains.rider.run.ICheckableRunProfileState;
import com.jetbrains.rider.run.configurations.exe.CommandLineRunProfileState;
import com.jetbrains.rider.run.configurations.exe.ExeConfigurationParameters;
import com.jetbrains.rider.run.configurations.exe.ProcessExecutionDetails;
import com.jetbrains.rider.run.environment.ExecutableType;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLineKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/run/configurations/exe/ExeRunProfileState;", "Lcom/jetbrains/rider/run/configurations/exe/CommandLineRunProfileState;", "Lcom/jetbrains/rider/run/ICheckableRunProfileState;", "parameters", "Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationParameters;", "executableType", "Lcom/jetbrains/rider/run/environment/ExecutableType;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "ExeRunProfileState", "(Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationParameters;Lcom/jetbrains/rider/run/environment/ExecutableType;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "useExternalConsole", "", "getUseExternalConsole", "()Z", "runCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getRunCommandLine", "()Lcom/intellij/execution/configurations/GeneralCommandLine;", "checkBeforeExecution", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider"})
public final class ExeRunProfileState
extends CommandLineRunProfileState
implements ICheckableRunProfileState {
    @NotNull
    private final ExeConfigurationParameters parameters;
    @NotNull
    private final ExecutableType executableType;
    @NotNull
    private final ExecutionEnvironment environment;

    public ExeRunProfileState(@NotNull ExeConfigurationParameters parameters, @NotNull ExecutableType executableType, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameters), (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)((Object)executableType), (String)"executableType");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(environment);
        this.parameters = parameters;
        this.executableType = executableType;
        this.environment = environment;
    }

    @Override
    protected boolean getUseExternalConsole() {
        return this.parameters.getUseExternalConsole();
    }

    @Override
    @NotNull
    protected GeneralCommandLine getRunCommandLine() {
        ProcessExecutionDetails processExecutionDetails = ProcessExecutionDetails.Companion.fromEnvironment(this.environment);
        GeneralCommandLine generalCommandLine = DotNetProcessRunProfileStateKt.createEmptyConsoleCommandLine(this.parameters.getUseExternalConsole(), this.executableType, this.parameters.shouldUsePty(processExecutionDetails));
        GeneralCommandLine generalCommandLine2 = generalCommandLine.withEnvironment(this.parameters.getEnvs()).withParentEnvironmentType(this.parameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE).withExePath(this.parameters.getExePath()).withWorkDirectory(this.parameters.getWorkingDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withWorkDirectory(...)");
        return FormatPreservingCommandLineKt.withRawParameters((GeneralCommandLine)generalCommandLine2, (String)this.parameters.getProgramParameters());
    }

    @Override
    @Nullable
    public Object checkBeforeExecution(@NotNull Continuation<? super Unit> $completion) {
        try {
            this.parameters.validate();
        }
        catch (RuntimeConfigurationError runtimeConfigurationError) {
            throw new CantRunException(runtimeConfigurationError.getMessage());
        }
        return Unit.INSTANCE;
    }
}

