/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.dotNetExe;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.LifetimedSettingsEditor;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesEditor;
import com.jetbrains.rider.run.configurations.controls.FlagEditor;
import com.jetbrains.rider.run.configurations.controls.PathSelector;
import com.jetbrains.rider.run.configurations.controls.ProgramParametersEditor;
import com.jetbrains.rider.run.configurations.controls.runtimeSelection.RuntimeSelector;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationEditorKt;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationParameters;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationViewModel;
import com.jetbrains.rider.runtime.DotNetRuntimeType;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/run/configurations/dotNetExe/DotNetExeConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/LifetimedSettingsEditor;", "Lcom/jetbrains/rider/run/configurations/dotNetExe/DotNetExeConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "DotNetExeConfigurationEditor", "(Lcom/intellij/openapi/project/Project;)V", "viewModel", "Lcom/jetbrains/rider/run/configurations/dotNetExe/DotNetExeConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/run/configurations/dotNetExe/DotNetExeConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/run/configurations/dotNetExe/DotNetExeConfigurationViewModel;)V", "resetEditorFrom", "", "configuration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider"})
public class DotNetExeConfigurationEditor
extends LifetimedSettingsEditor<DotNetExeConfiguration> {
    @NotNull
    private final Project project;
    public DotNetExeConfigurationViewModel viewModel;

    public DotNetExeConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final DotNetExeConfigurationViewModel getViewModel() {
        DotNetExeConfigurationViewModel dotNetExeConfigurationViewModel = this.viewModel;
        if (dotNetExeConfigurationViewModel != null) {
            return dotNetExeConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull DotNetExeConfigurationViewModel dotNetExeConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)dotNetExeConfigurationViewModel, (String)"<set-?>");
        this.viewModel = dotNetExeConfigurationViewModel;
    }

    protected void resetEditorFrom(@NotNull DotNetExeConfiguration configuration) {
        DotNetExeConfigurationParameters dotNetExeConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        DotNetExeConfigurationParameters dotNetExeConfigurationParameters2 = dotNetExeConfigurationParameters = configuration.getParameters();
        boolean bl = false;
        this.getViewModel().reset(dotNetExeConfigurationParameters2.getExePath(), dotNetExeConfigurationParameters2.getProgramParameters(), dotNetExeConfigurationParameters2.getWorkingDirectory(), dotNetExeConfigurationParameters2.getEnvs(), dotNetExeConfigurationParameters2.isPassParentEnvs(), dotNetExeConfigurationParameters2.getRuntimeType(), dotNetExeConfigurationParameters2.getRuntimeArguments(), dotNetExeConfigurationParameters2.getUseExternalConsole(), dotNetExeConfigurationParameters2.getAutoAttachToChildren(), dotNetExeConfigurationParameters2.getEnvFilePaths(), dotNetExeConfigurationParameters2.getMixedModeDebugging(), dotNetExeConfigurationParameters2.getRedirectInputPath());
    }

    protected void applyEditorTo(@NotNull DotNetExeConfiguration configuration) {
        IProperty<Boolean> iProperty;
        IProperty<String> iProperty2;
        IProperty<Boolean> iProperty3;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        configuration.getParameters().setExePath(FileUtil.toSystemIndependentName((String)((String)this.getViewModel().getExePathSelector().getPath().getValue())));
        configuration.getParameters().setProgramParameters((String)this.getViewModel().getProgramParametersEditor().getParametersString().getValue());
        configuration.getParameters().setWorkingDirectory(FileUtil.toSystemIndependentName((String)((String)this.getViewModel().getWorkingDirectorySelector().getPath().getValue())));
        configuration.getParameters().setEnvs((Map)this.getViewModel().getEnvironmentVariablesEditor().getEnvs().getValue());
        configuration.getParameters().setPassParentEnvs((Boolean)this.getViewModel().getEnvironmentVariablesEditor().isPassParentEnvs().getValue());
        configuration.getParameters().setRuntimeArguments((String)this.getViewModel().getRuntimeArgumentsEditor().getParametersString().getValue());
        configuration.getParameters().setRuntimeType((DotNetRuntimeType)this.getViewModel().getRuntimeSelector().getRuntime().getValue());
        configuration.getParameters().setUseExternalConsole((Boolean)this.getViewModel().getUseExternalConsoleEditor().isSelected().getValue());
        configuration.getParameters().setAutoAttachToChildren((iProperty3 = this.getViewModel().getAutoAttachChildrenCheckBox()) != null && (iProperty3 = iProperty3.isSelected()) != null ? (Boolean)iProperty3.getValue() : false);
        configuration.getParameters().setEnvFilePaths((List)this.getViewModel().getEnvironmentVariablesEditor().getEnvFilePaths().getValue());
        configuration.getParameters().setRedirectInputPath((iProperty2 = this.getViewModel().getRedirectInputFileSelector()) != null && (iProperty2 = iProperty2.getPath()) != null ? (String)iProperty2.getValue() : null);
        configuration.getParameters().setMixedModeDebugging((iProperty = this.getViewModel().getMixedModeDebuggingCheckBox()) != null && (iProperty = iProperty.isSelected()) != null ? ((Boolean)iProperty.getValue()).booleanValue() : false);
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        PathSelector pathSelector = new PathSelector(RiderRunBundle.Companion.message("label.exe.path.with.colon", new Object[0]), "Exe_path", new FileChooserDescriptor(){
            {
                if (SystemInfoRt.isWindows) {
                    String[] stringArray = new String[]{"exe", "dll"};
                    this.withExtensionFilter(RiderRunBundle.Companion.message("label.dialog.executable.extension.filter", new Object[0]), stringArray);
                }
            }

            protected boolean matchesFilters(VirtualFile file2) {
                Object object;
                return SystemInfoRt.isWindows || ((object = file2) != null && (object = DocumentUtilKt.toIOFile((VirtualFile)object)) != null ? ((File)object).canExecute() : false);
            }
        }, lifetime);
        String string = ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setViewModel(new DotNetExeConfigurationViewModel(lifetime, this.project, pathSelector, new ProgramParametersEditor(string, "Program_arguments", lifetime), new PathSelector(RiderRunBundle.Companion.message("label.working.directory.with.colon", new Object[0]), "Working_directory", FileChooserDescriptorFactory.createSingleFolderDescriptor(), lifetime), new EnvironmentVariablesEditor(RiderRunBundle.Companion.message("label.environment.variables.with.colon", new Object[0]), "Environment_variables", false, true, 4, null), new RuntimeSelector(RiderRunBundle.Companion.message("label.runtime", new Object[0]), "Runtime", this.project, lifetime), new ProgramParametersEditor(RiderRunBundle.Companion.message("label.runtime.arguments.with.colons", new Object[0]), "Runtime_arguments", lifetime), true, new FlagEditor(RiderRunBundle.Companion.message("label.use.external.console", new Object[0]), "Use_external_console"), new FlagEditor(RiderRunBundle.Companion.message("label.flag.debug.attach-to-child-net-processes", new Object[0]), "AutoAttachChildren"), DotNetExeConfigurationEditorKt.createMixedModeRunEditorFlag(), new PathSelector(RiderRunBundle.Companion.message("label.redirect.input.from", new Object[0]), "Redirect_Input", FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), lifetime)));
        return new ControlViewBuilder(lifetime, this.project, "RunExe").build(this.getViewModel());
    }
}

