/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurationIconCache;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\"\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/run/configurations/RunnableProjectListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/RunnableProjectsModel;", "RunnableProjectListener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "G", "project", "Lcom/intellij/openapi/project/Project;", "projectPathFilter", "", "Ljava/nio/file/Path;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRunnableProjectListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunnableProjectListener.kt\ncom/jetbrains/rider/run/configurations/RunnableProjectListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n1557#2:65\n1628#2,3:66\n1557#2:69\n1628#2,3:70\n15#3:73\n*S KotlinDebug\n*F\n+ 1 RunnableProjectListener.kt\ncom/jetbrains/rider/run/configurations/RunnableProjectListener\n*L\n38#1:65\n38#1:66,3\n39#1:69\n39#1:70,3\n18#1:73\n*E\n"})
public final class RunnableProjectListener
implements SolutionExtListener<RunnableProjectsModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull RunnableProjectsModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        FrontendSessionsUtilKt.getProtocolModel((ClientProjectSession)session).isLoaded().getChange().advise(lifetime, arg_0 -> RunnableProjectListener.G(this, session, arg_0));
        SourceExKt.adviseWithPrev((ISource)((ISource)model.getProjects()), (Lifetime)lifetime, (arg_0, arg_1) -> RunnableProjectListener.G(this, session, arg_0, arg_1));
    }

    private final void G(Project project, Set<? extends Path> set) {
        RunManagerImpl runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(project);
        int n = 0;
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : runManagerImpl.getAllSettings()) {
            RunConfiguration runConfiguration = runnerAndConfigurationSettings.getConfiguration();
            IProjectBasedRunConfiguration iProjectBasedRunConfiguration = runConfiguration instanceof IProjectBasedRunConfiguration ? (IProjectBasedRunConfiguration)runConfiguration : null;
            if (iProjectBasedRunConfiguration == null) continue;
            if (set != null) {
                Path path = Paths.get(iProjectBasedRunConfiguration.getProjectFilePath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                if (!set.contains(path)) continue;
            }
            RunConfigurationIconCache runConfigurationIconCache = runManagerImpl.getIconCache();
            String string = runnerAndConfigurationSettings.getUniqueID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueID(...)");
            runConfigurationIconCache.remove(string);
            ++n;
        }
        logger.info("Cleaned up the cache of " + n + " icons.");
    }

    static /* synthetic */ void refreshIcons$default(RunnableProjectListener runnableProjectListener, Project project, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = null;
        }
        runnableProjectListener.G(project, set);
    }

    private static final Unit G(RunnableProjectListener runnableProjectListener, ClientProjectSession clientProjectSession, boolean bl) {
        logger.info("Solution load state updated. Flushing icon cache.");
        RunnableProjectListener.refreshIcons$default(runnableProjectListener, clientProjectSession.getProject(), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit G(RunnableProjectListener runnableProjectListener, ClientProjectSession clientProjectSession, Maybe maybe, List list2) {
        List list3;
        List list4;
        Collection<Path> collection;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)maybe, (String)"maybeOld");
        Intrinsics.checkNotNullParameter((Object)list2, (String)"new");
        List list5 = (List)maybe.getAsNullable();
        if (list5 != null) {
            Iterable iterable2 = list5;
            boolean bl = false;
            iterable = iterable2;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            boolean bl2 = false;
            for (Object object : iterable) {
                RunnableProject runnableProject = (RunnableProject)object;
                collection = collection2;
                boolean bl3 = false;
                Path path = Paths.get(runnableProject.getProjectFilePath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                collection.add(path);
            }
            list4 = (List)collection2;
        } else {
            list4 = list3 = null;
        }
        if (list4 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Iterable iterable3 = list2;
        collection = CollectionsKt.toSet((Iterable)list3);
        boolean bl = false;
        Iterable iterable4 = iterable3;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
        boolean bl4 = false;
        for (Iterator iterator2 : iterable4) {
            Object object;
            object = (RunnableProject)iterator2;
            Iterable iterable5 = iterable;
            boolean bl5 = false;
            Path path = Paths.get(object.getProjectFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            iterable5.add(path);
        }
        Set set = SetsKt.plus((Set)collection, (Iterable)((List)iterable));
        logger.info("Runnable projects updated (" + set.size() + " items). Flushing icon cache.");
        runnableProjectListener.G(clientProjectSession.getProject(), set);
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        Logger logger2 = Logger.getInstance(RunnableProjectListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/run/configurations/RunnableProjectListener$Companion;", "", "RunnableProjectListener$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

