/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.run.ExternalConsoleProcessHandler;
import com.jetbrains.rider.run.ProcessWatchDog;
import com.jetbrains.rider.run.WinProcessWatchDog;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler;", "Lcom/jetbrains/rider/run/ExternalConsoleProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "WinExternalConsoleProcessHandler", "(Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "pid", "", "getPid", "()I", "watchDog", "Lcom/jetbrains/rider/run/ProcessWatchDog;", "getWatchDog", "()Lcom/jetbrains/rider/run/ProcessWatchDog;", "handle", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "getHandle", "()Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "destroyProcessImpl", "", "killProcess", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nExternalConsoleMediator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalConsoleMediator.kt\ncom/jetbrains/rider/run/WinExternalConsoleProcessHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,450:1\n126#2:451\n153#2,3:452\n13#3:455\n15#4:456\n*S KotlinDebug\n*F\n+ 1 ExternalConsoleMediator.kt\ncom/jetbrains/rider/run/WinExternalConsoleProcessHandler\n*L\n154#1:451\n154#1:452,3\n136#1:455\n136#1:456\n*E\n"})
public final class WinExternalConsoleProcessHandler
extends ExternalConsoleProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pid;
    @NotNull
    private final ProcessWatchDog watchDog;
    @NotNull
    private final WinNT.HANDLE handle;
    @NotNull
    private static final Logger logger;

    public WinExternalConsoleProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Memory memory;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        super(commandLine);
        if (!SystemInfo.isWindows) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = this.getCommandLineString() + "\u0000";
        Path path = commandLine.getWorkingDirectory();
        String string2 = path != null ? ((Object)path).toString() : null;
        Map map2 = commandLine.getEffectiveEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEffectiveEnvironment(...)");
        SortedMap sortedMap = MapsKt.toSortedMap((Map)MapsKt.toMutableMap((Map)map2));
        WinExternalConsoleProcessHandler winExternalConsoleProcessHandler = this;
        int n = 0;
        if (sortedMap.isEmpty()) {
            memory = null;
        } else {
            Object object = sortedMap;
            boolean bl = false;
            Map map3 = object;
            Collection collection = new ArrayList(object.size());
            boolean bl2 = false;
            Iterator iterator2 = map3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2;
                Map.Entry entry3 = entry2 = iterator2.next();
                Collection collection2 = collection;
                boolean bl3 = false;
                String string3 = (String)entry3.getKey();
                String string4 = (String)entry3.getValue();
                collection2.add(string3 + "=" + string4 + "\u0000");
            }
            String string5 = CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)"", null, (CharSequence)"\u0000", (int)0, null, null, (int)58, null);
            byte[] byArray = string5.getBytes(Charsets.UTF_16LE);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            object = byArray;
            Memory memory2 = new Memory((long)((Object)object).length);
            memory2.write(0L, (byte[])object, 0, ((Object)object).length);
            memory = memory2;
        }
        Memory memory3 = memory;
        WinBase.STARTUPINFO sTARTUPINFO = new WinBase.STARTUPINFO();
        winExternalConsoleProcessHandler = new WinBase.PROCESS_INFORMATION();
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        if (!Kernel32.INSTANCE.CreateProcessW(null, cArray, null, null, false, new WinDef.DWORD(1552L), (Pointer)memory3, string2, sTARTUPINFO, (WinBase.PROCESS_INFORMATION)winExternalConsoleProcessHandler)) {
            n = Kernel32.INSTANCE.GetLastError();
            throw new RuntimeException("CreateProcessW failed with error code: " + n);
        }
        this.handle = ((WinBase.PROCESS_INFORMATION)winExternalConsoleProcessHandler).hProcess;
        this.pid = ((WinBase.PROCESS_INFORMATION)winExternalConsoleProcessHandler).dwProcessId.intValue();
        this.getLifetimeDefinition().getLifetime().onTermination(() -> WinExternalConsoleProcessHandler.G((WinBase.PROCESS_INFORMATION)winExternalConsoleProcessHandler));
        this.watchDog = new WinProcessWatchDog(this.handle, this.getPresentableName(commandLine), (Function0<Integer>)((Function0)() -> WinExternalConsoleProcessHandler.G(this)));
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getWatchDog().setTerminationCallback((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this){

                    public final void invoke(int p0) {
                        ((WinExternalConsoleProcessHandler)((Object)this.receiver)).notifyProcessTerminated(p0);
                    }
                }));
            }
        });
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    @NotNull
    protected ProcessWatchDog getWatchDog() {
        return this.watchDog;
    }

    @NotNull
    public final WinNT.HANDLE getHandle() {
        return this.handle;
    }

    protected void destroyProcessImpl() {
        this.executeOnPooledThread(() -> WinExternalConsoleProcessHandler.G(this));
    }

    public void killProcess() {
        if (!Kernel32.INSTANCE.TerminateProcess(this.handle, -1)) {
            int n = Kernel32.INSTANCE.GetLastError();
            throw new RuntimeException("TerminateProcess failed with error code: " + n);
        }
    }

    private static final Unit G(WinBase.PROCESS_INFORMATION pROCESS_INFORMATION) {
        Kernel32.INSTANCE.CloseHandle(pROCESS_INFORMATION.hProcess);
        Kernel32.INSTANCE.CloseHandle(pROCESS_INFORMATION.hThread);
        return Unit.INSTANCE;
    }

    private static final int G(WinExternalConsoleProcessHandler winExternalConsoleProcessHandler) {
        IntByReference intByReference = new IntByReference();
        if (!Kernel32.INSTANCE.GetExitCodeProcess(winExternalConsoleProcessHandler.handle, intByReference)) {
            throw new RuntimeException("Failed to get exit code for process " + winExternalConsoleProcessHandler.getPid());
        }
        return intByReference.getValue();
    }

    private static final void G(WinExternalConsoleProcessHandler winExternalConsoleProcessHandler) {
        try {
            OSProcessUtil.terminateProcessGracefully((int)winExternalConsoleProcessHandler.getPid());
        }
        catch (Exception exception) {
            logger.warn("Failed to terminate process gracefully, so it will be terminated forcefully", (Throwable)exception);
            winExternalConsoleProcessHandler.killProcess();
        }
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(WinExternalConsoleProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler$Companion;", "", "WinExternalConsoleProcessHandler$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

