/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.run.ProcessWatchDog;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLine;
import com.jetbrains.rider.shared.run.FormatPreservingPtyCommandLine;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0018\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0015\u0010\u001a\u001a\u00070\f\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0004J\u000e\u0010\u001b\u001a\u00020\u001c*\u0004\u0018\u00010\u001dH\u0004J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\bH\u0014J\b\u0010 \u001a\u00020\u001cH\u0014J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0004J\b\u0010$\u001a\u00020\u001cH\u0014J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020&H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020&H\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/run/ExternalConsoleProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "Lcom/intellij/execution/KillableProcess;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "ExternalConsoleProcessHandler", "(Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "pid", "", "getPid", "()I", "commandLineString", "", "Lcom/intellij/openapi/util/NlsSafe;", "getCommandLineString", "()Ljava/lang/String;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "watchDog", "Lcom/jetbrains/rider/run/ProcessWatchDog;", "getWatchDog", "()Lcom/jetbrains/rider/run/ProcessWatchDog;", "G", "Lorg/jetbrains/annotations/NotNull;", "getPresentableName", "checkWorkingDirectory", "", "Ljava/io/File;", "notifyProcessTerminated", "exitCode", "notifyProcessDetached", "executeOnPooledThread", "task", "Ljava/lang/Runnable;", "detachProcessImpl", "waitFor", "", "timeoutInMilliseconds", "", "detachIsDefault", "getProcessInput", "Ljava/io/OutputStream;", "canKillProcess", "intellij.rider"})
public abstract class ExternalConsoleProcessHandler
extends ProcessHandler
implements KillableProcess {
    @NotNull
    private final String commandLineString;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;

    public ExternalConsoleProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        this.lifetimeDefinition = new LifetimeDefinition();
        this.commandLineString = this.G(commandLine);
    }

    public abstract int getPid();

    @NotNull
    public final String getCommandLineString() {
        return this.commandLineString;
    }

    @NotNull
    protected final LifetimeDefinition getLifetimeDefinition() {
        return this.lifetimeDefinition;
    }

    @NotNull
    protected abstract ProcessWatchDog getWatchDog();

    private final String G(GeneralCommandLine generalCommandLine) {
        String string;
        block5: {
            List list2;
            block6: {
                block7: {
                    boolean bl;
                    block4: {
                        if (!(generalCommandLine instanceof FormatPreservingCommandLine) && !(generalCommandLine instanceof FormatPreservingPtyCommandLine)) break block4;
                        string = generalCommandLine.getCommandLineString();
                        break block5;
                    }
                    List list3 = CommandLineUtil.toCommandLine((List)generalCommandLine.getCommandLineList(null));
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"toCommandLine(...)");
                    list2 = CollectionsKt.toMutableList((Collection)list3);
                    boolean bl2 = bl = list2.size() > 0;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    Object e2 = list2.get(0);
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                    if (!StringsKt.contains$default((CharSequence)((CharSequence)e2), (CharSequence)" ", (boolean)false, (int)2, null)) break block6;
                    Object e3 = list2.get(0);
                    Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
                    if (!StringsKt.startsWith$default((String)((String)e3), (String)"\"", (boolean)false, (int)2, null)) break block7;
                    Object e4 = list2.get(0);
                    Intrinsics.checkNotNullExpressionValue(e4, (String)"get(...)");
                    if (StringsKt.endsWith$default((String)((String)e4), (String)"\"", (boolean)false, (int)2, null)) break block6;
                }
                list2.set(0, "\"" + list2.get(0) + "\"");
            }
            string = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        return string3;
    }

    @NotNull
    protected final String getPresentableName(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        String string = CommandLineUtil.extractPresentableName((String)StringUtil.notNullize((String)commandLine.getCommandLineString()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractPresentableName(...)");
        return string;
    }

    protected final void checkWorkingDirectory(@Nullable File $this$checkWorkingDirectory) {
        if ($this$checkWorkingDirectory == null) {
            return;
        }
        if (!$this$checkWorkingDirectory.exists()) {
            Object[] objectArray = new Object[]{$this$checkWorkingDirectory};
            throw new ExecutionException(RiderRunBundle.Companion.message("ExternalConsoleMediator.dialog.message.working.directory.does.not.exist", objectArray));
        }
        if (!$this$checkWorkingDirectory.isDirectory()) {
            Object[] objectArray = new Object[]{$this$checkWorkingDirectory};
            throw new ExecutionException(RiderRunBundle.Companion.message("ExternalConsoleMediator.dialog.message.directory.not.directory", objectArray));
        }
    }

    protected void notifyProcessTerminated(int exitCode) {
        super.notifyProcessTerminated(exitCode);
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
    }

    protected void notifyProcessDetached() {
        super.notifyProcessDetached();
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
    }

    protected final void executeOnPooledThread(@NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Application application = ApplicationKt.getApplicationOrNull();
        if (!(application != null ? !application.isUnitTestMode() : false)) {
            task2.run();
        } else {
            ProcessIOExecutorService.INSTANCE.submit(task2);
        }
    }

    protected void detachProcessImpl() {
        this.executeOnPooledThread(() -> ExternalConsoleProcessHandler.G(this));
    }

    public boolean waitFor() {
        boolean bl = super.waitFor();
        try {
            this.getWatchDog().waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return bl;
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        boolean bl = super.waitFor(timeoutInMilliseconds);
        try {
            bl = bl && this.getWatchDog().waitFor(timeoutInMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return bl;
    }

    public boolean detachIsDefault() {
        return false;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public boolean canKillProcess() {
        return true;
    }

    private static final void G(ExternalConsoleProcessHandler externalConsoleProcessHandler) {
        externalConsoleProcessHandler.getWatchDog().detach();
        externalConsoleProcessHandler.notifyProcessDetached();
    }
}

