/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.debugger.RiderDebuggerElevationUtilKt;
import com.jetbrains.rider.run.ConsoleKind;
import com.jetbrains.rider.run.DotNetProcessRunProfileStateKt;
import com.jetbrains.rider.run.ExternalConsoleMediator;
import com.jetbrains.rider.run.IDotNetProfileState;
import com.jetbrains.rider.run.PatchCommandLineExtension;
import com.jetbrains.rider.run.ProcessHandlerExKt;
import com.jetbrains.rider.run.TerminalProcessHandler;
import com.jetbrains.rider.run.configurations.launchSettings.IisUtils;
import com.jetbrains.rider.runtime.DotNetExecutable;
import com.jetbrains.rider.runtime.DotNetRuntime;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/run/DotNetProcessRunProfileState;", "Lcom/jetbrains/rider/run/IDotNetProfileState;", "dotNetExecutable", "Lcom/jetbrains/rider/runtime/DotNetExecutable;", "dotNetRuntime", "Lcom/jetbrains/rider/runtime/DotNetRuntime;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "DotNetProcessRunProfileState", "(Lcom/jetbrains/rider/runtime/DotNetExecutable;Lcom/jetbrains/rider/runtime/DotNetRuntime;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "getDotNetExecutable", "()Lcom/jetbrains/rider/runtime/DotNetExecutable;", "getDotNetRuntime", "()Lcom/jetbrains/rider/runtime/DotNetRuntime;", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetProcessRunProfileState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetProcessRunProfileState.kt\ncom/jetbrains/rider/run/DotNetProcessRunProfileState\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n25#2:194\n84#2,3:205\n11476#3,9:195\n13402#3:204\n13403#3:209\n11485#3:210\n1#4:208\n1863#5,2:211\n*S KotlinDebug\n*F\n+ 1 DotNetProcessRunProfileState.kt\ncom/jetbrains/rider/run/DotNetProcessRunProfileState\n*L\n51#1:194\n53#1:205,3\n52#1:195,9\n52#1:204\n52#1:209\n52#1:210\n52#1:208\n75#1:211,2\n*E\n"})
public final class DotNetProcessRunProfileState
implements IDotNetProfileState {
    @TestOnly
    @NotNull
    private final DotNetExecutable dotNetExecutable;
    @TestOnly
    @NotNull
    private final DotNetRuntime dotNetRuntime;
    @NotNull
    private final ExecutionEnvironment environment;

    public DotNetProcessRunProfileState(@NotNull DotNetExecutable dotNetExecutable, @NotNull DotNetRuntime dotNetRuntime, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)dotNetExecutable, (String)"dotNetExecutable");
        Intrinsics.checkNotNullParameter((Object)dotNetRuntime, (String)"dotNetRuntime");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.dotNetExecutable = dotNetExecutable;
        this.dotNetRuntime = dotNetRuntime;
        this.environment = environment;
    }

    @NotNull
    public final DotNetExecutable getDotNetExecutable() {
        return this.dotNetExecutable;
    }

    @NotNull
    public final DotNetRuntime getDotNetRuntime() {
        return this.dotNetRuntime;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor2, @NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        try {
            ProcessHandler processHandler2;
            int n;
            this.dotNetExecutable.validate();
            GeneralCommandLine generalCommandLine = DotNetProcessRunProfileStateKt.createRunCommandLine(this.dotNetExecutable, this.dotNetRuntime);
            String string = generalCommandLine.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = path;
            Object object = this;
            boolean bl = false;
            Logger logger2 = Logger.getInstance(DotNetProcessRunProfileState.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            Logger logger3 = logger2;
            Project project = PatchCommandLineExtension.Companion.getEP_NAME().getExtensions((AreaInstance)this.environment.getProject());
            boolean bl2 = false;
            Project project2 = project;
            Iterable<ProcessListener> iterable = new ArrayList();
            boolean bl3 = false;
            Project project3 = project2;
            boolean bl4 = false;
            int n2 = ((Object[])project3).length;
            for (n = 0; n < n2; ++n) {
                ProcessListener processListener;
                Object object2;
                Object object3;
                Object object4 = object3 = project3[n];
                boolean bl5 = false;
                PatchCommandLineExtension patchCommandLineExtension = (PatchCommandLineExtension)object4;
                boolean bl6 = false;
                Logger logger4 = logger3;
                boolean bl7 = false;
                Logger logger5 = logger4;
                try {
                    object2 = logger5;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Project project4 = this.environment.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                    object2 = Result.constructor-impl((Object)patchCommandLineExtension.patchRunCommandLine(generalCommandLine, this.dotNetRuntime, project4));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if ((ProcessListener)LoggerKt.getOrLogException((Object)object2, (Logger)logger4) == null) continue;
                boolean bl10 = false;
                iterable.add(processListener);
            }
            object = (List)iterable;
            Project project5 = this.environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
            project = project5;
            Function1<ProcessHandler, Boolean> function1 = IisUtils.INSTANCE.guessGracefulTerminationHandler(project, this.environment, this.dotNetExecutable);
            if (this.dotNetExecutable.getUseExternalConsole()) {
                processHandler2 = ExternalConsoleMediator.INSTANCE.createProcessHandler(generalCommandLine);
            } else {
                Project project6 = this.environment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
                processHandler2 = (ProcessHandler)new TerminalProcessHandler(project6, generalCommandLine, generalCommandLine.getCommandLineString(), false, function1, path2, 8, null);
            }
            project2 = processHandler2;
            Long l = ProcessHandlerExKt.pid((ProcessHandler)project2);
            if (l != null) {
                long l2 = ((Number)l).longValue();
                n = 0;
                this.environment.putUserData(DebuggerWorkerProcessHandler.Companion.getPID_KEY(), (Object)((int)l2));
            }
            iterable = (Iterable)object;
            bl3 = false;
            for (Object e2 : iterable) {
                ProcessListener processListener = (ProcessListener)e2;
                n2 = 0;
                project2.addProcessListener(processListener);
            }
            iterable = DotNetProcessRunProfileStateKt.createConsole$default(this.dotNetExecutable.getUseExternalConsole() ? ConsoleKind.ExternalConsole : ConsoleKind.Normal, (ProcessHandler)project2, project, null, 8, null);
            Function3<ExecutionEnvironment, RunProfile, ProcessHandler, Unit> function3 = this.dotNetExecutable.getOnBeforeProcessStarted();
            RunProfile runProfile2 = this.environment.getRunProfile();
            Intrinsics.checkNotNullExpressionValue((Object)runProfile2, (String)"getRunProfile(...)");
            function3.invoke((Object)this.environment, (Object)runProfile2, (Object)project2);
            AnAction[] anActionArray = AnAction.EMPTY_ARRAY;
            return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)iterable, (ProcessHandler)project2, Arrays.copyOf(anActionArray, anActionArray.length));
        }
        catch (Throwable throwable) {
            Project project = this.environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RiderDebuggerElevationUtilKt.showElevationDialogIfNeeded(throwable, project);
            throw new ExecutionException(throwable);
        }
    }
}

