/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rider.model.RunnableProjectKind;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="AutoGeneratedRunConfigurationManager", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\tJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012J\"\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012*\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/run/AutoGeneratedRunConfigurationManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "AutoGeneratedRunConfigurationManager", "(Lcom/intellij/openapi/project/Project;)V", "generatedProjects", "", "", "", "Lcom/jetbrains/rider/run/AutoGeneratedRunConfigurationManager$ProjectParameter;", "lock", "", "hasRunConfigurationEverBeenGenerated", "", "projectFilePath", "parameters", "", "markProjectAsAutoGenerated", "", "forgetProjectAsAutoGenerated", "getRelativeToProjectStoredPath", "kind", "Lcom/jetbrains/rider/model/RunnableProjectKind;", "G", "getState", "loadState", "element", "ProjectParameter", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nAutoGeneratedRunConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoGeneratedRunConfigurationManager.kt\ncom/jetbrains/rider/run/AutoGeneratedRunConfigurationManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n168#2,3:126\n66#3,3:129\n66#3,3:133\n1053#4:132\n*S KotlinDebug\n*F\n+ 1 AutoGeneratedRunConfigurationManager.kt\ncom/jetbrains/rider/run/AutoGeneratedRunConfigurationManager\n*L\n28#1:126,3\n40#1:129,3\n118#1:133,3\n96#1:132\n*E\n"})
public final class AutoGeneratedRunConfigurationManager
implements PersistentStateComponent<Element> {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, Set<ProjectParameter>> generatedProjects;
    @NotNull
    private final Object lock;

    public AutoGeneratedRunConfigurationManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.generatedProjects = new LinkedHashMap();
        this.lock = new Object();
    }

    public final boolean hasRunConfigurationEverBeenGenerated(@NotNull String projectFilePath) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        return this.hasRunConfigurationEverBeenGenerated(projectFilePath, MapsKt.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasRunConfigurationEverBeenGenerated(@NotNull String projectFilePath, @NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Object object = this.lock;
        synchronized (object) {
            Map.Entry<String, String> entry2;
            Set<ProjectParameter> set;
            block7: {
                boolean bl = false;
                boolean bl2 = FileUtil.isAbsolute((String)projectFilePath);
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                String string = this.getRelativeToProjectStoredPath(projectFilePath);
                if (this.generatedProjects.get(string) != null) break block7;
                return false;
            }
            Set<ProjectParameter> set2 = set;
            if (parameters.isEmpty()) return true;
            Map<String, String> map2 = parameters;
            boolean bl = false;
            if (map2.isEmpty()) {
                return true;
            }
            Iterator<Map.Entry<String, String>> iterator2 = map2.entrySet().iterator();
            do {
                Map.Entry<String, String> entry3;
                if (!iterator2.hasNext()) return true;
                entry2 = entry3 = iterator2.next();
                boolean bl3 = false;
            } while (set2.contains(new ProjectParameter(entry2.getKey(), entry2.getValue())));
            return false;
        }
    }

    public final void markProjectAsAutoGenerated(@NotNull String projectFilePath) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        this.markProjectAsAutoGenerated(projectFilePath, MapsKt.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markProjectAsAutoGenerated(@NotNull String projectFilePath, @NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = FileUtil.isAbsolute((String)projectFilePath);
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String string = this.getRelativeToProjectStoredPath(projectFilePath);
            Map<String, Set<ProjectParameter>> map2 = this.generatedProjects;
            boolean bl3 = false;
            Set set = map2.get(string);
            if (set == null) {
                String string2 = string;
                boolean bl4 = false;
                Set set2 = new LinkedHashSet();
                boolean bl5 = false;
                map2.put(string, set2);
                set = set2;
            }
            Set set3 = set;
            for (Map.Entry entry2 : parameters.entrySet()) {
                set3.add(new ProjectParameter((String)entry2.getKey(), (String)entry2.getValue()));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forgetProjectAsAutoGenerated(@NotNull String projectFilePath, @NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = FileUtil.isAbsolute((String)projectFilePath);
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String string = this.getRelativeToProjectStoredPath(projectFilePath);
            Set<ProjectParameter> set = this.generatedProjects.remove(string);
        }
    }

    @NotNull
    public final String getRelativeToProjectStoredPath(@NotNull String projectFilePath) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        String string = this.project.getBasePath();
        if (string == null) {
            return projectFilePath;
        }
        String string2 = string;
        String string3 = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)string2), (String)FileUtil.toSystemIndependentName((String)projectFilePath), (char)'/');
        if (string3 == null) {
            string3 = projectFilePath;
        }
        return string3;
    }

    public final boolean hasRunConfigurationEverBeenGenerated(@NotNull String projectFilePath, @NotNull RunnableProjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return this.hasRunConfigurationEverBeenGenerated(projectFilePath, this.G(kind));
    }

    public final void markProjectAsAutoGenerated(@NotNull String projectFilePath, @NotNull RunnableProjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.markProjectAsAutoGenerated(projectFilePath, this.G(kind));
    }

    public final void forgetProjectAsAutoGenerated(@NotNull String projectFilePath, @NotNull RunnableProjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.forgetProjectAsAutoGenerated(projectFilePath, this.G(kind));
    }

    private final Map<String, String> G(RunnableProjectKind runnableProjectKind) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"kind", (Object)runnableProjectKind.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Element getState() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Element element = new Element("state");
            Iterable iterable2 = MapsKt.toList(this.generatedProjects);
            boolean bl2 = false;
            for (Iterable iterable2 : CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair pair = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)pair.getFirst()));
                    pair = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)pair.getFirst()))));
                }
            })) {
                Element element2;
                Object object2;
                Object object3;
                String string = (String)iterable2.component1();
                Set set = (Set)iterable2.component2();
                if (set.isEmpty()) {
                    object2 = object3 = new Element("projectFile");
                    element2 = element;
                    boolean bl3 = false;
                    object2.setText(string);
                    element2.addContent((Element)object3);
                    continue;
                }
                object2 = new Element[]{AutoGeneratedRunConfigurationManager::G, AutoGeneratedRunConfigurationManager::b};
                object3 = CollectionsKt.sortedWith((Iterable)set, (Comparator)ComparisonsKt.compareBy((Function1[])object2)).iterator();
                while (object3.hasNext()) {
                    Element element3;
                    object2 = (ProjectParameter)object3.next();
                    Element element4 = element3 = new Element("projectFile");
                    element2 = element;
                    boolean bl4 = false;
                    element4.setText(string);
                    element4.setAttributes(CollectionsKt.listOf((Object)new Attribute(((ProjectParameter)object2).getName(), ((ProjectParameter)object2).getValue())));
                    element2.addContent(element3);
                }
            }
            Element element5 = element;
            return element5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            for (Content content : element.getContent()) {
                String string3;
                Intrinsics.checkNotNull((Object)content, (String)"null cannot be cast to non-null type org.jdom.Element");
                Element element2 = (Element)content;
                Map<String, Set<ProjectParameter>> map2 = this.generatedProjects;
                Intrinsics.checkNotNullExpressionValue((Object)((Element)content).getValue(), (String)"getValue(...)");
                boolean bl2 = false;
                Set set = map2.get(string3);
                if (set == null) {
                    String string2 = string3;
                    boolean bl3 = false;
                    Set set2 = new LinkedHashSet();
                    boolean bl4 = false;
                    map2.put(string3, set2);
                    set = set2;
                }
                Set set3 = set;
                for (String string3 : element2.getAttributes()) {
                    String string4 = string3.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                    String string5 = string3.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
                    set3.add(new ProjectParameter(string4, string5));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Comparable G(ProjectParameter projectParameter) {
        Intrinsics.checkNotNullParameter((Object)projectParameter, (String)"it");
        return (Comparable)((Object)projectParameter.getName());
    }

    private static final Comparable b(ProjectParameter projectParameter) {
        Intrinsics.checkNotNullParameter((Object)projectParameter, (String)"it");
        return (Comparable)((Object)projectParameter.getValue());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/run/AutoGeneratedRunConfigurationManager$ProjectParameter;", "", "name", "", "value", "AutoGeneratedRunConfigurationManager$ProjectParameter", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    private static final class ProjectParameter {
        @NotNull
        private final String name;
        @NotNull
        private final String value;

        public ProjectParameter(@NotNull String name, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.name = name;
            this.value = value2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final ProjectParameter copy(@NotNull String name, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new ProjectParameter(name, value2);
        }

        public static /* synthetic */ ProjectParameter copy$default(ProjectParameter projectParameter, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = projectParameter.name;
            }
            if ((n & 2) != 0) {
                string2 = projectParameter.value;
            }
            return projectParameter.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ProjectParameter(name=" + this.name + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int n = this.name.hashCode();
            n = n * 31 + this.value.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectParameter)) {
                return false;
            }
            ProjectParameter projectParameter = (ProjectParameter)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)projectParameter.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)projectParameter.value);
        }
    }
}

