/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.roslyn.visualizer.window;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.rider.model.RdRoslynSyntaxTreeEntryFrontend;
import com.jetbrains.rider.model.RoslynFrontendModel;
import com.jetbrains.rider.roslyn.RoslynHost;
import com.jetbrains.rider.roslyn.visualizer.bundles.RoslynVisualizerBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/roslyn/visualizer/window/RoslynVisualizerSelectInTarget;", "Lcom/intellij/ide/SelectInTarget;", "RoslynVisualizerSelectInTarget", "()V", "canSelect", "", "context", "Lcom/intellij/ide/SelectInContext;", "selectIn", "", "requestFocus", "toString", "", "getToolWindowId", "getWeight", "", "intellij.rider"})
public final class RoslynVisualizerSelectInTarget
implements SelectInTarget {
    public boolean canSelect(@Nullable SelectInContext context) {
        SelectInContext selectInContext = context;
        Intrinsics.checkNotNull((Object)selectInContext);
        VirtualFile virtualFile = selectInContext.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RoslynFrontendModel roslynFrontendModel = RoslynHost.Companion.getInstance(project).getModel();
        Object object = (RdRoslynSyntaxTreeEntryFrontend)roslynFrontendModel.getRoslynSyntaxTree().getValueOrNull();
        boolean bl = object != null && (object = object.isActive()) != null && (object = (Boolean)object.getValueOrNull()) != null ? (Boolean)object : false;
        return virtualFile2.isValid() && bl;
    }

    public void selectIn(@Nullable SelectInContext context, boolean requestFocus) {
        if (!this.canSelect(context) || context == null) {
            return;
        }
        AnAction anAction = ActionManager.getInstance().getAction("RoslynVisualizerTreeExpand");
        AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)anAction, (DataContext)SimpleDataContext.getProjectContext((Project)context.getProject()), null, (String)"", (ActionUiKind)((ActionUiKind)ActionUiKind.TOOLBAR), null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent anActionEvent2 = anActionEvent;
        if (requestFocus) {
            ToolWindow toolWindow;
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("RoslynVisualizer");
            if (toolWindow2 != null) {
                toolWindow2.activate(null);
            }
        }
        anAction.actionPerformed(anActionEvent2);
    }

    @NotNull
    public String toString() {
        return RoslynVisualizerBundle.INSTANCE.message("RoslynVisualizer.SelectionInTarget.name", new Object[0]);
    }

    @NotNull
    public String getToolWindowId() {
        return "RoslynVisualizer";
    }

    public float getWeight() {
        return 100.0f;
    }
}

