/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.roslyn.visualizer.tree.listeners;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.model.RdRoslynSyntaxTreeEntryFrontend;
import com.jetbrains.rider.model.RiderSolutionLifecycle;
import com.jetbrains.rider.model.RiderSolutionLifecycle_PregeneratedKt;
import com.jetbrains.rider.model.RoslynFrontendModel;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.roslyn.RoslynHost;
import com.jetbrains.rider.roslyn.visualizer.tree.actions.RoslynToggleToCaretAction;
import com.jetbrains.rider.roslyn.visualizer.tree.utils.UtilsKt;
import com.jetbrains.rider.roslyn.visualizer.window.RoslynVisualizerPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/roslyn/visualizer/tree/listeners/RoslynFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "RoslynFileEditorManagerListener", "()V", "TOGGLE_ACTION_ID", "", "fileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "fileClosed", "intellij.rider"})
public final class RoslynFileEditorManagerListener
implements FileEditorManagerListener {
    @NotNull
    private final String TOGGLE_ACTION_ID;

    public RoslynFileEditorManagerListener() {
        this.TOGGLE_ACTION_ID = "RoslynVisualizerToggleToCaret";
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        RoslynFrontendModel roslynFrontendModel = RoslynHost.Companion.getInstance(project2).getModel();
        Object object = (RdRoslynSyntaxTreeEntryFrontend)roslynFrontendModel.getRoslynSyntaxTree().getValueOrNull();
        if (object == null || (object = object.isActive()) == null || (object = (Boolean)object.getValueOrNull()) == null) {
            return;
        }
        boolean bl = (Boolean)object;
        if (!bl) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("RoslynVisualizer");
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        Project project3 = toolWindow2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        RiderSolutionLifecycle riderSolutionLifecycle = RiderSolutionLifecycle_PregeneratedKt.getRiderSolutionLifecycle((Solution)SolutionHostExtensionsKt.getSolution((Project)project3));
        if (!Intrinsics.areEqual((Object)roslynFrontendModel.getRoslynReady().getValueOrNull(), (Object)true) && !Intrinsics.areEqual((Object)riderSolutionLifecycle.isProjectModelReady().getValueOrNull(), (Object)true)) {
            return;
        }
        RoslynVisualizerPanel roslynVisualizerPanel = UtilsKt.getRoslynPanel(project2);
        if (roslynVisualizerPanel == null) {
            return;
        }
        RoslynVisualizerPanel roslynVisualizerPanel2 = roslynVisualizerPanel;
        if (!roslynVisualizerPanel2.isFileExtensionSupported(file2)) {
            roslynVisualizerPanel2.setTreeVisible(false);
            roslynVisualizerPanel2.hideTable();
            return;
        }
        roslynVisualizerPanel2.setTreeVisible(true);
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        roslynVisualizerPanel2.updateRoslynSyntaxTree(string);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Project project3 = event.getManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        RoslynFrontendModel roslynFrontendModel = RoslynHost.Companion.getInstance(project3).getModel();
        VirtualFile virtualFile = event.getNewFile();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction(this.TOGGLE_ACTION_ID);
        Object object = (RdRoslynSyntaxTreeEntryFrontend)roslynFrontendModel.getRoslynSyntaxTree().getValueOrNull();
        if (object == null || (object = object.isActive()) == null || (object = (Boolean)object.getValueOrNull()) == null) {
            return;
        }
        boolean bl = (Boolean)object;
        if (!bl) {
            return;
        }
        if (anAction instanceof RoslynToggleToCaretAction && event.getNewFile() != null) {
            RoslynToggleToCaretAction roslynToggleToCaretAction = (RoslynToggleToCaretAction)anAction;
            VirtualFile virtualFile2 = event.getNewFile();
            Intrinsics.checkNotNull((Object)virtualFile2);
            roslynToggleToCaretAction.changeFilePerformed(project2, virtualFile2);
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("RoslynVisualizer");
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        Project project4 = toolWindow2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        RiderSolutionLifecycle riderSolutionLifecycle = RiderSolutionLifecycle_PregeneratedKt.getRiderSolutionLifecycle((Solution)SolutionHostExtensionsKt.getSolution((Project)project4));
        if (!Intrinsics.areEqual((Object)roslynFrontendModel.getRoslynReady().getValueOrNull(), (Object)true) && !Intrinsics.areEqual((Object)riderSolutionLifecycle.isProjectModelReady().getValueOrNull(), (Object)true)) {
            return;
        }
        if (virtualFile != null) {
            RoslynVisualizerPanel roslynVisualizerPanel = UtilsKt.getRoslynPanel(project2);
            if (roslynVisualizerPanel == null) {
                return;
            }
            RoslynVisualizerPanel roslynVisualizerPanel2 = roslynVisualizerPanel;
            if (!roslynVisualizerPanel2.isFileExtensionSupported(virtualFile)) {
                roslynVisualizerPanel2.setTreeVisible(false);
                roslynVisualizerPanel2.hideTable();
                return;
            }
            roslynVisualizerPanel2.setTreeVisible(true);
            String string = virtualFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            roslynVisualizerPanel2.updateRoslynSyntaxTree(string);
            roslynVisualizerPanel2.hideTable();
        }
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (source.getSelectedTextEditor() == null) {
            RoslynVisualizerPanel roslynVisualizerPanel = UtilsKt.getRoslynPanel(project2);
            if (roslynVisualizerPanel == null) {
                return;
            }
            RoslynVisualizerPanel roslynVisualizerPanel2 = roslynVisualizerPanel;
            roslynVisualizerPanel2.setDefaultEmptyText();
            roslynVisualizerPanel2.hideTable();
            roslynVisualizerPanel2.setTreeVisible(false);
        }
    }
}

