/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.roslyn.visualizer.tree.listeners;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.model.RdRoslynSyntaxTreeEntryFrontend;
import com.jetbrains.rider.model.RiderSolutionLifecycle;
import com.jetbrains.rider.model.RiderSolutionLifecycle_PregeneratedKt;
import com.jetbrains.rider.model.RoslynFrontendModel;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.roslyn.RoslynHost;
import com.jetbrains.rider.roslyn.visualizer.tree.utils.UtilsKt;
import com.jetbrains.rider.roslyn.visualizer.window.RoslynVisualizerPanel;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/roslyn/visualizer/tree/listeners/RoslynDocumentListener;", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "RoslynDocumentListener", "(Lcom/intellij/openapi/wm/ToolWindow;)V", "handleFileChanged", "", "file", "Ljava/io/File;", "G", "", "intellij.rider"})
public final class RoslynDocumentListener {
    @NotNull
    private final ToolWindow toolWindow;

    public RoslynDocumentListener(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.toolWindow = toolWindow;
    }

    public final void handleFileChanged(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Project project = this.toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RoslynFrontendModel roslynFrontendModel = RoslynHost.Companion.getInstance(project).getModel();
        RdRoslynSyntaxTreeEntryFrontend rdRoslynSyntaxTreeEntryFrontend = (RdRoslynSyntaxTreeEntryFrontend)roslynFrontendModel.getRoslynSyntaxTree().getValueOrNull();
        if (rdRoslynSyntaxTreeEntryFrontend == null) {
            return;
        }
        RdRoslynSyntaxTreeEntryFrontend rdRoslynSyntaxTreeEntryFrontend2 = rdRoslynSyntaxTreeEntryFrontend;
        Boolean bl = (Boolean)rdRoslynSyntaxTreeEntryFrontend2.isActive().getValueOrNull();
        if (bl == null) {
            return;
        }
        boolean bl2 = bl;
        if (bl2 && this.G(file2)) {
            Project project2 = this.toolWindow.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            RoslynVisualizerPanel roslynVisualizerPanel = UtilsKt.getRoslynPanel(project2);
            if (roslynVisualizerPanel == null) {
                return;
            }
            RoslynVisualizerPanel roslynVisualizerPanel2 = roslynVisualizerPanel;
            Project project3 = this.toolWindow.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            RiderSolutionLifecycle riderSolutionLifecycle = RiderSolutionLifecycle_PregeneratedKt.getRiderSolutionLifecycle((Solution)SolutionHostExtensionsKt.getSolution((Project)project3));
            if (!Intrinsics.areEqual((Object)roslynFrontendModel.getRoslynReady().getValueOrNull(), (Object)true) && !Intrinsics.areEqual((Object)riderSolutionLifecycle.isProjectModelReady().getValueOrNull(), (Object)true)) {
                return;
            }
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            roslynVisualizerPanel2.updateRoslynSyntaxTree(string);
        }
    }

    private final boolean G(File file2) {
        Editor editor2 = FileEditorManager.getInstance((Project)this.toolWindow.getProject()).getSelectedTextEditor();
        if (editor2 == null || (editor2 = editor2.getVirtualFile()) == null) {
            return false;
        }
        Editor editor3 = editor2;
        return FileUtil.filesEqual((File)file2, (File)new File(editor3.getPath()));
    }
}

