/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.roslyn.visualizer.tree;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.jetbrains.rider.model.RdRoslynSyntaxNodeAdditionalDataFrontend;
import com.jetbrains.rider.roslyn.visualizer.tree.CSharpEntry;
import com.jetbrains.rider.roslyn.visualizer.tree.RoslynSyntaxTreeEntry;
import com.jetbrains.rider.roslyn.visualizer.tree.VisualBasicEntry;
import icons.ReSharperIcons;
import icons.RiderIcons;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/roslyn/visualizer/tree/TreeNodeRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "TreeNodeRenderer", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "G", "entry", "Lcom/jetbrains/rider/roslyn/visualizer/tree/RoslynSyntaxTreeEntry;", "b", "Ljavax/swing/Icon;", "nodeData", "r", "a", "I", "D", "G", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nTreeNodeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeNodeRenderer.kt\ncom/jetbrains/rider/roslyn/visualizer/tree/TreeNodeRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,299:1\n1#2:300\n15#3:301\n*S KotlinDebug\n*F\n+ 1 TreeNodeRenderer.kt\ncom/jetbrains/rider/roslyn/visualizer/tree/TreeNodeRenderer\n*L\n258#1:301\n*E\n"})
public final class TreeNodeRenderer
extends ColoredTreeCellRenderer {
    public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        if (value2 == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = value2 instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value2 : null;
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        RoslynSyntaxTreeEntry roslynSyntaxTreeEntry = object instanceof RoslynSyntaxTreeEntry ? (RoslynSyntaxTreeEntry)object : null;
        if (roslynSyntaxTreeEntry == null) {
            TreeNodeRenderer treeNodeRenderer = this;
            boolean bl = false;
            treeNodeRenderer.setIcon(null);
            return;
        }
        RoslynSyntaxTreeEntry roslynSyntaxTreeEntry2 = roslynSyntaxTreeEntry;
        this.G(roslynSyntaxTreeEntry2, selected);
        this.setOpaque(true);
        SpeedSearchUtil.applySpeedSearchHighlightingFiltered((JTree)tree2, (Object)value2, (SimpleColoredComponent)((SimpleColoredComponent)this), (boolean)false, (boolean)selected);
    }

    private final void G(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry, boolean bl) {
        String string = "";
        this.setIcon(this.G(roslynSyntaxTreeEntry));
        this.append(roslynSyntaxTreeEntry.getKind());
        if (roslynSyntaxTreeEntry.getSecondaryDataToDisplay() != null) {
            if (roslynSyntaxTreeEntry.isToken()) {
                string = roslynSyntaxTreeEntry.getSecondaryDataToDisplay();
            }
            this.setToolTipText(roslynSyntaxTreeEntry.getSecondaryDataToDisplay());
        }
        if (roslynSyntaxTreeEntry.getDataForIcon() != null) {
            string = roslynSyntaxTreeEntry.getDataForIcon().getIdentifier();
        }
        if (((CharSequence)string).length() > 0) {
            this.append(" \u00b7 ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.append(string, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private final Icon b(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry) {
        Icon icon = switch (roslynSyntaxTreeEntry.getKind()) {
            case "ClassDeclaration" -> ReSharperIcons.PsiSymbols.Class;
            case "MethodDeclaration" -> ReSharperIcons.PsiSymbols.Method;
            case "PropertyDeclaration" -> ReSharperIcons.PsiSymbols.Property;
            case "FieldDeclaration" -> ReSharperIcons.PsiSymbols.Field;
            case "EventDeclaration" -> ReSharperIcons.PsiSymbols.Event;
            case "EventFieldDeclaration" -> ReSharperIcons.PsiSymbols.Event;
            case "InterfaceDeclaration" -> ReSharperIcons.PsiSymbols.Interface;
            case "StructDeclaration" -> ReSharperIcons.PsiSymbols.Struct;
            case "EnumDeclaration" -> ReSharperIcons.PsiSymbols.Enum;
            case "ConstructorDeclaration" -> ReSharperIcons.PsiSymbols.Constructor;
            case "RecordDeclaration" -> ReSharperIcons.PsiSymbols.Class;
            case "NamespaceDeclaration" -> ReSharperIcons.PsiSymbols.Namespace;
            case "AnonymousObjectMemberDeclarator" -> ReSharperIcons.PsiSymbols.Class;
            case "VariableDeclaration" -> ReSharperIcons.PsiSymbols.Variable;
            case "OperatorDeclaration" -> ReSharperIcons.PsiSymbols.Operator;
            case "DelegateDeclaration" -> ReSharperIcons.PsiSymbols.Delegate;
            case "IndexerDeclaration" -> ReSharperIcons.PsiCSharp.CSharpIndexer;
            case "DestructorDeclaration" -> ReSharperIcons.PsiCSharp.CSharpDestructor;
            case "FileScopedNamespaceDeclaration" -> ReSharperIcons.PsiSymbols.Namespace;
            case "EnumMemberDeclaration" -> ReSharperIcons.PsiSymbols.EnumMember;
            default -> ReSharperIcons.ServicesNavigation.UsageLocalVariableDeclaration;
        };
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        int n = roslynSyntaxTreeEntry.getDataForIcon() != null ? roslynSyntaxTreeEntry.getDataForIcon().getNumberOfFlags() : 0;
        String string = new LayeredIcon(n + 1);
        string.setIcon(icon2, 0);
        int n2 = 1;
        RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend = roslynSyntaxTreeEntry.getDataForIcon();
        boolean bl = rdRoslynSyntaxNodeAdditionalDataFrontend != null ? rdRoslynSyntaxNodeAdditionalDataFrontend.isPublic() : false;
        if (bl && n2 <= n) {
            string.setIcon(ReSharperIcons.PsiSymbols.ModifiersPublic, n2++);
        }
        RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend2 = roslynSyntaxTreeEntry.getDataForIcon();
        boolean bl2 = rdRoslynSyntaxNodeAdditionalDataFrontend2 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend2.isPrivate() : false;
        if (bl2 && n2 <= n) {
            string.setIcon(ReSharperIcons.PsiSymbols.ModifiersPrivate, n2++);
        }
        RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend3 = roslynSyntaxTreeEntry.getDataForIcon();
        boolean bl3 = rdRoslynSyntaxNodeAdditionalDataFrontend3 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend3.isProtected() : false;
        if (bl3 && n2 <= n) {
            string.setIcon(ReSharperIcons.PsiSymbols.ModifiersProtected, n2++);
        }
        RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend4 = roslynSyntaxTreeEntry.getDataForIcon();
        boolean bl4 = rdRoslynSyntaxNodeAdditionalDataFrontend4 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend4.isInternal() : false;
        if (bl4 && n2 <= n) {
            string.setIcon(ReSharperIcons.PsiSymbols.ModifiersInternal, n2++);
        }
        RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend5 = roslynSyntaxTreeEntry.getDataForIcon();
        boolean bl5 = rdRoslynSyntaxNodeAdditionalDataFrontend5 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend5.isAbstract() : false;
        if (bl5 && n2 <= n) {
            string.setIcon(ReSharperIcons.PsiSymbols.ModifiersAbstract, n2++);
        }
        RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend6 = roslynSyntaxTreeEntry.getDataForIcon();
        boolean bl6 = rdRoslynSyntaxNodeAdditionalDataFrontend6 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend6.isVirtual() : false;
        if (bl6 && n2 <= n) {
            string.setIcon(ReSharperIcons.PsiSymbols.ModifiersVirtual, n2++);
        }
        RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend7 = roslynSyntaxTreeEntry.getDataForIcon();
        boolean bl7 = rdRoslynSyntaxNodeAdditionalDataFrontend7 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend7.isStatic() : false;
        if (bl7 && n2 <= n) {
            string.setIcon(ReSharperIcons.PsiSymbols.ModifiersStatic, n2++);
        }
        if (Intrinsics.areEqual((Object)roslynSyntaxTreeEntry.getKind(), (Object)"PropertyDeclaration")) {
            RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend8 = roslynSyntaxTreeEntry.getDataForIcon();
            boolean bl8 = rdRoslynSyntaxNodeAdditionalDataFrontend8 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend8.isGetter() : false;
            if (bl8 && roslynSyntaxTreeEntry.getDataForIcon().isSetter() && n2 + 1 <= n) {
                string.setIcon(ReSharperIcons.PsiSymbols.ModifiersReadWrite, n2++);
                ++n2;
            }
            RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend9 = roslynSyntaxTreeEntry.getDataForIcon();
            boolean bl9 = rdRoslynSyntaxNodeAdditionalDataFrontend9 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend9.isGetter() : false;
            if (bl9 && n2 <= n) {
                string.setIcon(ReSharperIcons.PsiSymbols.ModifiersRead, n2++);
            }
            RdRoslynSyntaxNodeAdditionalDataFrontend rdRoslynSyntaxNodeAdditionalDataFrontend10 = roslynSyntaxTreeEntry.getDataForIcon();
            boolean bl10 = rdRoslynSyntaxNodeAdditionalDataFrontend10 != null ? rdRoslynSyntaxNodeAdditionalDataFrontend10.isSetter() : false;
            if (bl10 && n2 <= n) {
                string.setIcon(ReSharperIcons.PsiSymbols.ModifiersWrite, n2);
            }
        }
        return (Icon)((Object)string);
    }

    private final Icon r(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry) {
        switch (roslynSyntaxTreeEntry.getKind()) {
            case "PublicKeyword": {
                Icon icon = ReSharperIcons.PsiSymbols.Public;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Public");
                return icon;
            }
            case "PrivateKeyword": {
                Icon icon = ReSharperIcons.PsiSymbols.Private;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Private");
                return icon;
            }
            case "ProtectedKeyword": {
                Icon icon = ReSharperIcons.PsiSymbols.Protected;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Protected");
                return icon;
            }
            case "InternalKeyword": {
                Icon icon = ReSharperIcons.PsiSymbols.Internal;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Internal");
                return icon;
            }
        }
        Icon icon = ReSharperIcons.PsiSymbols.Keyword;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Keyword");
        return icon;
    }

    private final Icon a(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry) {
        String string = roslynSyntaxTreeEntry.getKind();
        if (Intrinsics.areEqual((Object)string, (Object)"SimpleNameExpression")) {
            Icon icon = ReSharperIcons.StructuralSearch.Identifier;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Identifier");
            return icon;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"InvocationExpression")) {
            Icon icon = ReSharperIcons.FeaturesInspections.Invocation;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Invocation");
            return icon;
        }
        Icon icon = ReSharperIcons.StructuralSearch.Expression;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Expression");
        return icon;
    }

    private final Icon I(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry) {
        switch (roslynSyntaxTreeEntry.getKind()) {
            case "LocalFunctionStatement": {
                Icon icon = ReSharperIcons.PsiCSharp.LocalFunction;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LocalFunction");
                return icon;
            }
            case "ExpressionStatement": {
                Icon icon = ReSharperIcons.StructuralSearch.Statement;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Statement");
                return icon;
            }
            case "GlobalStatement": {
                Icon icon = ReSharperIcons.Services.ScopeGlobal;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ScopeGlobal");
                return icon;
            }
            case "AnonymousMethodExpression": {
                Icon icon = ReSharperIcons.PsiSymbols.AnonymousMethod;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AnonymousMethod");
                return icon;
            }
        }
        Icon icon = ReSharperIcons.StructuralSearch.Statement;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Statement");
        return icon;
    }

    private final Icon D(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry) {
        if (Intrinsics.areEqual((Object)roslynSyntaxTreeEntry.getKind(), (Object)"ParameterList")) {
            Icon icon = ReSharperIcons.PsiCSharp.AllParameters;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllParameters");
            return icon;
        }
        Icon icon = AllIcons.Actions.Annotate;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Annotate");
        return icon;
    }

    private final Icon G(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry) {
        if (StringsKt.endsWith$default((String)roslynSyntaxTreeEntry.getKind(), (String)"Declaration", (boolean)false, (int)2, null)) {
            return this.b(roslynSyntaxTreeEntry);
        }
        if (StringsKt.endsWith$default((String)roslynSyntaxTreeEntry.getKind(), (String)"Keyword", (boolean)false, (int)2, null)) {
            return this.r(roslynSyntaxTreeEntry);
        }
        if (StringsKt.endsWith$default((String)roslynSyntaxTreeEntry.getKind(), (String)"Expression", (boolean)false, (int)2, null)) {
            return this.a(roslynSyntaxTreeEntry);
        }
        if (StringsKt.endsWith$default((String)roslynSyntaxTreeEntry.getKind(), (String)"Statement", (boolean)false, (int)2, null)) {
            return this.I(roslynSyntaxTreeEntry);
        }
        if (StringsKt.endsWith$default((String)roslynSyntaxTreeEntry.getKind(), (String)"LiteralToken", (boolean)false, (int)2, null)) {
            Icon icon = ReSharperIcons.PsiSymbols.LocalConst;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LocalConst");
            return icon;
        }
        if (StringsKt.endsWith$default((String)roslynSyntaxTreeEntry.getKind(), (String)"List", (boolean)false, (int)2, null)) {
            return this.D(roslynSyntaxTreeEntry);
        }
        switch (roslynSyntaxTreeEntry.getKind()) {
            case "CompilationUnit": {
                if (roslynSyntaxTreeEntry instanceof CSharpEntry) {
                    Icon icon = ReSharperIcons.ProjectModel.CsharpProject;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CsharpProject");
                    return icon;
                }
                if (roslynSyntaxTreeEntry instanceof VisualBasicEntry) {
                    Icon icon = ReSharperIcons.ProjectModel.VbasicProject;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"VbasicProject");
                    return icon;
                }
                boolean bl = false;
                Logger logger2 = Logger.getInstance(TreeNodeRenderer.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                Logger logger3 = logger2;
                logger3.warn("Unexpected class in node: " + roslynSyntaxTreeEntry.getClass().getName());
                Icon icon = AllIcons.Modules.SourceRoot;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SourceRoot");
                return icon;
            }
            case "UsingDirective": {
                Icon icon = ReSharperIcons.FeaturesEnvironmentOptions.UsingDirectives;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"UsingDirectives");
                return icon;
            }
            case "Attribute": {
                Icon icon = ReSharperIcons.ExternalSources.Attrib;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Attrib");
                return icon;
            }
            case "Block": {
                Icon icon = ReSharperIcons.PsiSymbols.Namespace;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Namespace");
                return icon;
            }
            case "IdentifierToken": {
                Icon icon = ReSharperIcons.StructuralSearch.Identifier;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Identifier");
                return icon;
            }
            case "Parameter": {
                Icon icon = ReSharperIcons.PsiSymbols.Parameter;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Parameter");
                return icon;
            }
            case "PredefinedType": {
                Icon icon = ReSharperIcons.StructuralSearch.Type;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Type");
                return icon;
            }
            case "VariableDeclarator": {
                Icon icon = ReSharperIcons.PsiSymbols.Variable;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Variable");
                return icon;
            }
            case "Argument": {
                Icon icon = ReSharperIcons.StructuralSearch.Argument;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Argument");
                return icon;
            }
            case "IdentifierName": {
                Icon icon = ReSharperIcons.StructuralSearch.Identifier;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Identifier");
                return icon;
            }
            case "SimpleBaseType": {
                Icon icon = ReSharperIcons.PsiSymbols.BaseClass;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BaseClass");
                return icon;
            }
        }
        if (roslynSyntaxTreeEntry.isToken()) {
            Icon icon = RiderIcons.FileTypes.Xml;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Xml");
            return icon;
        }
        Icon icon = RiderIcons.FileTypes.Axml;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Axml");
        return icon;
    }
}

