/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.impl;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.jetbrains.rider.projectView.views.SolutionViewEntityOwner;
import com.jetbrains.rider.projectView.views.SolutionViewNode;
import com.jetbrains.rider.projectView.views.SolutionViewRootNodeBase;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 ,2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00020\u0003:\u0001,B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0007H\u0016J\r\u0010\u0013\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J\u001c\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\"\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u001a\u0010\u001f\u001a\u00020 2\u0010\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001bH\u0002J\u0014\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$J\u0006\u0010%\u001a\u00020 J\u001c\u0010&\u001a\u00020 2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0010j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/projectView/views/impl/SolutionViewTreeModel;", "Lcom/intellij/ui/tree/BaseTreeModel;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lcom/intellij/util/concurrency/InvokerSupplier;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/jetbrains/rider/projectView/views/SolutionViewRootNodeBase;", "SolutionViewTreeModel", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/projectView/views/SolutionViewRootNodeBase;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "invoker", "Lcom/intellij/util/concurrency/Invoker;", "Lorg/jetbrains/annotations/NotNull;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getRoot", "getInvoker", "getChildren", "", "parent", "", "sortChildren", "Lcom/intellij/util/SmartList;", "children", "", "G", "", "node", "G", "", "elements", "runOrInvokeLater", "action", "Lkotlin/Function0;", "invalidate", "refresh", "paths", "", "Ljavax/swing/tree/TreePath;", "structure", "", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSolutionViewTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionViewTreeModel.kt\ncom/jetbrains/rider/projectView/views/impl/SolutionViewTreeModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,143:1\n1863#2,2:144\n13#3:146\n15#4:147\n*S KotlinDebug\n*F\n+ 1 SolutionViewTreeModel.kt\ncom/jetbrains/rider/projectView/views/impl/SolutionViewTreeModel\n*L\n39#1:144,2\n19#1:146\n19#1:147\n*E\n"})
public final class SolutionViewTreeModel
extends BaseTreeModel<AbstractTreeNode<?>>
implements InvokerSupplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SolutionViewRootNodeBase root;
    @NotNull
    private final Invoker invoker;
    @NotNull
    private final Comparator<AbstractTreeNode<?>> comparator;
    @NotNull
    private static final Logger logger;

    public SolutionViewTreeModel(@NotNull Project project, @NotNull SolutionViewRootNodeBase root2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)root2), (String)"root");
        this.project = project;
        this.root = root2;
        Invoker invoker = Invoker.forBackgroundThreadWithReadAction((Disposable)((Disposable)this));
        Intrinsics.checkNotNullExpressionValue((Object)invoker, (String)"forBackgroundThreadWithReadAction(...)");
        this.invoker = invoker;
        this.comparator = this.root.createComparator();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public SolutionViewRootNodeBase getRoot() {
        return this.root;
    }

    @NotNull
    public Invoker getInvoker() {
        return this.invoker;
    }

    @NotNull
    public List<AbstractTreeNode<?>> getChildren(@Nullable Object parent) {
        boolean bl = this.invoker.isValidThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.project.isDisposed()) {
            return new ArrayList();
        }
        AbstractTreeNode abstractTreeNode = parent instanceof AbstractTreeNode ? (AbstractTreeNode)parent : null;
        if (abstractTreeNode == null) {
            return new ArrayList();
        }
        AbstractTreeNode abstractTreeNode2 = abstractTreeNode;
        Collection collection = abstractTreeNode2.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
        Collection collection2 = collection;
        if (collection2.isEmpty()) {
            return new ArrayList();
        }
        Iterable iterable = collection2;
        boolean bl2 = false;
        for (Object t : iterable) {
            AbstractTreeNode abstractTreeNode3 = (AbstractTreeNode)t;
            boolean bl3 = false;
            if (abstractTreeNode3 == null) continue;
            abstractTreeNode3.setParent(abstractTreeNode2);
            abstractTreeNode3.update();
        }
        return (List)this.sortChildren(collection2);
    }

    @NotNull
    public final SmartList<AbstractTreeNode<?>> sortChildren(@NotNull Collection<? extends AbstractTreeNode<?>> children) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        SmartList smartList = new SmartList(children);
        try {
            CollectionsKt.sortWith((List)((List)smartList), this.comparator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuilder stringBuilder = new StringBuilder("Unexpected sorting failed in '" + this + "'.");
            stringBuilder.append("\nChildren list BEFORE sorting: ");
            for (AbstractTreeNode<?> abstractTreeNode : children) {
                stringBuilder.append('\n').append(this.G(abstractTreeNode));
            }
            stringBuilder.append("\nChildren list AFTER sorting: ");
            Iterator iterator2 = smartList.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                AbstractTreeNode abstractTreeNode = (AbstractTreeNode)iterator3.next();
                StringBuilder stringBuilder2 = stringBuilder.append('\n');
                Intrinsics.checkNotNull((Object)abstractTreeNode);
                stringBuilder2.append(this.G(abstractTreeNode));
            }
            logger.error(stringBuilder.toString(), (Throwable)illegalArgumentException);
            try {
                this.G(children);
            }
            catch (Exception exception) {
                logger.error((Throwable)exception);
            }
        }
        return smartList;
    }

    private final String G(AbstractTreeNode<?> abstractTreeNode) {
        Object object;
        SolutionViewEntityOwner solutionViewEntityOwner = abstractTreeNode instanceof SolutionViewEntityOwner ? (SolutionViewEntityOwner)abstractTreeNode : null;
        ProjectModelEntity projectModelEntity = solutionViewEntityOwner != null ? solutionViewEntityOwner.getEntity() : null;
        return abstractTreeNode + " [Type=" + abstractTreeNode.getClass().getSimpleName() + " Descriptor=" + ((object = projectModelEntity) != null && (object = object.getDescriptor()) != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null) + "]";
    }

    private final void G(Collection<? extends AbstractTreeNode<?>> collection) {
        int n;
        for (AbstractTreeNode<?> abstractTreeNode : collection) {
            for (AbstractTreeNode<?> abstractTreeNode2 : collection) {
                int n2;
                n = this.comparator.compare(abstractTreeNode, abstractTreeNode2);
                if (n == -(n2 = this.comparator.compare(abstractTreeNode2, abstractTreeNode))) continue;
                logger.error("compare(" + abstractTreeNode + ", " + abstractTreeNode2 + ") == " + n + " but swapping the parameters returns " + n2);
            }
        }
        for (AbstractTreeNode<?> abstractTreeNode : collection) {
            for (AbstractTreeNode<?> abstractTreeNode2 : collection) {
                n = this.comparator.compare(abstractTreeNode, abstractTreeNode2);
                if (n <= 0) continue;
                for (AbstractTreeNode<?> abstractTreeNode3 : collection) {
                    int n3;
                    int n4 = this.comparator.compare(abstractTreeNode2, abstractTreeNode3);
                    if (n4 <= 0 || (n3 = this.comparator.compare(abstractTreeNode, abstractTreeNode3)) > 0) continue;
                    logger.error("compare(" + abstractTreeNode + ", " + abstractTreeNode2 + ") > 0, compare(" + abstractTreeNode2 + ", " + abstractTreeNode3 + ") > 0, but compare(" + abstractTreeNode + ", " + abstractTreeNode3 + ") == " + n3);
                }
            }
        }
    }

    public final void runOrInvokeLater(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.invoker.invoke(() -> SolutionViewTreeModel.G(action2));
    }

    public final void invalidate() {
        this.invoker.invoke(() -> SolutionViewTreeModel.G(this));
    }

    public final void refresh(@NotNull List<? extends TreePath> paths2, boolean structure) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        this.invoker.invoke(() -> SolutionViewTreeModel.G(paths2, structure, this));
    }

    private static final void G(Function0 function0) {
        function0.invoke();
    }

    private static final void G(SolutionViewTreeModel solutionViewTreeModel) {
        solutionViewTreeModel.treeStructureChanged(null, null, null);
    }

    private static final void G(List list2, boolean bl, SolutionViewTreeModel solutionViewTreeModel) {
        for (TreePath treePath : list2) {
            boolean bl2;
            AbstractTreeNode abstractTreeNode;
            Object object = treePath.getLastPathComponent();
            if ((object instanceof AbstractTreeNode ? (AbstractTreeNode)object : null) == null) continue;
            abstractTreeNode = abstractTreeNode;
            boolean bl3 = abstractTreeNode.update();
            boolean bl4 = bl2 = bl || !(abstractTreeNode instanceof SolutionViewNode);
            if (!bl3 && !bl2) continue;
            if (bl2) {
                solutionViewTreeModel.treeStructureChanged(treePath, null, null);
                continue;
            }
            solutionViewTreeModel.treeNodesChanged(treePath, null, null);
        }
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(SolutionViewTreeModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/projectView/views/impl/SolutionViewTreeModel$Companion;", "", "SolutionViewTreeModel$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

