/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.projectView.views.actions.ConfigureScratchesAction;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/projectView/views/impl/SolutionViewSelectInTargetBase;", "Lcom/intellij/ide/SelectInTarget;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "SolutionViewSelectInTargetBase", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "canSelect", "", "context", "Lcom/intellij/ide/SelectInContext;", "select", "", "toSelect", "", "requestFocus", "intellij.rider"})
public abstract class SolutionViewSelectInTargetBase
implements SelectInTarget,
DumbAware {
    @NotNull
    private final Project project;

    public SolutionViewSelectInTargetBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public boolean canSelect(@NotNull SelectInContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VirtualFile virtualFile = context.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        if (!virtualFile2.isValid()) {
            return false;
        }
        if (CollectionsKt.any((Iterable)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project), (VirtualFile)virtualFile2, (Project)this.project))) {
            return true;
        }
        if (BaseProjectDirectories.Companion.getInstance(this.project).contains(virtualFile2)) {
            return true;
        }
        return ConfigureScratchesAction.Companion.showScratchesInExplorer(this.project) && ScratchFileService.getInstance().getRootType(virtualFile2) != null;
    }

    protected final void select(@NotNull SelectInContext context, @Nullable Object toSelect, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectPaneSelectInTarget.select((Project)this.project, (Object)toSelect, (String)this.getMinorViewId(), null, (VirtualFile)context.getVirtualFile(), (boolean)requestFocus);
    }
}

