/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.fileSystemExplorer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.utils.ProjectViewUtils;
import com.jetbrains.rider.projectView.views.FileSystemNodeBase;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.fileSystemExplorer.FileSystemExplorerCustomization;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.ReSharperIcons;
import icons.RiderIcons;
import java.awt.Color;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ$\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerNode;", "Lcom/jetbrains/rider/projectView/views/FileSystemNodeBase;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "nestedFiles", "", "Lcom/jetbrains/rider/projectView/views/NestingNode;", "isRoot", "", "FileSystemExplorerNode", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Z)V", "createNode", "virtualFile", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "b", "G", "G", "G", "Ljavax/swing/Icon;", "getTestPresentation", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nFileSystemExplorerNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemExplorerNode.kt\ncom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerNode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n13402#2,2:108\n13402#2,2:110\n1755#3,3:112\n1755#3,3:115\n1755#3,3:118\n*S KotlinDebug\n*F\n+ 1 FileSystemExplorerNode.kt\ncom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerNode\n*L\n53#1:108,2\n66#1:110,2\n89#1:112,3\n90#1:115,3\n92#1:118,3\n*E\n"})
public final class FileSystemExplorerNode
extends FileSystemNodeBase {
    private final boolean isRoot;

    public FileSystemExplorerNode(@NotNull Project project, @NotNull VirtualFile file2, @NotNull List<NestingNode<VirtualFile>> nestedFiles, boolean isRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        super(project, file2, nestedFiles);
        this.isRoot = isRoot;
    }

    @Override
    @NotNull
    public FileSystemNodeBase createNode(@NotNull VirtualFile virtualFile, @NotNull List<NestingNode<VirtualFile>> nestedFiles) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return new FileSystemExplorerNode(project, virtualFile, nestedFiles, false);
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (!this.getFile().isValid()) {
            return;
        }
        if (ProjectViewUtils.INSTANCE.isRepositoryViewEnabled()) {
            this.G(presentation);
        } else {
            this.b(presentation);
        }
    }

    private final void b(PresentationData presentationData) {
        presentationData.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.isRoot) {
            SolutionViewUtilsKt.addAdditionalText(presentationData, String.valueOf(PathUtil.getLocalPath((VirtualFile)this.getFile())));
        }
        presentationData.setIcon(this.G());
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        SolutionViewUtilsKt.addAdditionalMark$default(presentationData, project, this.getVirtualFile(), false, 4, null);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        FileSystemExplorerCustomization[] fileSystemExplorerCustomizationArray = FileSystemExplorerCustomization.Companion.getExtensions(project2);
        boolean bl = false;
        int n = fileSystemExplorerCustomizationArray.length;
        for (int j = 0; j < n; ++j) {
            FileSystemExplorerCustomization fileSystemExplorerCustomization;
            FileSystemExplorerCustomization fileSystemExplorerCustomization2 = fileSystemExplorerCustomization = fileSystemExplorerCustomizationArray[j];
            boolean bl2 = false;
            fileSystemExplorerCustomization2.updateNode(presentationData, this.getFile(), this);
        }
    }

    private final void G(PresentationData presentationData) {
        if (this.isRoot) {
            presentationData.addText(String.valueOf(PathUtil.getLocalPath((VirtualFile)this.getFile())), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            return;
        }
        presentationData.addText(this.getName(), this.G() ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentationData.setIcon(this.G());
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        SolutionViewUtilsKt.addAdditionalMark(presentationData, project, this.getVirtualFile(), false);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        FileSystemExplorerCustomization[] fileSystemExplorerCustomizationArray = FileSystemExplorerCustomization.Companion.getExtensions(project2);
        boolean bl = false;
        int n = fileSystemExplorerCustomizationArray.length;
        for (int j = 0; j < n; ++j) {
            FileSystemExplorerCustomization fileSystemExplorerCustomization;
            FileSystemExplorerCustomization fileSystemExplorerCustomization2 = fileSystemExplorerCustomization = fileSystemExplorerCustomizationArray[j];
            boolean bl2 = false;
            fileSystemExplorerCustomization2.updateNode(presentationData, this.getFile(), this);
        }
        String string = FileUtilKt.getSystemIndependentPath((File)DocumentUtilKt.toIOFile((VirtualFile)this.getFile()));
        Project project3 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
        if (Intrinsics.areEqual((Object)string, (Object)FileUtilKt.getSystemIndependentPath((File)SolutionHostExtensionsKt.getSolutionFile((Project)project3)))) {
            presentationData.addText(" \u00b7 ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            presentationData.addText(RiderProjectViewBundle.Companion.message("FileSystemExplorerNode.active.solution.badge", new Object[0]), new SimpleTextAttributes(0, (Color)new JBColor(new Color(129, 80, 190), new Color(149, 90, 224))));
        }
    }

    private final boolean G() {
        return this.getFile().isDirectory() && StringsKt.startsWith$default((String)this.getName(), (String)".", (boolean)false, (int)2, null);
    }

    private final Icon G() {
        boolean bl;
        block40: {
            boolean bl2;
            ProjectModelEntity projectModelEntity;
            Object t;
            Iterator iterator2;
            boolean bl3;
            Object object;
            List list2;
            block41: {
                boolean bl4;
                block39: {
                    boolean bl5;
                    block38: {
                        Project project = this.myProject;
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
                        VirtualFile virtualFile = this.getFile();
                        Project project2 = this.myProject;
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
                        list2 = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)virtualFile, (Project)project2);
                        if (!this.getFile().isDirectory()) break block41;
                        String string = this.getName().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        switch (string) {
                            case ".github": {
                                Icon icon = RiderIcons.FileTypes.FolderGit;
                                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FolderGit");
                                return icon;
                            }
                            case "src": {
                                Icon icon = AllIcons.Modules.SourceRoot;
                                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SourceRoot");
                                return icon;
                            }
                            case "tests": 
                            case "test": {
                                Icon icon = AllIcons.Modules.TestRoot;
                                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TestRoot");
                                return icon;
                            }
                            case "assets": 
                            case "properties": 
                            case "samples": {
                                Icon icon = RiderIcons.Nodes.FolderResources;
                                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FolderResources");
                                return icon;
                            }
                            case "docs": {
                                Icon icon = RiderIcons.FileTypes.FolderDoc;
                                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FolderDoc");
                                return icon;
                            }
                        }
                        object = list2;
                        bl3 = false;
                        if (object instanceof Collection && ((Collection)object).isEmpty()) {
                            bl5 = false;
                        } else {
                            iterator2 = object.iterator();
                            while (iterator2.hasNext()) {
                                t = iterator2.next();
                                projectModelEntity = (ProjectModelEntity)t;
                                bl2 = false;
                                if (!ProjectModelEntityExtensionsKt.isExistingSolution((ProjectModelEntity)projectModelEntity)) continue;
                                bl5 = true;
                                break block38;
                            }
                            bl5 = false;
                        }
                    }
                    if (bl5) {
                        Icon icon = RiderIcons.Nodes.FolderSolution;
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FolderSolution");
                        return icon;
                    }
                    object = list2;
                    bl3 = false;
                    if (object instanceof Collection && ((Collection)object).isEmpty()) {
                        bl4 = false;
                    } else {
                        iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            t = iterator2.next();
                            projectModelEntity = (ProjectModelEntity)t;
                            bl2 = false;
                            if (!ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)projectModelEntity)) continue;
                            bl4 = true;
                            break block39;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) {
                    Icon icon = ReSharperIcons.ProjectModel.Projects;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Projects");
                    return icon;
                }
            }
            object = list2;
            bl3 = false;
            if (object instanceof Collection && ((Collection)object).isEmpty()) {
                bl = false;
            } else {
                iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    t = iterator2.next();
                    projectModelEntity = (ProjectModelEntity)t;
                    bl2 = false;
                    if (!ProjectModelEntityExtensionsKt.isUnloadedProject((ProjectModelEntity)projectModelEntity)) continue;
                    bl = true;
                    break block40;
                }
                bl = false;
            }
        }
        if (bl) {
            Icon icon = ReSharperIcons.ProjectModel.UnloadedProject;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"UnloadedProject");
            return icon;
        }
        if (this.isRoot) {
            Icon icon = AllIcons.Actions.MenuOpen;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MenuOpen");
            return icon;
        }
        VirtualFile virtualFile = this.getFile();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return ProjectModelIconsKt.calculateFileSystemIcon((VirtualFile)virtualFile, (Project)project);
    }

    @Override
    @TestOnly
    @NotNull
    public String getTestPresentation() {
        PresentationData presentationData = new PresentationData();
        this.update(presentationData);
        if (this.isRoot) {
            return this.getName();
        }
        String string = ((PresentableNodeDescriptor.ColoredFragment)presentationData.getColoredText().get(0)).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

