/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.assemblyExplorer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rider.model.AssemblyExplorerModel;
import com.jetbrains.rider.model.RdAddLibrarySession;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import icons.ReSharperIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "protocolModel", "Lcom/jetbrains/rider/model/AssemblyExplorerModel;", "AddGacLibraryDialog", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/model/AssemblyExplorerModel;)V", "def", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "session", "Lcom/jetbrains/rider/model/RdAddLibrarySession;", "model", "Lcom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog$Model;", "list", "Lcom/intellij/ui/components/JBList;", "Lcom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog$LibraryModel;", "view", "Ljavax/swing/JComponent;", "doOKAction", "", "createCenterPanel", "getPreferredFocusedComponent", "dispose", "Companion", "Model", "LibraryModel", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nAddGacLibraryDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddGacLibraryDialog.kt\ncom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1557#2:118\n1628#2,3:119\n*S KotlinDebug\n*F\n+ 1 AddGacLibraryDialog.kt\ncom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog\n*L\n102#1:118\n102#1:119,3\n*E\n"})
public final class AddGacLibraryDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LifetimeDefinition def;
    @NotNull
    private final RdAddLibrarySession session;
    @NotNull
    private final Model model;
    @NotNull
    private final JBList<LibraryModel> list;
    @NotNull
    private final JComponent view;
    private static int nextId;

    public AddGacLibraryDialog(@NotNull Project project, @NotNull AssemblyExplorerModel protocolModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)protocolModel, (String)"protocolModel");
        super(project, false);
        this.project = project;
        this.def = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)this.project));
        this.session = new RdAddLibrarySession();
        this.model = new Model();
        this.setTitle(RiderProjectViewBundle.Companion.message("AddGacLibraryDialog.dialog.title.add.library", new Object[0]));
        int n = nextId;
        nextId = n + 1;
        int n2 = n;
        IMutableViewableMap iMutableViewableMap = protocolModel.getAddLibrarySessions();
        Integer n3 = n2;
        ((Map)iMutableViewableMap).put(n3, this.session);
        this.def.getLifetime().onTermination(() -> AddGacLibraryDialog.G(iMutableViewableMap, n2));
        this.session.getLibraryPaths().advise(this.def.getLifetime(), arg_0 -> AddGacLibraryDialog.G(this, arg_0));
        Object object = new JBList((ListModel)this.model);
        n3 = object;
        AddGacLibraryDialog addGacLibraryDialog = this;
        boolean bl = false;
        n3.setCellRenderer(AddGacLibraryDialog::G);
        addGacLibraryDialog.list = object;
        object = ScrollPaneFactory.createScrollPane((Component)((Component)this.list), (boolean)true);
        n3 = object;
        addGacLibraryDialog = this;
        bl = false;
        ((JComponent)((Object)n3)).setMinimumSize(new Dimension(JBUI.scale((int)400), JBUI.scale((int)400)));
        ((JComponent)((Object)n3)).setPreferredSize(new Dimension(JBUI.scale((int)400), JBUI.scale((int)400)));
        addGacLibraryDialog.view = (JComponent)object;
        new ListSpeedSearch((JList)this.list, arg_0 -> AddGacLibraryDialog.G(AddGacLibraryDialog::G, arg_0));
        this.init();
    }

    protected void doOKAction() {
        List list2 = this.list.getSelectedValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSelectedValuesList(...)");
        Object[] objectArray = (Object[])list2;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)objectArray, (int)10));
        boolean bl2 = false;
        for (Object t : objectArray2) {
            LibraryModel libraryModel = (LibraryModel)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(libraryModel.getFile().getPath());
        }
        List list3 = CollectionsKt.toList((Iterable)((List)collection));
        objectArray = new Object[]{list3.size()};
        ExtensionsKt.runCommandUnderProgress$default((IRdCall)((IRdCall)this.session.getAdd()), (Object)list3, (Project)this.project, (String)RiderProjectViewBundle.Companion.message("AddGacLibraryDialog.command.name", objectArray), (boolean)false, (boolean)false, (boolean)false, (int)56, null);
        this.close(0);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.view;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBList<LibraryModel> jBList = this.list;
        Intrinsics.checkNotNull(jBList, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        return (JComponent)jBList;
    }

    protected void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.def, (boolean)false, (int)1, null);
        super.dispose();
    }

    private static final Unit G(IMutableViewableMap iMutableViewableMap, int n) {
        iMutableViewableMap.remove((Object)n);
        return Unit.INSTANCE;
    }

    private static final Unit G(AddGacLibraryDialog addGacLibraryDialog, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"paths");
        addGacLibraryDialog.model.updateModel(list2);
        return Unit.INSTANCE;
    }

    private static final Component G(JList jList, LibraryModel libraryModel, int n, boolean bl, boolean bl2) {
        SimpleColoredComponent simpleColoredComponent;
        String string = FilesKt.getNameWithoutExtension((File)libraryModel.getFile());
        SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent = new SimpleColoredComponent();
        boolean bl3 = false;
        simpleColoredComponent2.setIcon(ReSharperIcons.ProjectModel.Assembly);
        simpleColoredComponent2.setForeground(UIUtil.getListForeground((boolean)bl, (boolean)true));
        simpleColoredComponent2.setBackground(UIUtil.getListBackground((boolean)bl, (boolean)true));
        simpleColoredComponent2.setToolTipText(libraryModel.getFile().getPath());
        SimpleColoredComponent simpleColoredComponent3 = simpleColoredComponent;
        simpleColoredComponent3.append(string, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (libraryModel.getSpecification() != null && ((CharSequence)libraryModel.getSpecification()).length() > 0) {
            simpleColoredComponent3.append(" " + libraryModel.getSpecification(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        return (Component)simpleColoredComponent3;
    }

    private static final String G(LibraryModel libraryModel) {
        return FilesKt.getNameWithoutExtension((File)libraryModel.getFile());
    }

    private static final String G(Function1 function1, Object object) {
        return (String)function1.invoke(object);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog$Companion;", "", "AddGacLibraryDialog$Companion", "()V", "nextId", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog$LibraryModel;", "", "file", "Ljava/io/File;", "specification", "", "AddGacLibraryDialog$LibraryModel", "(Ljava/io/File;Ljava/lang/String;)V", "getFile", "()Ljava/io/File;", "getSpecification", "()Ljava/lang/String;", "intellij.rider"})
    private static final class LibraryModel {
        @NotNull
        private final File file;
        @Nullable
        private final String specification;

        public LibraryModel(@NotNull File file2, @NlsSafe @Nullable String specification) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.file = file2;
            this.specification = specification;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @Nullable
        public final String getSpecification() {
            return this.specification;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog$Model;", "Ljavax/swing/AbstractListModel;", "Lcom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog$LibraryModel;", "AddGacLibraryDialog$Model", "()V", "files", "", "updateModel", "", "paths", "", "getElementAt", "index", "", "getSize", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nAddGacLibraryDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddGacLibraryDialog.kt\ncom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog$Model\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,117:1\n1557#2:118\n1628#2,3:119\n1485#2:122\n1510#2,3:123\n1513#2,3:133\n1053#2:136\n381#3,7:126\n*S KotlinDebug\n*F\n+ 1 AddGacLibraryDialog.kt\ncom/jetbrains/rider/projectView/views/assemblyExplorer/AddGacLibraryDialog$Model\n*L\n86#1:118\n86#1:119,3\n86#1:122\n86#1:123,3\n86#1:133,3\n93#1:136\n86#1:126,7\n*E\n"})
    private static final class Model
    extends AbstractListModel<LibraryModel> {
        @NotNull
        private List<LibraryModel> files = CollectionsKt.emptyList();

        public final void updateModel(@NotNull List<String> paths2) {
            boolean bl;
            Object object;
            Object t;
            Intrinsics.checkNotNullParameter(paths2, (String)"paths");
            List list2 = new ArrayList();
            Object object2 = paths2;
            boolean bl2 = false;
            Object object3 = object2;
            Object object42 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            boolean bl3 = false;
            Iterator iterator2 = object3.iterator();
            while (iterator2.hasNext()) {
                t = iterator2.next();
                object = (String)t;
                Collection collection = object42;
                bl = false;
                collection.add(new File((String)object));
            }
            object2 = (List)object42;
            boolean entry2 = false;
            object3 = object2;
            object42 = new LinkedHashMap();
            bl3 = false;
            iterator2 = object3.iterator();
            while (iterator2.hasNext()) {
                Object object5;
                t = iterator2.next();
                object = (File)t;
                bl = false;
                String string = FilesKt.getNameWithoutExtension((File)object);
                Object object6 = object42;
                boolean bl4 = false;
                Object v = object6.get(string);
                if (v == null) {
                    boolean bl5 = false;
                    List list3 = new ArrayList();
                    object6.put(string, list3);
                    object5 = list3;
                } else {
                    object5 = v;
                }
                object = (List)object5;
                object.add(t);
            }
            Object object7 = object42;
            for (Map.Entry entry3 : object7.entrySet()) {
                for (Object object42 : (List)entry3.getValue()) {
                    list2.add(new LibraryModel((File)object42, ((File)object42).getPath()));
                }
            }
            object2 = list2;
            boolean bl6 = false;
            this.files = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)object2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LibraryModel libraryModel = (LibraryModel)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)FilesKt.getNameWithoutExtension((File)libraryModel.getFile()));
                    libraryModel = (LibraryModel)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)FilesKt.getNameWithoutExtension((File)libraryModel.getFile()))));
                }
            }));
            this.fireContentsChanged(this, 0, this.files.size());
        }

        @Override
        @NotNull
        public LibraryModel getElementAt(int index) {
            return this.files.get(index);
        }

        @Override
        public int getSize() {
            return this.files.size();
        }
    }
}

