/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.TreeVisitor;
import com.jetbrains.rider.projectView.views.SolutionViewNode;
import com.jetbrains.rider.projectView.views.SolutionViewVisitor;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0005H\u0014J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/projectView/views/SolutionViewVisitorByVirtualFile;", "Lcom/jetbrains/rider/projectView/views/SolutionViewVisitor;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findAllPaths", "", "SolutionViewVisitorByVirtualFile", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "canMatchSeveralPathsInTree", "visit", "Lcom/intellij/ui/tree/TreeVisitor$Action;", "node", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "intellij.rider"})
final class SolutionViewVisitorByVirtualFile
extends SolutionViewVisitor {
    @NotNull
    private final VirtualFile virtualFile;

    public SolutionViewVisitorByVirtualFile(@NotNull VirtualFile virtualFile, boolean findAllPaths) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        super(findAllPaths);
        this.virtualFile = virtualFile;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    protected boolean canMatchSeveralPathsInTree() {
        return true;
    }

    @Override
    @NotNull
    protected TreeVisitor.Action visit(@NotNull AbstractTreeNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (node instanceof SolutionViewNode) {
            if (((SolutionViewNode)node).getAllVirtualFiles().contains(this.virtualFile)) {
                SolutionViewVisitor.Companion.getLog().trace("-> file '" + this.virtualFile + "' found: INTERRUPT");
                return TreeVisitor.Action.INTERRUPT;
            }
            if (((SolutionViewNode)node).contains(this.virtualFile)) {
                SolutionViewVisitor.Companion.getLog().trace("-> node '" + node + "' contains file '" + this.virtualFile + "' found: CONTINUE");
                return TreeVisitor.Action.CONTINUE;
            }
        }
        if (node instanceof ProjectViewNode) {
            if (Intrinsics.areEqual((Object)((ProjectViewNode)node).getName(), (Object)ScratchesNamedScope.scratchesAndConsoles())) {
                File file2 = VfsUtil.virtualToIoFile((VirtualFile)this.virtualFile);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(...)");
                File file3 = file2;
                Object[] objectArray = new File[]{file3, file3.getParentFile()};
                if (ArraysKt.contains((Object[])objectArray, (Object)new File(PathManager.getScratchPath()))) {
                    SolutionViewVisitor.Companion.getLog().trace("-> (P) scratch root node: INTERRUPT");
                    return TreeVisitor.Action.INTERRUPT;
                }
            }
            if (Intrinsics.areEqual((Object)((ProjectViewNode)node).getVirtualFile(), (Object)this.virtualFile)) {
                SolutionViewVisitor.Companion.getLog().trace("-> (P) file '" + this.virtualFile + "' found: INTERRUPT");
                return TreeVisitor.Action.INTERRUPT;
            }
            if (((ProjectViewNode)node).contains(this.virtualFile)) {
                SolutionViewVisitor.Companion.getLog().trace("(-> P) node '" + node + "' contains file '" + this.virtualFile + "' found: CONTINUE");
                return TreeVisitor.Action.CONTINUE;
            }
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }
}

