/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.utils;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.document.RiderDocumentBindingService;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.projectView.RiderOpenFileDescriptor;
import com.jetbrains.rider.projectView.views.SolutionViewPsiNodeNavigator;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"getVirtualFileForNavigateToSource", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "requestFocus", "", "G", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nNavigationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationUtil.kt\ncom/jetbrains/rider/projectView/utils/NavigationUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n295#2,2:68\n*S KotlinDebug\n*F\n+ 1 NavigationUtil.kt\ncom/jetbrains/rider/projectView/utils/NavigationUtilKt\n*L\n56#1:68,2\n*E\n"})
public final class NavigationUtilKt {
    @Nullable
    public static final VirtualFile getVirtualFileForNavigateToSource(@NotNull ProjectModelEntity $this$getVirtualFileForNavigateToSource) {
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualFileForNavigateToSource, (String)"<this>");
        if (ProjectModelEntityExtensionsKt.isReference((ProjectModelEntity)$this$getVirtualFileForNavigateToSource)) {
            return null;
        }
        VirtualFileUrl virtualFileUrl = $this$getVirtualFileForNavigateToSource.getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return null;
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        return virtualFileUrl2.isDirectory() ? null : virtualFileUrl2;
    }

    public static final void navigate(@NotNull VirtualFile $this$navigate, @NotNull Project project, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$navigate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (NavigationUtilKt.G($this$navigate, project, requestFocus)) {
            return;
        }
        FileType fileType = FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)$this$navigate, (Project)project);
        if (fileType == null) {
            return;
        }
        FileType fileType2 = fileType;
        if (fileType2 instanceof INativeFileType) {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, $this$navigate, -1);
            openFileDescriptor.navigate(requestFocus);
            return;
        }
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).openFile($this$navigate, requestFocus);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        FileEditor fileEditor = (FileEditor)ArraysKt.singleOrNull((Object[])fileEditorArray);
        if (fileEditor == null) {
            return;
        }
        FileEditor fileEditor2 = fileEditor;
        Integer n = RiderOpenFileDescriptor.Companion.getProjectModelId();
        if (fileEditor2 instanceof TextEditor && n != null) {
            Editor editor2 = ((TextEditor)fileEditor2).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            Editor editor3 = editor2;
            Document document = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            RdDocumentId rdDocumentId = DocumentExKt.getDocumentId((Document)document, (Project)project);
            VirtualFile virtualFile = editor3.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            int n2 = com.jetbrains.rider.document.DocumentExKt.chooseBestProjectModelIdForDocument((Project)project, (VirtualFile)virtualFile, (int)n);
            if (rdDocumentId instanceof RdFrontendDocumentId) {
                RiderDocumentBindingService.Companion.getInstance(project).updateProjectModelId((RdFrontendDocumentId)rdDocumentId, Integer.valueOf(n2));
            }
        }
    }

    private static final boolean G(VirtualFile virtualFile, Project project, boolean bl) {
        Object v1;
        PsiFile psiFile;
        block4: {
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile2 == null) {
                return false;
            }
            psiFile = psiFile2;
            List list2 = SolutionViewPsiNodeNavigator.Companion.getEP().getExtensionList((AreaInstance)project);
            Iterable iterable = list2;
            boolean bl2 = false;
            for (Object t : iterable) {
                SolutionViewPsiNodeNavigator solutionViewPsiNodeNavigator = (SolutionViewPsiNodeNavigator)t;
                boolean bl3 = false;
                if (!solutionViewPsiNodeNavigator.canNavigate(psiFile)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        SolutionViewPsiNodeNavigator solutionViewPsiNodeNavigator = v1;
        if (solutionViewPsiNodeNavigator == null) {
            return false;
        }
        SolutionViewPsiNodeNavigator solutionViewPsiNodeNavigator2 = solutionViewPsiNodeNavigator;
        if (!solutionViewPsiNodeNavigator2.shouldNavigateIfFileIsOpened(psiFile) && (EditorHistoryManager.Companion.getInstance(project).hasBeenOpen(virtualFile) || FileEditorManager.getInstance((Project)project).isFileOpen(virtualFile))) {
            return false;
        }
        solutionViewPsiNodeNavigator2.navigate(bl, psiFile);
        return true;
    }
}

