/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.scopes;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsIterator;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bJ\u001a\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "ScopeFilesCollector", "(Lcom/intellij/openapi/project/Project;)V", "map", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector$State;", "value", "", "totalFiles", "getTotalFiles", "()I", "totalMarkedFiles", "getTotalMarkedFiles", "run", "", "marker", "Lcom/intellij/packageDependencies/ui/Marker;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "total", "G", "parent", "state", "isMarked", "", "virtualFile", "hasMarked", "hasUnmarked", "State", "intellij.rider"})
public final class ScopeFilesCollector {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, State> map;
    private int totalFiles;
    private int totalMarkedFiles;

    public ScopeFilesCollector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.map = new LinkedHashMap();
    }

    public final int getTotalFiles() {
        return this.totalFiles;
    }

    public final int getTotalMarkedFiles() {
        return this.totalMarkedFiles;
    }

    public final void run(@Nullable Marker marker, @NotNull ProgressIndicator indicator, int total) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ApplicationKt.getApplication().assertIsNonDispatchThread();
        if (marker == null) {
            return;
        }
        Ref.IntRef intRef = new Ref.IntRef();
        for (VirtualFile virtualFile : BaseProjectDirectories.Companion.getBaseDirectories(this.project)) {
            VfsIterator vfsIterator = VfsIterator.Companion.create(this.project);
            if (vfsIterator == null) continue;
            vfsIterator.visitFileOrDirectoryRecursively(virtualFile, arg_0 -> ScopeFilesCollector.G(marker, this, intRef, total, indicator, arg_0));
        }
    }

    private final void G(VirtualFile virtualFile, State state) {
        if (virtualFile == null) {
            return;
        }
        State state2 = this.map.get(virtualFile);
        if (state2 == null) {
            return;
        }
        State state3 = state2;
        if (state3.update(state)) {
            this.G(virtualFile.getParent(), state);
        }
    }

    public final boolean isMarked(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        State state = this.map.get(virtualFile);
        return state != null ? state.isMarked() : false;
    }

    public final boolean hasMarked(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        State state = this.map.get(virtualFile);
        return state != null ? state.getHasMarked() : false;
    }

    public final boolean hasUnmarked(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        State state = this.map.get(virtualFile);
        return state != null ? state.getHasUnmarked() : false;
    }

    private static final boolean G(Marker marker, ScopeFilesCollector scopeFilesCollector, Ref.IntRef intRef, int n, ProgressIndicator progressIndicator, VirtualFile virtualFile) {
        State state;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"fileOrDir");
        boolean bl = marker.isMarked(virtualFile);
        State state2 = state = new State(bl);
        boolean bl2 = false;
        state2.setHasMarked(bl);
        state2.setHasUnmarked(!bl);
        State state3 = state;
        scopeFilesCollector.map.put(virtualFile, state3);
        scopeFilesCollector.G(virtualFile.getParent(), state3);
        if (VirtualFileUtil.isFile((VirtualFile)virtualFile)) {
            int n2 = scopeFilesCollector.totalFiles;
            scopeFilesCollector.totalFiles = n2 + 1;
            if (bl) {
                n2 = scopeFilesCollector.totalMarkedFiles;
                scopeFilesCollector.totalMarkedFiles = n2 + 1;
            }
        }
        int n3 = intRef.element;
        intRef.element = n3 + 1;
        double d = Math.min((double)intRef.element / (double)n, 1.0);
        if (progressIndicator instanceof PanelProgressIndicator) {
            ((PanelProgressIndicator)progressIndicator).update(RiderProjectViewBundle.Companion.message("scope.model.builder.progress", new Object[0]), false, d);
        } else {
            progressIndicator.setFraction(d);
        }
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector$State;", "", "isMarked", "", "ScopeFilesCollector$State", "(Z)V", "()Z", "hasMarked", "getHasMarked", "setHasMarked", "hasUnmarked", "getHasUnmarked", "setHasUnmarked", "update", "state", "intellij.rider"})
    private static final class State {
        private final boolean isMarked;
        private boolean hasMarked;
        private boolean hasUnmarked;

        public State(boolean isMarked) {
            this.isMarked = isMarked;
        }

        public final boolean isMarked() {
            return this.isMarked;
        }

        public final boolean getHasMarked() {
            return this.hasMarked;
        }

        public final void setHasMarked(boolean bl) {
            this.hasMarked = bl;
        }

        public final boolean getHasUnmarked() {
            return this.hasUnmarked;
        }

        public final void setHasUnmarked(boolean bl) {
            this.hasUnmarked = bl;
        }

        public final boolean update(@NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            boolean bl = false;
            if (!this.hasMarked && state.hasMarked) {
                this.hasMarked = true;
                bl = true;
            }
            if (!this.hasUnmarked && state.hasUnmarked) {
                this.hasUnmarked = true;
                bl = true;
            }
            return bl;
        }
    }
}

