/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.scopes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.scopes.ScopeFilesCollector;
import com.jetbrains.rider.projectView.scopes.ScopePatternUtilKt;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u001bH\u0016J\u0012\u0010'\u001a\f0\u0017\u00a2\u0006\u0002\b(\u00a2\u0006\u0002\b)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0012\u0010,\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0013\u0010/\u001a\u00020\u001b2\b\u00100\u001a\u0004\u0018\u000101H\u0096\u0002J\b\u00102\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lcom/jetbrains/rider/projectView/scopes/FileSystemNode;", "Lcom/intellij/packageDependencies/ui/PackageDependenciesNode;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "collector", "Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector;", "settings", "Lcom/intellij/packageDependencies/ui/DependenciesPanel$DependencyPanelSettings;", "FileSystemNode", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector;Lcom/intellij/packageDependencies/ui/DependenciesPanel$DependencyPanelSettings;)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getCollector", "()Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector;", "getSettings", "()Lcom/intellij/packageDependencies/ui/DependenciesPanel$DependencyPanelSettings;", "childrenFiles", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "relativePath", "", "getRelativePath", "()Ljava/lang/String;", "hasMarked", "", "hasUnmarked", "getChildAt", "index", "", "getChildCount", "sortChildren", "", "getIcon", "Ljavax/swing/Icon;", "getContainingFiles", "isValid", "toString", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getPsiElement", "Lcom/intellij/psi/PsiElement;", "getIndex", "aChild", "Ljavax/swing/tree/TreeNode;", "equals", "other", "", "hashCode", "intellij.rider"})
public final class FileSystemNode
extends PackageDependenciesNode {
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final ScopeFilesCollector collector;
    @NotNull
    private final DependenciesPanel.DependencyPanelSettings settings;
    @NotNull
    private final List<VirtualFile> childrenFiles;

    public FileSystemNode(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull ScopeFilesCollector collector, @NotNull DependenciesPanel.DependencyPanelSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(project);
        this.virtualFile = virtualFile;
        this.collector = collector;
        this.settings = settings;
        VirtualFile[] virtualFileArray = this.virtualFile.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        this.childrenFiles = ScopePatternUtilKt.sortAndFilterScopeChildren(virtualFileArray, this.collector, this.settings);
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public final ScopeFilesCollector getCollector() {
        return this.collector;
    }

    @NotNull
    public final DependenciesPanel.DependencyPanelSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return project;
    }

    @Nullable
    public final String getRelativePath() {
        return ScopePatternUtilKt.constructRelativePath(this.getProject(), this.virtualFile);
    }

    public boolean hasMarked() {
        return this.collector.hasMarked(this.virtualFile);
    }

    public boolean hasUnmarked() {
        return this.collector.hasUnmarked(this.virtualFile);
    }

    @NotNull
    public FileSystemNode getChildAt(int index) {
        FileSystemNode fileSystemNode;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        FileSystemNode fileSystemNode2 = fileSystemNode = new FileSystemNode(project, this.childrenFiles.get(index), this.collector, this.settings);
        boolean bl = false;
        fileSystemNode2.parent = (MutableTreeNode)((Object)fileSystemNode2);
        return fileSystemNode;
    }

    public int getChildCount() {
        return this.childrenFiles.size();
    }

    public void sortChildren() {
    }

    @NotNull
    public Icon getIcon() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return ProjectModelIconsKt.calculateFileSystemIcon((VirtualFile)this.virtualFile, (Project)project);
    }

    public int getContainingFiles() {
        return 0;
    }

    public boolean isValid() {
        return this.virtualFile.isValid();
    }

    @NotNull
    public String toString() {
        String string = this.virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Nullable
    public PsiElement getPsiElement() {
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.virtualFile);
        return psiFile != null ? (PsiElement)psiFile : (PsiElement)PsiManager.getInstance((Project)this.myProject).findDirectory(this.virtualFile);
    }

    public int getIndex(@Nullable TreeNode aChild) {
        FileSystemNode fileSystemNode = aChild instanceof FileSystemNode ? (FileSystemNode)((Object)aChild) : null;
        if (fileSystemNode == null || (fileSystemNode = fileSystemNode.virtualFile) == null) {
            return -1;
        }
        FileSystemNode fileSystemNode2 = fileSystemNode;
        return this.childrenFiles.indexOf((Object)fileSystemNode2);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof FileSystemNode)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.virtualFile, (Object)((FileSystemNode)((Object)other)).virtualFile);
    }

    public int hashCode() {
        return this.virtualFile.hashCode();
    }
}

