/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.projectTemplates.templateTypes;

import com.intellij.openapi.observable.properties.GraphProperty;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.RdProjectTemplate;
import com.jetbrains.rider.projectView.projectTemplates.NewProjectDialogContext;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesCollector;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesSharedModel;
import com.jetbrains.rider.projectView.projectTemplates.components.ProjectTemplateLanguage;
import com.jetbrains.rider.projectView.projectTemplates.components.ProjectTemplateSdk;
import com.jetbrains.rider.projectView.projectTemplates.generators.TypeBasedProjectTemplateGenerator;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.DesktopProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.LibraryProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.MauiProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.PredefinedProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.WebAppProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.utils.ExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/LibraryProjectTemplateType;", "Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/PredefinedProjectTemplateType;", "LibraryProjectTemplateType", "()V", "acceptableForTemplate", "", "projectTemplate", "Lcom/jetbrains/rider/model/RdProjectTemplate;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "order", "", "getOrder", "()I", "createGenerator", "Lcom/jetbrains/rider/projectView/projectTemplates/generators/TypeBasedProjectTemplateGenerator;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "context", "Lcom/jetbrains/rider/projectView/projectTemplates/NewProjectDialogContext;", "sharedModel", "Lcom/jetbrains/rider/projectView/projectTemplates/ProjectTemplatesSharedModel;", "intellij.rider"})
public final class LibraryProjectTemplateType
extends PredefinedProjectTemplateType {
    @NotNull
    private final Icon icon;
    @NotNull
    private final String name;
    private final int order;

    public LibraryProjectTemplateType() {
        Icon icon = RiderIcons.Templates.TemplateClassLibrary;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TemplateClassLibrary");
        this.icon = icon;
        this.name = RiderProjectViewBundle.Companion.message("NewProjectDialog.ClassLibraryProjectTemplateType.name", new Object[0]);
        this.order = 20;
    }

    @Override
    public boolean acceptableForTemplate(@NotNull RdProjectTemplate projectTemplate) {
        Intrinsics.checkNotNullParameter((Object)projectTemplate, (String)"projectTemplate");
        return this.checkId(projectTemplate) && ExtensionsKt.hasClassification(projectTemplate, "library") && !DesktopProjectTemplateType.Companion.acceptableForTemplateInternal$intellij_rider(projectTemplate) && !MauiProjectTemplateType.Companion.acceptableForTemplateInternal$intellij_rider(projectTemplate) && !WebAppProjectTemplateType.Companion.acceptableForTemplateInternal$intellij_rider(projectTemplate) && !Intrinsics.areEqual((Object)ExtensionsKt.getLanguage(projectTemplate), (Object)ProjectTemplateLanguage.Companion.getCPlusPlus());
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    @NotNull
    public TypeBasedProjectTemplateGenerator createGenerator(@NotNull Lifetime lifetime, @NotNull NewProjectDialogContext context, @NotNull ProjectTemplatesSharedModel sharedModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sharedModel, (String)"sharedModel");
        IOptProperty<Set<RdProjectTemplate>> iOptProperty = this.getProjectTemplates();
        return new TypeBasedProjectTemplateGenerator(lifetime, context, sharedModel, iOptProperty){
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            private final String defaultName;
            private final ProjectTemplatesCollector.ProjectType projectType;
            {
                this.defaultName = "ClassLibrary1";
                this.projectType = ProjectTemplatesCollector.ProjectType.Library;
            }

            public String getDefaultName() {
                return this.defaultName;
            }

            protected ProjectTemplatesCollector.ProjectType getProjectType() {
                return this.projectType;
            }

            protected String getType(RdProjectTemplate template2) {
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                String string = super.getType(template2);
                return StringsKt.equals((String)string, (String)"Class Library", (boolean)true) ? string : ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"Library"), (CharSequence)"library"))).toString();
            }

            protected List<RdProjectTemplate> tryGetAcceptableTemplates() {
                boolean bl;
                boolean bl2;
                Iterable iterable;
                List<RdProjectTemplate> list2;
                GraphProperty<ProjectTemplateSdk> graphProperty = this.getSdkProperty();
                List<RdProjectTemplate> list3 = list2 = super.tryGetAcceptableTemplates();
                if (list3 != null) {
                    boolean bl3;
                    block7: {
                        iterable = list3;
                        bl2 = false;
                        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Collection<T> collection : iterable) {
                                RdProjectTemplate rdProjectTemplate = (RdProjectTemplate)collection;
                                boolean bl4 = false;
                                if (!(!Intrinsics.areEqual((Object)rdProjectTemplate.getSdk(), (Object)ProjectTemplateSdk.Companion.getAnyNetSdk()))) continue;
                                bl3 = true;
                                break block7;
                            }
                            bl3 = false;
                        }
                    }
                    bl = bl3;
                } else {
                    bl = false;
                }
                if (bl) {
                    Collection<T> collection;
                    iterable = list2;
                    bl2 = false;
                    Iterable iterable2 = iterable;
                    collection = new ArrayList<E>();
                    boolean bl5 = false;
                    Iterator<T> iterator2 = iterable2.iterator();
                    while (iterator2.hasNext()) {
                        T t = iterator2.next();
                        RdProjectTemplate rdProjectTemplate = (RdProjectTemplate)t;
                        boolean bl6 = false;
                        if (!(Intrinsics.areEqual((Object)rdProjectTemplate.getSdk(), (Object)createGenerator.1.r(graphProperty).getValue()) || ExtensionsKt.getAllTargetFrameworksFromTemplate(rdProjectTemplate).isEmpty())) continue;
                        collection.add(t);
                    }
                    return (List)collection;
                }
                return list2;
            }

            private static final ProjectTemplateSdk r(GraphProperty<ProjectTemplateSdk> graphProperty) {
                return (ProjectTemplateSdk)graphProperty.getValue(null, $$delegatedProperties[0]);
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(createGenerator.1.class, "selectedSdk", "<v#0>", 0)))};
                $$delegatedProperties = kPropertyArray;
            }
        };
    }
}

