/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.indexing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.jetbrains.rider.projectView.indexing.RiderModuleRootData;
import com.jetbrains.rider.projectView.workspace.FileSystemEntity;
import com.jetbrains.rider.workspaceModel.RiderModuleTypeKt;
import com.jetbrains.rider.workspaceModel.WorkspaceExcludeService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/projectView/indexing/RiderFileSystemIndexContributor;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "Lcom/jetbrains/rider/projectView/workspace/FileSystemEntity;", "RiderFileSystemIndexContributor", "()V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "registerFileSets", "", "entity", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "intellij.rider"})
public final class RiderFileSystemIndexContributor
implements WorkspaceFileIndexContributor<FileSystemEntity> {
    @NotNull
    public Class<FileSystemEntity> getEntityClass() {
        return FileSystemEntity.class;
    }

    public void registerFileSets(@NotNull FileSystemEntity entity, @NotNull WorkspaceFileSetRegistrar registrar, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        VirtualFileUrl virtualFileUrl = entity.getUrl();
        ModuleEntity moduleEntity = RiderModuleTypeKt.getRiderModuleEntity(storage);
        Intrinsics.checkNotNull((Object)moduleEntity);
        ModuleBridge moduleBridge = ModuleEntityUtils.findModule((ModuleEntity)moduleEntity, (EntityStorage)storage);
        Intrinsics.checkNotNull((Object)moduleBridge);
        ModuleBridge moduleBridge2 = moduleBridge;
        Project project = moduleBridge2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (WorkspaceExcludeService.Companion.getInstance(project).isExcluded(virtualFileUrl)) {
            return;
        }
        if (entity.getExclude()) {
            registrar.registerExcludedRoot(virtualFileUrl, (WorkspaceEntity)entity);
            return;
        }
        if (entity.getRecursive()) {
            registrar.registerFileSet(virtualFileUrl, WorkspaceFileKind.CONTENT, (WorkspaceEntity)entity, (WorkspaceFileSetData)new RiderModuleRootData((Module)moduleBridge2));
        } else {
            registrar.registerNonRecursiveFileSet(virtualFileUrl, WorkspaceFileKind.CONTENT, (WorkspaceEntity)entity, (WorkspaceFileSetData)new RiderModuleRootData((Module)moduleBridge2));
        }
    }
}

