/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions.scaffolding;

import com.intellij.execution.actions.ActivateRunToolWindowAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdScaffoldingGeneratorTextOutput;
import com.jetbrains.rd.ide.model.RdScaffoldingSessionContext;
import com.jetbrains.rd.ide.model.ScaffoldingGeneratorMessageType;
import com.jetbrains.rd.ide.model.ScaffoldingGeneratorSession;
import com.jetbrains.rd.ide.model.ScaffoldingItemModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.projectView.actions.scaffolding.ScaffoldingConsoleHyperlinkFilter;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/ScaffoldingItemHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "ScaffoldingItemHost", "(Lcom/intellij/openapi/project/Project;)V", "G", "", "context", "Lcom/jetbrains/rd/ide/model/RdScaffoldingSessionContext;", "session", "Lcom/jetbrains/rd/ide/model/ScaffoldingGeneratorSession;", "G", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "projectBasePath", "", "G", "G", "Lcom/intellij/execution/ui/ConsoleView;", "G", "G", "consoleView", "message", "type", "Lcom/jetbrains/rd/ide/model/ScaffoldingGeneratorMessageType;", "Companion", "ProtocolListener", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nScaffoldingItemHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaffoldingItemHost.kt\ncom/jetbrains/rider/projectView/actions/scaffolding/ScaffoldingItemHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,173:1\n13#2:174\n15#3:175\n*S KotlinDebug\n*F\n+ 1 ScaffoldingItemHost.kt\ncom/jetbrains/rider/projectView/actions/scaffolding/ScaffoldingItemHost\n*L\n31#1:174\n31#1:175\n*E\n"})
public final class ScaffoldingItemHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String scaffoldingToolWindowId = "Run";
    @NlsContexts.TabTitle
    @NotNull
    private static final String scaffoldingContentTitle;

    public ScaffoldingItemHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final void G(RdScaffoldingSessionContext rdScaffoldingSessionContext, ScaffoldingGeneratorSession scaffoldingGeneratorSession) {
        try {
            if (ApplicationKt.getApplication().isUnitTestMode()) {
                scaffoldingGeneratorSession.getInitialized().fire((Object)false);
                return;
            }
            String string = rdScaffoldingSessionContext.getProjectBasePath();
            logger.info("Initialize Scaffolding tool window for started session.");
            ToolWindow toolWindow = this.G(this.project);
            if (toolWindow != null) {
                this.G(scaffoldingGeneratorSession, toolWindow, string);
                return;
            }
            ActionManagerEx actionManagerEx = ActionManagerEx.Companion.getInstanceEx();
            ActivateRunToolWindowAction activateRunToolWindowAction = new ActivateRunToolWindowAction();
            InputEvent inputEvent = ActionCommand.getInputEvent((String)scaffoldingToolWindowId);
            ApplicationKt.getApplication().invokeLater(() -> ScaffoldingItemHost.G(actionManagerEx, activateRunToolWindowAction, inputEvent, this, scaffoldingGeneratorSession, string), ModalityState.any());
        }
        catch (Throwable throwable) {
            logger.error("Error setting Scaffolding generator console session", throwable);
            scaffoldingGeneratorSession.getInitialized().fire((Object)false);
        }
    }

    private final void G(ScaffoldingGeneratorSession scaffoldingGeneratorSession, ToolWindow toolWindow, String string) {
        logger.info("Start init Scaffolding content tab for tool window.");
        ConsoleView consoleView = this.G(this.project, toolWindow, string);
        this.G(this.project);
        LifetimeDefinition lifetimeDefinition = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)consoleView));
        scaffoldingGeneratorSession.getGeneratorOutput().advise((Lifetime)lifetimeDefinition, arg_0 -> ScaffoldingItemHost.G(this, consoleView, arg_0));
        scaffoldingGeneratorSession.getInitialized().fire((Object)true);
    }

    private final ToolWindow G(Project project) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(scaffoldingToolWindowId);
        if (toolWindow == null) {
            logger.info("Unable to find Run Tool window for Scaffolding output.");
            return null;
        }
        logger.info("Got Run tool window with with ID '" + toolWindow.getId() + "'");
        return toolWindow;
    }

    private final ConsoleView G(Project project, ToolWindow toolWindow, String string) {
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.findContent(scaffoldingContentTitle);
        if (content != null) {
            contentManager2.removeContent(content, true);
        }
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView consoleView2 = consoleView;
        Content content2 = contentManager2.getFactory().createContent(consoleView2.getComponent(), scaffoldingContentTitle, true);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        toolWindow.getContentManager().addContent(content3);
        consoleView2.addMessageFilter((Filter)new ScaffoldingConsoleHyperlinkFilter(project, string));
        return consoleView2;
    }

    private final void G(Project project) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(scaffoldingToolWindowId);
        if (toolWindow == null) {
            logger.info("Unable to find Scaffolding tool window. Please make sure you start the session.");
            return;
        }
        if (!toolWindow.isActive()) {
            toolWindow.activate(ScaffoldingItemHost::G);
        }
        if (!toolWindow.isVisible()) {
            toolWindow.show();
        }
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.findContent(scaffoldingContentTitle);
        if (content == null) {
            throw new IllegalStateException("Unable to find Scaffolding tool window content with name '" + scaffoldingContentTitle + "'. Please make sure you start the session.");
        }
        Content content2 = content;
        toolWindow.getContentManager().setSelectedContent(content2);
    }

    private final void G(ConsoleView consoleView, String string, ScaffoldingGeneratorMessageType scaffoldingGeneratorMessageType) {
        ConsoleViewContentType consoleViewContentType = switch (WhenMappings.$EnumSwitchMapping$0[scaffoldingGeneratorMessageType.ordinal()]) {
            case 1 -> ConsoleViewContentType.ERROR_OUTPUT;
            case 2 -> ConsoleViewContentType.LOG_WARNING_OUTPUT;
            default -> ConsoleViewContentType.NORMAL_OUTPUT;
        };
        consoleView.print(string + '\n', consoleViewContentType);
    }

    private static final void G(ScaffoldingItemHost scaffoldingItemHost, ScaffoldingGeneratorSession scaffoldingGeneratorSession, String string) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(scaffoldingItemHost.project).getToolWindow(scaffoldingToolWindowId);
        if (toolWindow == null) {
            logger.info("Unable to find Scaffolding tool window. Ignore output.");
            scaffoldingGeneratorSession.getInitialized().fire((Object)false);
            return;
        }
        scaffoldingItemHost.G(scaffoldingGeneratorSession, toolWindow, string);
    }

    private static final void G(ActionManagerEx actionManagerEx, ActivateRunToolWindowAction activateRunToolWindowAction, InputEvent inputEvent, ScaffoldingItemHost scaffoldingItemHost, ScaffoldingGeneratorSession scaffoldingGeneratorSession, String string) {
        actionManagerEx.tryToExecute((AnAction)activateRunToolWindowAction, inputEvent, null, null, true).doWhenProcessed(() -> ScaffoldingItemHost.G(scaffoldingItemHost, scaffoldingGeneratorSession, string));
    }

    private static final Unit G(ScaffoldingItemHost scaffoldingItemHost, ConsoleView consoleView, RdScaffoldingGeneratorTextOutput rdScaffoldingGeneratorTextOutput) {
        Intrinsics.checkNotNullParameter((Object)rdScaffoldingGeneratorTextOutput, (String)"message");
        scaffoldingItemHost.G(consoleView, rdScaffoldingGeneratorTextOutput.getText(), rdScaffoldingGeneratorTextOutput.getType());
        return Unit.INSTANCE;
    }

    private static final void G() {
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(ScaffoldingItemHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
        scaffoldingContentTitle = RiderProjectViewBundle.Companion.message("tool_window.scaffolding.tab.title", new Object[0]);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/ScaffoldingItemHost$Companion;", "", "ScaffoldingItemHost$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "scaffoldingToolWindowId", "", "scaffoldingContentTitle", "getInstance", "Lcom/jetbrains/rider/projectView/actions/scaffolding/ScaffoldingItemHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nScaffoldingItemHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaffoldingItemHost.kt\ncom/jetbrains/rider/projectView/actions/scaffolding/ScaffoldingItemHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,173:1\n31#2,2:174\n*S KotlinDebug\n*F\n+ 1 ScaffoldingItemHost.kt\ncom/jetbrains/rider/projectView/actions/scaffolding/ScaffoldingItemHost$Companion\n*L\n37#1:174,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScaffoldingItemHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<ScaffoldingItemHost> clazz = ScaffoldingItemHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (ScaffoldingItemHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/ScaffoldingItemHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/ScaffoldingItemModel;", "ScaffoldingItemHost$ProtocolListener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider"})
    public static final class ProtocolListener
    implements SolutionExtListener<ScaffoldingItemModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull ScaffoldingItemModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            ScaffoldingGeneratorSession scaffoldingGeneratorSession = model.getScaffoldingGeneratorSession();
            scaffoldingGeneratorSession.getStart().advise(lifetime, arg_0 -> ProtocolListener.G(session, scaffoldingGeneratorSession, arg_0));
            scaffoldingGeneratorSession.getShow().advise(lifetime, arg_0 -> ProtocolListener.G(session, arg_0));
        }

        private static final Unit G(ClientProjectSession clientProjectSession, ScaffoldingGeneratorSession scaffoldingGeneratorSession, RdScaffoldingSessionContext rdScaffoldingSessionContext) {
            Intrinsics.checkNotNullParameter((Object)rdScaffoldingSessionContext, (String)"it");
            Companion.getInstance(clientProjectSession.getProject()).G(rdScaffoldingSessionContext, scaffoldingGeneratorSession);
            return Unit.INSTANCE;
        }

        private static final Unit G(ClientProjectSession clientProjectSession, Unit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
            Companion.getInstance(clientProjectSession.getProject()).G(clientProjectSession.getProject());
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScaffoldingGeneratorMessageType.values().length];
            try {
                nArray[ScaffoldingGeneratorMessageType.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScaffoldingGeneratorMessageType.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

