/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions.renameAction;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rdclient.actions.base.BackendAction;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.model.ProjectModelTasks;
import com.jetbrains.rider.model.ProjectModelTasks_PregeneratedKt;
import com.jetbrains.rider.model.RdRenameItemData;
import com.jetbrains.rider.model.RdRenameItemsCommand;
import com.jetbrains.rider.projectView.ProjectElementView;
import com.jetbrains.rider.projectView.ProjectElementViewKt;
import com.jetbrains.rider.projectView.ProjectEntityView;
import com.jetbrains.rider.projectView.ProjectModelViewExtensionsKt;
import com.jetbrains.rider.projectView.ProjectVirtualFileView;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.actions.ExtensionsKt;
import com.jetbrains.rider.projectView.actions.renameAction.RiderRenameItemDialog;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.SolutionViewEntityOwner;
import com.jetbrains.rider.projectView.views.SolutionViewNode;
import com.jetbrains.rider.projectView.views.SolutionViewPaneBase;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.SolutionViewVisitor;
import com.jetbrains.rider.projectView.views.assemblyExplorer.AssemblyExplorerNode;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewPane;
import com.jetbrains.rider.projectView.views.solutionExplorer.nodes.SolutionExplorerFileNode;
import com.jetbrains.rider.projectView.views.solutionExplorer.nodes.SolutionExplorerModelNode;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J/\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J0\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/projectView/actions/renameAction/RiderRenameItemHandler;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/refactoring/rename/RenameHandler;", "RiderRenameItemHandler", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isRenaming", "", "isAvailableOnDataContext", "Companion", "RenameContext", "intellij.rider"})
public final class RiderRenameItemHandler
extends AnAction
implements RenameHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RiderRenameItemHandler() {
        super(RiderActionsBundle.Companion.message("action.RiderRenameItemHandler.text", new Object[0]), RiderActionsBundle.Companion.message("action.RiderRenameItemHandler.description", new Object[0]), null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project = e2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        e2.getPresentation().setEnabled(ExtensionsKt.isProjectModelReady(project2) && Companion.tryGetRenameContext(e2.getDataContext()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        RenameContext renameContext = Companion.tryGetRenameContext(e2.getDataContext());
        if (renameContext == null) {
            return;
        }
        RenameContext renameContext2 = renameContext;
        Companion.execute(renameContext2, e2);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2, @Nullable DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Presentation presentation = this.getTemplatePresentation();
        DataContext dataContext3 = dataContext2;
        Intrinsics.checkNotNull((Object)dataContext3);
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"Rename", (Presentation)presentation, (DataContext)dataContext3);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        this.actionPerformed(anActionEvent);
    }

    public boolean isRenaming(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        return Companion.tryGetRenameContext(dataContext2) != null;
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        return this.isRenaming(dataContext2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J0\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0018\u0010 \u001a\u0004\u0018\u00010\u00102\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0002J$\u0010#\u001a\u00020\u00052\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0002\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/projectView/actions/renameAction/RiderRenameItemHandler$Companion;", "", "RiderRenameItemHandler$Companion", "()V", "execute", "", "context", "Lcom/jetbrains/rider/projectView/actions/renameAction/RiderRenameItemHandler$RenameContext;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "newName", "", "G", "currentProjectViewPane", "Lcom/jetbrains/rider/projectView/views/SolutionViewPaneBase;", "element", "Lcom/jetbrains/rider/projectView/ProjectElementView;", "updateBackendAction", "", "G", "renameData", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/model/RdRenameItemData;", "Lkotlin/collections/ArrayList;", "G", "nestedFile", "Ljava/nio/file/Path;", "oldParentName", "newParentName", "tryGetRenameContext", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "G", "node", "Lcom/jetbrains/rider/projectView/views/SolutionViewNode;", "G", "nestedNodes", "", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderRenameItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderRenameItemHandler.kt\ncom/jetbrains/rider/projectView/actions/renameAction/RiderRenameItemHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n774#2:265\n865#2,2:266\n808#2,11:268\n808#2,11:279\n1557#2:290\n1628#2,3:291\n*S KotlinDebug\n*F\n+ 1 RiderRenameItemHandler.kt\ncom/jetbrains/rider/projectView/actions/renameAction/RiderRenameItemHandler$Companion\n*L\n159#1:265\n159#1:266,2\n163#1:268,11\n172#1:279,11\n222#1:290\n222#1:291,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void execute(@NotNull RenameContext context, @NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            String string = context.getElement().getName();
            VirtualFile virtualFile = context.getElement().getVirtualFile();
            if (this.updateBackendAction(context, e2)) {
                this.execute(context, "", e2);
                return;
            }
            String string2 = RiderRenameItemDialog.INSTANCE.askForName(string, virtualFile, context.getProject());
            if (string2 == null) {
                return;
            }
            String string3 = string2;
            this.execute(context, string3, e2);
        }

        public final void execute(@NotNull RenameContext context, @NotNull String newName, @NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            if (this.updateBackendAction(context, e2)) {
                BackendActionDelegationKt.backendActionPerformed((String)"RenameElement", (AnActionEvent)e2);
                return;
            }
            Project project = context.getElement().getProject();
            Object[] objectArray = new Object[]{context.getElement().getName()};
            CommandProcessor.getInstance().executeCommand(context.getProject(), () -> Companion.G(context, newName, project), RiderProjectViewBundle.Companion.message("RiderRenameItemHandler.rename.command", objectArray), null);
            WorkspaceModelUpdater.Companion.getInstance(project).doWhenReady(() -> Companion.G(project, context));
        }

        private final void G(SolutionViewPaneBase solutionViewPaneBase, ProjectElementView projectElementView) {
            if (solutionViewPaneBase.isModelProcessing()) {
                ApplicationKt.getApplication().invokeLater(() -> Companion.b(solutionViewPaneBase, projectElementView));
                return;
            }
            ProjectEntityView projectEntityView = projectElementView instanceof ProjectEntityView ? (ProjectEntityView)projectElementView : null;
            ProjectModelEntity projectModelEntity = projectEntityView != null ? projectEntityView.getEntity() : null;
            solutionViewPaneBase.select(projectModelEntity, projectElementView.getVirtualFile(), false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @TestOnly
        public final boolean updateBackendAction(@NotNull RenameContext context, @NotNull AnActionEvent e2) {
            ProjectModelEntity projectModelEntity;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            ProjectElementView projectElementView = context.getElement();
            if (!(projectElementView instanceof ProjectEntityView)) return false;
            ProjectEntityView projectEntityView = (ProjectEntityView)projectElementView;
            if (projectEntityView == null) return false;
            ProjectModelEntity projectModelEntity2 = projectEntityView.getEntity();
            ProjectModelEntity projectModelEntity3 = projectModelEntity = projectModelEntity2;
            if (!(projectModelEntity3 != null ? ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)projectModelEntity3) : false)) {
                ProjectModelEntity projectModelEntity4 = projectModelEntity;
                if (projectModelEntity4 == null) return false;
                if (!ProjectModelEntityExtensionsKt.isProjectFolder((ProjectModelEntity)projectModelEntity4)) return false;
                boolean bl = true;
                if (!bl) return false;
            }
            boolean bl = true;
            boolean bl2 = bl;
            if (!bl2) {
                return false;
            }
            projectElementView = new PresentationFactory();
            BackendAction backendAction = new BackendAction("RenameElement", null, 2, null);
            AnAction[] anActionArray = new AnAction[]{backendAction};
            ActionGroup actionGroup2 = (ActionGroup)new DefaultActionGroup(anActionArray);
            DataContext dataContext2 = e2.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            String string = e2.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            ActionUiKind actionUiKind = e2.getUiKind();
            Intrinsics.checkNotNullExpressionValue((Object)actionUiKind, (String)"getUiKind(...)");
            Utils.expandActionGroup((ActionGroup)actionGroup2, (PresentationFactory)projectElementView, (DataContext)dataContext2, (String)string, (ActionUiKind)actionUiKind);
            return projectElementView.getPresentation((AnAction)backendAction).isEnabled();
        }

        private final void G(ProjectElementView projectElementView, String string, ArrayList<RdRenameItemData> arrayList) {
            if (projectElementView instanceof ProjectEntityView) {
                Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)((ProjectEntityView)projectElementView).getEntity(), (Project)projectElementView.getProject());
                Intrinsics.checkNotNull((Object)n);
                arrayList.add(new RdRenameItemData(n.intValue(), string));
                return;
            }
            ApplicationKt.getApplication().runWriteAction(() -> Companion.G(projectElementView, string));
        }

        private final String G(Path path, String string, String string2) {
            String string3 = ((Object)path.getFileName()).toString();
            String string4 = StringUtil.commonPrefix((String)string3, (String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commonPrefix(...)");
            String string5 = string4;
            if (((CharSequence)string5).length() == 0) {
                return null;
            }
            String string6 = StringsKt.removePrefix((String)string3, (CharSequence)string5);
            if (((CharSequence)string6).length() == 0) {
                return null;
            }
            String string7 = StringsKt.removePrefix((String)string, (CharSequence)string5);
            if (((CharSequence)string7).length() > 0 && !StringsKt.endsWith$default((String)string2, (String)string7, (boolean)false, (int)2, null)) {
                return null;
            }
            String string8 = StringsKt.removeSuffix((String)string2, (CharSequence)string7) + string6;
            if (((CharSequence)string8).length() == 0) {
                return null;
            }
            Path path2 = path.getParent().resolve(string8);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path path3 = path2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            return string8;
        }

        @TestOnly
        @Nullable
        public final RenameContext tryGetRenameContext(@Nullable DataContext dataContext2) {
            Object object5;
            if (dataContext2 == null) {
                return null;
            }
            Iterable iterable = SolutionViewUtilsKt.getSolutionViewNodes(dataContext2);
            boolean bl = false;
            Iterable iterable2 = iterable;
            Iterable iterable3 = new ArrayList();
            boolean bl2 = false;
            for (Object object2 : iterable2) {
                object5 = (AbstractTreeNode)object2;
                boolean bl3 = false;
                if (!(!(object5 instanceof AssemblyExplorerNode))) continue;
                iterable3.add(object2);
            }
            List list2 = (List)iterable3;
            if (list2.isEmpty()) {
                return null;
            }
            Object object3 = list2;
            boolean bl4 = false;
            iterable3 = object3;
            Object object4 = new ArrayList();
            boolean bl5 = false;
            for (Object object5 : iterable3) {
                if (!(object5 instanceof ProjectViewNode)) continue;
                object4.add(object5);
            }
            iterable = (ProjectViewNode)CollectionsKt.singleOrNull((List)((List)object4));
            if (iterable != null) {
                VirtualFile virtualFile = iterable.getVirtualFile();
                if (virtualFile == null) {
                    return null;
                }
                object3 = virtualFile;
                Project project = iterable.getProject();
                Intrinsics.checkNotNull((Object)project);
                return new RenameContext(new ProjectVirtualFileView(project, (VirtualFile)object3), CollectionsKt.emptyList(), dataContext2);
            }
            Object object6 = list2;
            boolean bl6 = false;
            object4 = object6;
            Object object7 = new ArrayList();
            boolean bl7 = false;
            object5 = object4.iterator();
            while (object5.hasNext()) {
                Object e2 = object5.next();
                if (!(e2 instanceof SolutionViewNode)) continue;
                object7.add(e2);
            }
            object3 = (SolutionViewNode)((Object)CollectionsKt.singleOrNull((List)((List)object7)));
            ProjectElementView projectElementView = this.G((SolutionViewNode<?>)((Object)object3));
            if (projectElementView == null && (projectElementView = ProjectElementViewKt.getProjectElementView$default(dataContext2, false, 1, null)) == null) {
                return null;
            }
            object6 = projectElementView;
            if (object6 instanceof ProjectVirtualFileView) {
                VirtualFile virtualFile = ((ProjectVirtualFileView)object6).getVirtualFile();
                object4 = ProjectModelViewExtensionsKt.getBestProjectModelElement(((ProjectElementView)object6).getProject(), virtualFile);
                if (object4 != null && Intrinsics.areEqual((Object)((ProjectElementView)object4).getVirtualFile(), (Object)virtualFile)) {
                    object6 = object4;
                }
            }
            List list3 = new ArrayList();
            this.G((SolutionViewNode<?>)((Object)object3), list3);
            object4 = new RenameContext((ProjectElementView)object6, list3, dataContext2);
            if (object6 instanceof ProjectVirtualFileView) {
                VirtualFile virtualFile = ((ProjectVirtualFileView)object6).getVirtualFile();
                VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)((ProjectElementView)object6).getProject());
                Intrinsics.checkNotNull((Object)virtualFile2);
                if (VfsUtil.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false)) {
                    return null;
                }
                return object4;
            }
            object7 = (ProjectEntityView)object6;
            if (ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)((ProjectEntityView)object7).getEntity()) || ProjectModelEntityExtensionsKt.isProjectFolder((ProjectModelEntity)((ProjectEntityView)object7).getEntity())) {
                return object4;
            }
            return null;
        }

        private final ProjectElementView G(SolutionViewNode<?> solutionViewNode) {
            ProjectModelEntity projectModelEntity;
            if (solutionViewNode == null) {
                return null;
            }
            Project project = solutionViewNode.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            if (!ExtensionsKt.isProjectModelReady(project2)) {
                return null;
            }
            if (solutionViewNode instanceof SolutionViewEntityOwner && (projectModelEntity = ((SolutionViewEntityOwner)((Object)solutionViewNode)).getEntity()) != null) {
                return ProjectModelEntityExtensionsKt.isConnectedToBackend((ProjectModelEntity)projectModelEntity, (Project)project2) ? (ProjectElementView)new ProjectEntityView(project2, projectModelEntity) : null;
            }
            VirtualFile virtualFile = solutionViewNode.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            projectModelEntity = virtualFile;
            return new ProjectVirtualFileView(project2, (VirtualFile)projectModelEntity);
        }

        private final void G(SolutionViewNode<?> solutionViewNode, List<ProjectElementView> list2) {
            if (solutionViewNode == null) {
                return;
            }
            if (solutionViewNode instanceof SolutionExplorerFileNode) {
                for (NestingNode<VirtualFile> abstractTreeNode : ((SolutionExplorerFileNode)solutionViewNode).getNestedNodes()) {
                    Iterable iterable = abstractTreeNode.getWithChildren();
                    List<ProjectElementView> list3 = list2;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        NestingNode nestingNode = (NestingNode)t;
                        Collection collection2 = collection;
                        boolean bl3 = false;
                        Project project = ((SolutionExplorerFileNode)solutionViewNode).getProject();
                        Intrinsics.checkNotNull((Object)project);
                        collection2.add(new ProjectVirtualFileView(project, (VirtualFile)nestingNode.getValue()));
                    }
                    list3.addAll((List)collection);
                }
            }
            if (solutionViewNode instanceof SolutionExplorerModelNode) {
                ProjectModelEntity projectModelEntity = ((SolutionExplorerModelNode)solutionViewNode).getEntity();
                boolean bl = projectModelEntity != null ? ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)projectModelEntity) : false;
                if (bl) {
                    for (AbstractTreeNode abstractTreeNode : ((SolutionExplorerModelNode)solutionViewNode).getChildren()) {
                        if (!(abstractTreeNode instanceof SolutionViewNode)) continue;
                        this.G((SolutionViewNode)abstractTreeNode, list2);
                    }
                }
            }
        }

        private static final void G(RenameContext renameContext, String string, Project project) {
            ProjectElementView projectElementView2;
            String string2 = renameContext.getElement().getName();
            ArrayList<RdRenameItemData> arrayList = new ArrayList<RdRenameItemData>();
            Companion.G(renameContext.getElement(), string, arrayList);
            for (ProjectElementView projectElementView2 : renameContext.getNestedElement()) {
                String string3;
                Path path;
                if (projectElementView2.getPath() == null || Companion.G(path, string2, string) == null) continue;
                Companion.G(projectElementView2, string3, arrayList);
            }
            ProjectModelTasks projectModelTasks = ProjectModelTasks_PregeneratedKt.getProjectModelTasks((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
            projectElementView2 = new RdRenameItemsCommand((List)arrayList);
            com.jetbrains.rider.util.idea.ExtensionsKt.runCommandUnderProgress$default((IRdCall)((IRdCall)projectModelTasks.getRename()), (Object)projectElementView2, (Project)project, (String)RiderActionsBundle.Companion.message("action.RiderRenameItemHandler.text", new Object[0]), (boolean)false, (boolean)false, (boolean)false, (int)56, null);
        }

        private static final Unit G(Project project, RenameContext renameContext) {
            ProjectView projectView = ProjectView.getInstance((Project)project);
            AbstractProjectViewPane abstractProjectViewPane = projectView.getCurrentProjectViewPane();
            SolutionViewPaneBase solutionViewPaneBase = abstractProjectViewPane instanceof SolutionViewPaneBase ? (SolutionViewPaneBase)abstractProjectViewPane : null;
            if (solutionViewPaneBase == null) {
                return Unit.INSTANCE;
            }
            SolutionViewPaneBase solutionViewPaneBase2 = solutionViewPaneBase;
            Companion.G(solutionViewPaneBase2, renameContext.getElement());
            return Unit.INSTANCE;
        }

        private static final void b(SolutionViewPaneBase solutionViewPaneBase, ProjectElementView projectElementView) {
            Companion.G(solutionViewPaneBase, projectElementView);
        }

        private static final void G(ProjectElementView projectElementView, String string) {
            block3: {
                SolutionExplorerViewPane solutionExplorerViewPane;
                VirtualFile virtualFile = projectElementView.getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                VirtualFile virtualFile2 = virtualFile;
                try {
                    virtualFile2.rename((Object)Companion, string);
                }
                catch (IOException iOException) {
                    Messages.showErrorDialog((String)iOException.getMessage(), (String)RiderProjectViewBundle.Companion.message("RiderRenameItemHandler.dialog.title.can.not.perform.rename", new Object[0]));
                }
                SolutionExplorerViewPane solutionExplorerViewPane2 = solutionExplorerViewPane = SolutionExplorerViewPane.Companion.tryGetInstance(projectElementView.getProject());
                if (solutionExplorerViewPane2 == null) break block3;
                VirtualFile virtualFile3 = virtualFile2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getParent(...)");
                solutionExplorerViewPane2.refresh(SolutionViewVisitor.Companion.createForRefresh(virtualFile3), false, true);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/projectView/actions/renameAction/RiderRenameItemHandler$RenameContext;", "", "element", "Lcom/jetbrains/rider/projectView/ProjectElementView;", "nestedElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "RiderRenameItemHandler$RenameContext", "(Lcom/jetbrains/rider/projectView/ProjectElementView;Ljava/util/List;Lcom/intellij/openapi/actionSystem/DataContext;)V", "getElement", "()Lcom/jetbrains/rider/projectView/ProjectElementView;", "getNestedElement", "()Ljava/util/List;", "getDataContext", "()Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    public static final class RenameContext {
        @NotNull
        private final ProjectElementView element;
        @NotNull
        private final List<ProjectElementView> nestedElement;
        @NotNull
        private final DataContext dataContext;
        @NotNull
        private final Project project;

        public RenameContext(@NotNull ProjectElementView element, @NotNull List<? extends ProjectElementView> nestedElement, @NotNull DataContext dataContext2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(nestedElement, (String)"nestedElement");
            Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
            this.element = element;
            this.nestedElement = nestedElement;
            this.dataContext = dataContext2;
            this.project = this.element.getProject();
        }

        @NotNull
        public final ProjectElementView getElement() {
            return this.element;
        }

        @NotNull
        public final List<ProjectElementView> getNestedElement() {
            return this.nestedElement;
        }

        @NotNull
        public final DataContext getDataContext() {
            return this.dataContext;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }
    }
}

