/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.projectView.views.SolutionViewEntityOwner;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/projectView/actions/RevealBaseDirectoryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "RevealBaseDirectoryAction", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "G", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider"})
public final class RevealBaseDirectoryAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        VirtualFile virtualFile = this.G(e2);
        if (virtualFile == null || !RevealFileAction.isSupported()) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String string2 = virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2;
        String string4 = RevealFileAction.getFileManagerName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFileManagerName(...)");
        String string5 = string4;
        Presentation presentation = e2.getPresentation();
        if (SystemInfo.isMac) {
            Object[] objectArray = new Object[]{string3};
            string = RiderProjectViewBundle.Companion.message("RevealBaseDirectoryAction.name.mac", objectArray);
        } else {
            Object[] objectArray = new Object[]{string3, string5};
            string = RiderProjectViewBundle.Companion.message("RevealBaseDirectoryAction.name.other", objectArray);
        }
        presentation.setText(string);
        e2.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        VirtualFile virtualFile = this.G(e2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        RevealFileAction.openDirectory((File)VfsUtil.virtualToIoFile((VirtualFile)virtualFile2));
    }

    private final VirtualFile G(AnActionEvent anActionEvent) {
        DataContext dataContext2 = anActionEvent.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Object object = CollectionsKt.singleOrNull(SolutionViewUtilsKt.getSolutionViewNodes(dataContext2));
        SolutionViewEntityOwner solutionViewEntityOwner = object instanceof SolutionViewEntityOwner ? (SolutionViewEntityOwner)object : null;
        if (solutionViewEntityOwner == null) {
            return null;
        }
        SolutionViewEntityOwner solutionViewEntityOwner2 = solutionViewEntityOwner;
        ProjectModelEntity projectModelEntity = solutionViewEntityOwner2.getEntity();
        Object object2 = projectModelEntity != null ? projectModelEntity.getDescriptor() : null;
        Object object3 = object2 instanceof RdProjectDescriptor ? (RdProjectDescriptor)object2 : null;
        if (object3 == null || (object3 = object3.getBaseDirectory()) == null) {
            return null;
        }
        Object object4 = object3;
        return VfsUtil.findFileByIoFile((File)new File((String)object4), (boolean)false);
    }
}

