/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions;

import com.intellij.openapi.project.Project;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityVisitor;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/projectView/actions/ProjectEntitiesCollector;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityVisitor;", "project", "Lcom/intellij/openapi/project/Project;", "ProjectEntitiesCollector", "(Lcom/intellij/openapi/project/Project;)V", "projectIds", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getProjectIds", "()Ljava/util/HashSet;", "unloadedProjectIds", "getUnloadedProjectIds", "filteredProjectIds", "getFilteredProjectIds", "visitUnloadedProject", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityVisitor$Result;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "visitProject", "visit", "", "entities", "", "intellij.rider"})
public final class ProjectEntitiesCollector
extends ProjectModelEntityVisitor {
    @NotNull
    private final Project project;
    @NotNull
    private final HashSet<Integer> projectIds;
    @NotNull
    private final HashSet<Integer> unloadedProjectIds;
    @NotNull
    private final HashSet<Integer> filteredProjectIds;

    public ProjectEntitiesCollector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.projectIds = new HashSet();
        this.unloadedProjectIds = new HashSet();
        this.filteredProjectIds = new HashSet();
    }

    @NotNull
    public final HashSet<Integer> getProjectIds() {
        return this.projectIds;
    }

    @NotNull
    public final HashSet<Integer> getUnloadedProjectIds() {
        return this.unloadedProjectIds;
    }

    @NotNull
    public final HashSet<Integer> getFilteredProjectIds() {
        return this.filteredProjectIds;
    }

    @NotNull
    protected ProjectModelEntityVisitor.Result visitUnloadedProject(@NotNull ProjectModelEntity entity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)entity, (Project)this.project);
            if (n == null) break block0;
            int n2 = ((Number)n).intValue();
            boolean bl = false;
            boolean bl2 = ProjectModelEntityExtensionsKt.isFilteredProject((ProjectModelEntity)entity) ? this.filteredProjectIds.add(n2) : this.unloadedProjectIds.add(n2);
        }
        return ProjectModelEntityVisitor.Result.Stop;
    }

    @NotNull
    protected ProjectModelEntityVisitor.Result visitProject(@NotNull ProjectModelEntity entity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)entity, (Project)this.project);
            if (n == null) break block0;
            int n2 = ((Number)n).intValue();
            boolean bl = false;
            this.projectIds.add(n2);
        }
        return ProjectModelEntityVisitor.Result.Stop;
    }

    public final void visit(@NotNull List<? extends ProjectModelEntity> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        for (ProjectModelEntity projectModelEntity : entities) {
            this.visit(projectModelEntity);
        }
    }
}

