/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.jetbrains.rider.projectView.ProjectElementView;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/projectView/ProjectEntityView;", "Lcom/jetbrains/rider/projectView/ProjectElementView;", "project", "Lcom/intellij/openapi/project/Project;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "ProjectEntityView", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "getEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "name", "", "getName", "()Ljava/lang/String;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider"})
public final class ProjectEntityView
extends ProjectElementView {
    @NotNull
    private final ProjectModelEntity entity;

    public ProjectEntityView(@NotNull Project project, @NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super(project, null);
        this.entity = entity;
    }

    @NotNull
    public final ProjectModelEntity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public String getName() {
        return this.entity.getName();
    }

    @Override
    @Nullable
    public Path getPath() {
        VirtualFileUrl virtualFileUrl = this.entity.getUrl();
        return virtualFileUrl != null ? VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)virtualFileUrl) : null;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFileUrl virtualFileUrl = this.entity.getUrl();
        return virtualFileUrl != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl) : null;
    }
}

