/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.problemsView.views.panels;

import com.intellij.analysis.problemsView.toolWindow.ProblemsViewTab;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.model.SolutionAnalysisIssuesState;
import com.jetbrains.rider.model.SolutionAnalysisModel;
import com.jetbrains.rider.problemsView.ProblemsViewUtils;
import com.jetbrains.rider.problemsView.RiderProblemsViewBundle;
import com.jetbrains.rider.problemsView.views.RiderProblemsViewIndicationService;
import com.jetbrains.rider.problemsView.views.RiderProblemsViewSWEAPreview;
import com.jetbrains.rider.problemsView.views.panels.RiderProblemsViewTabPanelWithStats;
import com.jetbrains.rider.solutionAnalysis.ui.SolutionAnalysisToolWindowPanel;
import java.awt.Color;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 *2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001*B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0000H\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020!H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020#H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/problemsView/views/panels/RiderProblemsViewSWEAPanel;", "Lcom/intellij/ui/OnePixelSplitter;", "Lcom/jetbrains/rider/problemsView/views/panels/RiderProblemsViewTabPanelWithStats;", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewTab;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/rider/model/SolutionAnalysisModel;", "iconController", "Lcom/jetbrains/rider/problemsView/views/RiderProblemsViewIndicationService;", "RiderProblemsViewSWEAPanel", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/model/SolutionAnalysisModel;Lcom/jetbrains/rider/problemsView/views/RiderProblemsViewIndicationService;)V", "getModel", "()Lcom/jetbrains/rider/model/SolutionAnalysisModel;", "myPreview", "Lcom/jetbrains/rider/problemsView/views/RiderProblemsViewSWEAPreview;", "sweaPanel", "Lcom/jetbrains/rider/solutionAnalysis/ui/SolutionAnalysisToolWindowPanel;", "myProject", "selectedTime", "", "getSelectedTime", "()J", "setSelectedTime", "(J)V", "deselectedTime", "getDeselectedTime", "setDeselectedTime", "G", "", "panel", "orientationChangedTo", "vertical", "", "getIssuesCount", "", "getTabId", "", "getProject", "showPreview", "getName", "count", "Companion", "intellij.rider"})
public final class RiderProblemsViewSWEAPanel
extends OnePixelSplitter
implements RiderProblemsViewTabPanelWithStats,
ProblemsViewTab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolutionAnalysisModel model;
    @NotNull
    private final RiderProblemsViewIndicationService iconController;
    @NotNull
    private final RiderProblemsViewSWEAPreview myPreview;
    @NotNull
    private final SolutionAnalysisToolWindowPanel sweaPanel;
    @NotNull
    private final Project myProject;
    private long selectedTime;
    private long deselectedTime;
    @NotNull
    private static final String tabName = RiderProblemsViewBundle.Companion.message("swea.panel.title", new Object[0]);
    @NotNull
    public static final String ID = "SWEA";

    public RiderProblemsViewSWEAPanel(@NotNull Project project, @NotNull SolutionAnalysisModel model, @NotNull RiderProblemsViewIndicationService iconController) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)iconController, (String)"iconController");
        this.model = model;
        this.iconController = iconController;
        this.myPreview = new RiderProblemsViewSWEAPreview(project, this);
        this.sweaPanel = new SolutionAnalysisToolWindowPanel(project, this.myPreview);
        this.myProject = project;
        this.setFirstComponent((JComponent)((Object)this.sweaPanel));
        RiderProblemsViewSWEAPanel riderProblemsViewSWEAPanel = this;
        this.model.getIssuesState().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> RiderProblemsViewSWEAPanel.G(this, project, riderProblemsViewSWEAPanel, arg_0));
    }

    @NotNull
    public final SolutionAnalysisModel getModel() {
        return this.model;
    }

    @Override
    public long getSelectedTime() {
        return this.selectedTime;
    }

    @Override
    public void setSelectedTime(long l) {
        this.selectedTime = l;
    }

    @Override
    public long getDeselectedTime() {
        return this.deselectedTime;
    }

    @Override
    public void setDeselectedTime(long l) {
        this.deselectedTime = l;
    }

    private final void G(Project project, RiderProblemsViewSWEAPanel riderProblemsViewSWEAPanel) {
        int n = this.getIssuesCount();
        ProblemsViewUtils.INSTANCE.updateToolWindowTabHeader(project, (JComponent)((Object)riderProblemsViewSWEAPanel), this.getName(n));
    }

    public void orientationChangedTo(boolean vertical) {
        JComponent jComponent = this.sweaPanel.getToolbar();
        ActionToolbar actionToolbar = jComponent instanceof ActionToolbar ? (ActionToolbar)jComponent : null;
        if (actionToolbar == null) {
            return;
        }
        ActionToolbar actionToolbar2 = actionToolbar;
        this.setOrientation(vertical);
        this.sweaPanel.remove(actionToolbar2.getComponent());
        actionToolbar2.setOrientation(vertical ? 0 : 1);
        this.sweaPanel.add(vertical ? "North" : "West", actionToolbar2.getComponent());
    }

    @Override
    public int getIssuesCount() {
        SolutionAnalysisIssuesState solutionAnalysisIssuesState = (SolutionAnalysisIssuesState)this.model.getIssuesState().getValueOrNull();
        if (solutionAnalysisIssuesState == null) {
            return 0;
        }
        SolutionAnalysisIssuesState solutionAnalysisIssuesState2 = solutionAnalysisIssuesState;
        return solutionAnalysisIssuesState2.getWarningCount() + solutionAnalysisIssuesState2.getErrorCount();
    }

    @Override
    @NotNull
    public String getTabId() {
        return ID;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public boolean showPreview() {
        return this.sweaPanel.getShowPreview();
    }

    @NotNull
    public String getName(int count) {
        String string;
        if (this.getIssuesCount() <= 0) {
            string = tabName;
        } else {
            String string2 = new HtmlBuilder().append(tabName).append(" ").append((HtmlChunk)HtmlChunk.tag((String)"font").attr("color", ColorUtil.toHtmlColor((Color)UIUtil.getInactiveTextColor())).addText(String.valueOf(this.getIssuesCount()))).wrapWithHtmlBody().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    private static final Unit G(RiderProblemsViewSWEAPanel riderProblemsViewSWEAPanel, Project project, RiderProblemsViewSWEAPanel riderProblemsViewSWEAPanel2, SolutionAnalysisIssuesState solutionAnalysisIssuesState) {
        Intrinsics.checkNotNullParameter((Object)solutionAnalysisIssuesState, (String)"it");
        riderProblemsViewSWEAPanel.G(project, riderProblemsViewSWEAPanel2);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/problemsView/views/panels/RiderProblemsViewSWEAPanel$Companion;", "", "RiderProblemsViewSWEAPanel$Companion", "()V", "tabName", "", "getTabName", "()Ljava/lang/String;", "ID", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTabName() {
            return tabName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

